/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.ng.jna.FbClientFeature;
import org.firebirdsql.gds.ng.jna.FbClientFeatureAccess;
import org.firebirdsql.jna.fbclient.FbClientLibrary;

class FbClientFeatureAccessHandler
implements InvocationHandler {
    private static final Method HAS_FEATURE;
    private static final Method GET_FEATURES;
    private final FbClientLibrary clientLibrary;
    private final Set<FbClientFeature> clientFeatures;
    private final InvocationHandler delegatedHandler;

    private FbClientFeatureAccessHandler(FbClientLibrary clientLibrary, Set<FbClientFeature> clientFeatures, InvocationHandler delegatedHandler) {
        this.clientLibrary = clientLibrary;
        this.clientFeatures = clientFeatures;
        this.delegatedHandler = delegatedHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] inArgs) throws Throwable {
        if (HAS_FEATURE.equals(method)) {
            return this.clientFeatures.contains(inArgs[0]);
        }
        if (GET_FEATURES.equals(method)) {
            return this.clientFeatures;
        }
        return this.delegatedHandler.invoke(this.clientLibrary, method, inArgs);
    }

    static FbClientLibrary decorateWithFeatureAccess(FbClientLibrary library) {
        Class<?> libraryClass = library.getClass();
        if (!Proxy.isProxyClass(libraryClass)) {
            throw new IllegalArgumentException("Could not decorate client library with FbClientFeatureAccess: not a proxy");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Could not decorate client library with FbClientFeatureAccess: unexpected invocation handler type " + ih.getClass());
        }
        Library.Handler originalHandler = (Library.Handler)ih;
        Set<FbClientFeature> clientFeatures = FbClientFeatureAccessHandler.determineClientFeatures(originalHandler);
        InvocationHandler delegatedHandler = FbClientFeatureAccessHandler.syncWrapIfNecessary(library, originalHandler);
        FbClientFeatureAccessHandler fbClientFeatureAccessHandler = new FbClientFeatureAccessHandler(library, clientFeatures, delegatedHandler);
        Class interfaceClass = originalHandler.getInterfaceClass();
        ClassLoader loader = interfaceClass.getClassLoader();
        Object proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceClass, FbClientFeatureAccess.class}, (InvocationHandler)fbClientFeatureAccessHandler);
        return (FbClientLibrary)proxy;
    }

    private static Set<FbClientFeature> determineClientFeatures(Library.Handler originalHandler) {
        NativeLibrary nativeLibrary = originalHandler.getNativeLibrary();
        EnumSet<FbClientFeature> features = EnumSet.allOf(FbClientFeature.class);
        block0: for (FbClientFeature feature : FbClientFeature.values()) {
            for (String methodName : feature.methodNames()) {
                if (FbClientFeatureAccessHandler.hasMethod(nativeLibrary, methodName)) continue;
                features.remove((Object)feature);
                continue block0;
            }
        }
        return features;
    }

    private static boolean hasMethod(NativeLibrary nativeLibrary, String methodName) {
        try {
            return nativeLibrary.getFunction(methodName) != null;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static InvocationHandler syncWrapIfNecessary(final FbClientLibrary clientLibrary, final Library.Handler originalHandler) {
        if (JaybirdSystemProperties.isSyncWrapNativeLibrary()) {
            return new InvocationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    NativeLibrary nativeLibrary = originalHandler.getNativeLibrary();
                    synchronized (nativeLibrary) {
                        return originalHandler.invoke((Object)clientLibrary, method, args);
                    }
                }
            };
        }
        return originalHandler;
    }

    static {
        try {
            HAS_FEATURE = FbClientFeatureAccess.class.getMethod("hasFeature", FbClientFeature.class);
            GET_FEATURES = FbClientFeatureAccess.class.getMethod("getFeatures", new Class[0]);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

