/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeProcedure;
import com.dbeaver.db.snowflake.model.SnowflakeSequence;
import com.dbeaver.db.snowflake.model.SnowflakeTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.snowflake.model.SnowflakeMetaModel;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class SnowflakeMetaModelExt
extends SnowflakeMetaModel {
    private static final Log log = Log.getLog(SnowflakeMetaModelExt.class);

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase table, @Nullable String objectName) throws SQLException {
        DBSObject parentObject = owner.getParentObject();
        String sql = "SELECT TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM, COMMENT AS REMARKS, t.* FROM " + (parentObject != null ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + "." : "") + "INFORMATION_SCHEMA.\"TABLES\" t\n" + "WHERE TABLE_CATALOG = ?\n" + "AND TABLE_SCHEMA  = ?" + (table != null ? " AND TABLE_NAME=?" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        if (parentObject != null) {
            dbStat.setString(1, parentObject.getName());
        } else {
            dbStat.setString(1, "%");
        }
        dbStat.setString(2, owner.getName());
        if (table != null || objectName != null) {
            dbStat.setString(3, table != null ? table.getName() : objectName);
        }
        return dbStat;
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && tableType.equalsIgnoreCase("VIEW")) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new SnowflakeTable(container, tableName, tableType, dbResult);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<GenericSequence> loadSequences(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        DBSObject parentObject = container.getParentObject();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read sequences");){
                ArrayList<GenericSequence> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block32: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = session.prepareStatement("SELECT * FROM " + (parentObject != null ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + "." : "") + "INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA =?");
                    dbStat.setString(1, container.getSchema().getName());
                    ArrayList<GenericSequence> sequenceList = new ArrayList<GenericSequence>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEQUENCE_NAME");
                            if (name == null) continue;
                            name = name.trim();
                            SnowflakeSequence sequence = new SnowflakeSequence(container, name, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENT"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"LAST_VALUE"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MINIMUM_VALUE"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAXIMUM_VALUE"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INCREMENT"), dbResult);
                            sequenceList.add(sequence);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = sequenceList;
                    if (dbStat == null) break block32;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Can't read sequence list from database", (Throwable)e);
            return super.loadSequences(monitor, container);
        }
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        DBSObject parentObject = container.getParentObject();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read procedures/functions");){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT 'PROCEDURE' AS PROC_TYPE, p.PROCEDURE_NAME AS PROC_NAME, p.ARGUMENT_SIGNATURE, p.DATA_TYPE,\np.PROCEDURE_LANGUAGE AS P_LANGUAGE, p.CREATED, p.LAST_ALTERED, p.\"COMMENT\"\n FROM " + (parentObject != null ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + "." : "") + "INFORMATION_SCHEMA.PROCEDURES p\n" + "WHERE p.PROCEDURE_SCHEMA = ?\n" + "UNION ALL\n" + "SELECT 'FUNCTION' AS PROC_TYPE, f.FUNCTION_NAME, f.ARGUMENT_SIGNATURE, f.DATA_TYPE,\n" + "f.FUNCTION_LANGUAGE AS P_LANGUAGE, f.CREATED, f.LAST_ALTERED, f.\"COMMENT\"\n FROM " + (parentObject != null ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + "." : "") + "INFORMATION_SCHEMA.\"FUNCTIONS\" f\n" + "WHERE f.FUNCTION_SCHEMA = ?");){
                    String containerName = container.getName();
                    dbStat.setString(1, containerName);
                    dbStat.setString(2, containerName);
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.nextRow()) {
                            String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROC_NAME");
                            String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENT");
                            String procType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROC_TYPE");
                            DBSProcedureType type = DBSProcedureType.PROCEDURE;
                            GenericFunctionResultType resultType = null;
                            if ("FUNCTION".equals(procType)) {
                                type = DBSProcedureType.FUNCTION;
                                resultType = GenericFunctionResultType.UNKNOWN;
                            }
                            SnowflakeProcedure procedure = new SnowflakeProcedure((GenericStructContainer)container, procName, description, type, resultType, dbResult);
                            container.addProcedure((GenericProcedure)procedure);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read procedures/functions from database", (Throwable)e);
        }
    }
}

