/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.edit;

import com.dbeaver.db.snowflake.model.SnowflakeSequence;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSequenceManager
extends SQLObjectEditor<SnowflakeSequence, GenericSchema>
implements DBEObjectRenamer<SnowflakeSequence> {
    public boolean canCreateObject(Object container) {
        return false;
    }

    protected SnowflakeSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        throw new IllegalStateException("Not implemented");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop sequence", "DROP SEQUENCE " + ((SnowflakeSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, SnowflakeSequence> getObjectsCache(SnowflakeSequence object) {
        return null;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        SnowflakeSequence sequence = (SnowflakeSequence)command.getObject();
        if (command.hasProperty((Object)"incrementBy")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " SET INCREMENT BY = " + sequence.getIncrementBy()));
        }
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<SnowflakeSequence, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        SnowflakeSequence sequence = (SnowflakeSequence)command.getObject();
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " SET COMMENT = " + SQLUtils.quoteString((DBSObject)sequence, (String)CommonUtils.notEmpty((String)sequence.getDescription()))));
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SnowflakeSequence object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        SnowflakeSequence sequence = (SnowflakeSequence)command.getObject();
        String fullName = DBUtils.getQuotedIdentifier((DBPDataSource)sequence.getDataSource(), (String)command.getNewName());
        DBSObject schema = sequence.getParentObject();
        if (schema != null) {
            fullName = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)schema)) + "." + fullName;
            DBSObject catalog = schema.getParentObject();
            if (catalog != null) {
                fullName = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)catalog)) + "." + fullName;
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME TO " + fullName));
    }
}

