/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.wmi.model.WMIObjectCollectorSink;
import org.jkiss.dbeaver.ext.wmi.model.WMIResultSet;
import org.jkiss.dbeaver.ext.wmi.model.WMISession;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIObjectSink;
import org.jkiss.wmi.service.WMIService;

public class WMIStatement
implements DBCStatement {
    private WMISession session;
    private DBCStatementType type;
    private String query;
    private List<WMIObject> queryResult;
    private long firstRow;
    private long maxRows;
    private DBCExecutionSource source;

    public WMIStatement(WMISession session, DBCStatementType type, String query) {
        this.session = session;
        this.type = type;
        this.query = query;
    }

    WMIService getService() {
        return this.session.getDataSource().getService();
    }

    @NotNull
    public DBCSession getSession() {
        return this.session;
    }

    @Nullable
    public String getQueryString() {
        return this.query;
    }

    public boolean executeStatement() throws DBCException {
        try {
            WMIObjectCollectorSink sink = new WMIObjectCollectorSink(this.session.getProgressMonitor(), this.getService(), this.firstRow, this.maxRows);
            this.getService().executeQuery(this.query, (WMIObjectSink)sink, 128L);
            sink.waitForFinish();
            this.queryResult = sink.getObjectList();
            return true;
        }
        catch (WMIException e) {
            throw new DBCException((Throwable)e, this.session.getExecutionContext());
        }
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Batches not supported");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Batches not supported");
    }

    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        if (this.queryResult == null) {
            return null;
        }
        try {
            return new WMIResultSet((DBCSession)this.session, null, this.queryResult);
        }
        catch (WMIException e) {
            throw new DBCException((Throwable)e, this.session.getExecutionContext());
        }
    }

    @Nullable
    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not Implemented");
    }

    public long getUpdateRowCount() throws DBCException {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.firstRow = offset;
        this.maxRows = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    @Nullable
    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(DBCExecutionSource source) {
        this.source = source;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
    }
}

