/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.sql.SQLException;

public class ASAUDPUtil {
    static final int ASAPort = 2638;
    private static final int SERVERNAME = 0;
    private static final int PORTNUMBER = 1;
    private static final int IPADDRESS = 2;
    private static final int SENDER = 3;
    private static final int REQNUM = 4;
    private static final int DBNSVERSION = 5;
    private static final int DATABASE = 6;
    private static final int SWVERSION = 7;
    private static final int ALTSERVER = 8;
    private ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private ByteArrayInputStream _bais = null;
    private int _portnumber = -1;
    private String _ipaddr = null;
    private byte[] _version = new byte[2];
    private byte[] _reqnum = new byte[8];
    private byte[] _sender = new byte[1];
    private byte[] _port = new byte[2];

    public String lookupServer(String string) throws SQLException {
        try {
            this.writeNTString("STRMBROAD" + string);
            this.writeBroadcastHeader(5);
            this.writeSection(0, string);
            this.writeSection(1, "0");
            this.writeSection(3, "");
            this.writeSection(4, "0");
            this.writeSection(7, "10.0.1");
            byte[] byArray = this._baos.toByteArray();
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(2000);
            InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 2638);
            datagramSocket.send(datagramPacket);
            byte[] byArray2 = new byte[2500];
            datagramPacket = new DatagramPacket(byArray2, byArray2.length);
            datagramSocket.receive(datagramPacket);
            this._bais = new ByteArrayInputStream(byArray2);
            this.readNTString();
            int n = this.readBroadcastHeader();
            for (int i = 0; i < n; ++i) {
                this.readSection();
            }
            if (this._ipaddr == null) {
                InetAddress inetAddress2 = datagramPacket.getAddress();
                this._ipaddr = inetAddress2.getHostAddress();
            }
            datagramSocket.close();
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ029", string, exception.toString());
        }
        return this._ipaddr + ":" + this._portnumber;
    }

    private void writeSection(int n, String string) throws IOException {
        int n2 = 0;
        this._baos.write(n);
        switch (n) {
            case 0: {
                n2 = string.length() + 1;
                this._baos.write(n2);
                this.writeNTString(string);
                break;
            }
            case 1: {
                n2 = 2;
                this._baos.write(n2);
                int n3 = Integer.parseInt(string);
                this._baos.write(0xFF00 & n3);
                this._baos.write(0xFF & n3);
                break;
            }
            case 3: {
                n2 = 1;
                this._baos.write(n2);
                this._baos.write(1);
                break;
            }
            case 4: {
                n2 = 8;
                this._baos.write(n2);
                for (int i = 0; i < n2; ++i) {
                    this._baos.write(0);
                }
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                throw new IllegalArgumentException();
            }
            case 7: {
                this._baos.write(2);
                this._baos.write(3);
                this._baos.write(233);
            }
        }
    }

    private void readSection() throws UnsupportedEncodingException, IOException {
        int n = this._bais.read();
        int n2 = this._bais.read();
        switch (n) {
            case 0: {
                this.readNTString();
                break;
            }
            case 1: {
                int n3 = this._bais.read();
                int n4 = this._bais.read();
                this._portnumber = n3 << 8 | n4;
                this._port[0] = (byte)n3;
                this._port[1] = (byte)n4;
                break;
            }
            case 3: {
                this._bais.read(this._sender);
                break;
            }
            case 4: {
                this._bais.read(this._reqnum);
                break;
            }
            case 2: {
                this._ipaddr = this.readNTString();
                break;
            }
            case 7: {
                this._bais.read(this._version);
                break;
            }
            default: {
                for (int i = 0; i < n2; ++i) {
                    this._bais.read();
                }
            }
        }
    }

    private void writeBroadcastHeader(int n) {
        this._baos.write(0);
        this._baos.write(4);
        this._baos.write(0);
        this._baos.write(4);
        this._baos.write(0);
        this._baos.write(n);
    }

    private int readBroadcastHeader() throws IOException {
        this._bais.read(new byte[4]);
        int n = this._bais.read();
        int n2 = this._bais.read();
        return n << 8 | n2;
    }

    private void writeNTString(String string) throws IOException, UnsupportedEncodingException {
        this._baos.write(string.getBytes("ASCII"));
        this._baos.write(0);
    }

    private String readNTString() throws UnsupportedEncodingException {
        int n;
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this._bais.read()) != 0) {
            byteArrayOutputStream.write(n);
        }
        string = new String(byteArrayOutputStream.toByteArray(), "ASCII");
        return string;
    }
}

