/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1Object;
import com.sybase.jdbc4.security.asn1.ASN1OctetString;
import com.sybase.jdbc4.security.asn1.ASN1TaggedObject;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import com.sybase.jdbc4.security.asn1.DERString;
import java.io.IOException;

public class DERNumericString
extends ASN1Object
implements DERString {
    String string;

    public static DERNumericString getInstance(Object object) {
        if (object == null || object instanceof DERNumericString) {
            return (DERNumericString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERNumericString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERNumericString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERNumericString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERNumericString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERNumericString(String string) {
        this(string, false);
    }

    public DERNumericString(String string, boolean bl) {
        if (bl && !DERNumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(18, this.getOctets());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = (DERNumericString)dERObject;
        return this.getString().equals(dERNumericString.getString());
    }

    public static boolean isNumericString(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                return false;
            }
            if ('0' <= c && c <= '9' || c == ' ') continue;
            return false;
        }
        return true;
    }
}

