/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1InputStream;
import com.sybase.jdbc4.security.asn1.ASN1Object;
import com.sybase.jdbc4.security.asn1.DEREncodable;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1Object {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this.tag = n | 0x20;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        this.octets = byteArrayOutputStream.toByteArray();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(0x40 | this.tag, this.octets);
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        if (this.tag != dERApplicationSpecific.tag) {
            return false;
        }
        if (this.octets.length != dERApplicationSpecific.octets.length) {
            return false;
        }
        for (int i = 0; i < this.octets.length; ++i) {
            if (this.octets[i] == dERApplicationSpecific.octets[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        byte[] byArray = this.getContents();
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n ^= (byArray[i] & 0xFF) << i % 4;
        }
        return n ^ this.getApplicationTag();
    }
}

