/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobInputStream;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.SybLob;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LobLocatorInputStream
extends LobInputStream {
    public LobLocatorInputStream(SybLob sybLob) {
        this(sybLob, 1L, Long.MAX_VALUE);
    }

    public LobLocatorInputStream(SybLob sybLob, long l, long l2) {
        super(sybLob, l, l2);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkIfClosed();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this._nextReadPos > this._readLimit) {
            return -1;
        }
        if (this._nextReadPos + (long)n2 > this._readLimit) {
            n2 = (int)(this._readLimit - this._nextReadPos + 1L);
        }
        int n3 = 0;
        try {
            MdaManager mdaManager = this._lob._context._conn.getMDA(this._lob._context);
            PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("LOB_GETLOB", this._lob._context);
            preparedStatement.setInt(1, this._lob._lobType.ordinal());
            preparedStatement.setBytes(2, this._lob.getLocator());
            preparedStatement.setLong(3, this._nextReadPos);
            preparedStatement.setInt(4, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] byArray2 = null;
            if (resultSet.next()) {
                if (this._lob._lobType == SybLob.LOB_TYPE.IMAGE) {
                    byArray2 = resultSet.getBytes(1);
                } else {
                    InputStream inputStream = resultSet.getAsciiStream(1);
                    if (inputStream != null) {
                        byArray2 = new byte[inputStream.available()];
                        inputStream.read(byArray2);
                    }
                }
            }
            if (byArray2 == null) {
                return -1;
            }
            n3 = byArray2.length < n2 ? byArray2.length : n2;
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOException("JZ041", "Read", "InputStream", sQLException);
        }
        this._nextReadPos += (long)n3;
        return n3;
    }
}

