/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.exec;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.dbeaver.db.cassandra.exec.CasResultSet;
import com.dbeaver.db.cassandra.exec.CasSession;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class CasBaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(CasBaseStatement.class);
    protected final CasSession session;
    protected final String query;
    protected DBCExecutionSource source;
    protected ResultSet result;
    protected Throwable executeError;
    protected long offset;
    protected long limit;
    protected long updateCount = -1L;
    protected int statementTimeout;
    protected volatile ResultSetFuture resultSetFuture;

    protected CasBaseStatement(CasSession session, String query) {
        this.session = session;
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @NotNull
    public CasSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public CasResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new CasResultSet(this, this.result);
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public long getUpdateRowCount() {
        return this.updateCount;
    }

    public boolean nextResults() {
        return false;
    }

    public void close() {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        ExecutionInfo executionInfo;
        if (this.result != null && (executionInfo = this.result.getExecutionInfo()) != null && !CommonUtils.isEmpty((Collection)executionInfo.getWarnings())) {
            List warnings = executionInfo.getWarnings();
            Throwable[] result = new Throwable[warnings.size()];
            int i = 0;
            while (i < warnings.size()) {
                String warning = (String)warnings.get(i);
                result[i] = new Exception(warning);
                ++i;
            }
            return result;
        }
        return null;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        ResultSetFuture rsFuture = this.resultSetFuture;
        if (rsFuture != null) {
            if (!rsFuture.cancel(true)) {
                throw new DBException("Can't cancel future result set");
            }
        } else if (blockThread != null) {
            blockThread.interrupt();
        } else {
            throw new DBException("Can't cancel - no future result set");
        }
    }

    public void setStatementTimeout(int timeout) throws DBCException {
        this.statementTimeout = timeout;
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public abstract Statement getStatementImpl();

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)this.session.getExecutionContext());
    }

    public void startBlock(String name) {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, "Execute prepared statement");
    }

    public void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }
}

