/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import com.dbeaver.ee.influxdb.exec.InfluxResultSet;
import com.dbeaver.ee.influxdb.exec.InfluxSelectStatement;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxDataType;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementField;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public class InfluxMeasurement
implements DBSEntity,
DBSDataContainer,
DBSDataManipulator,
DBPRefreshableObject {
    private static final Log log = Log.getLog(InfluxMeasurement.class);
    private final InfluxDatabase database;
    private final String name;
    private final FieldCache fieldCache = new FieldCache();
    private final TagCache tagCache = new TagCache();
    private transient MeasurementKey measurementKey;
    public static final DBSEntityConstraintType TIME_KEY = new DBSEntityConstraintType("time", "TIME KEY", "Time Key", false, true, false, false);

    protected InfluxMeasurement(InfluxDatabase database, String name) {
        this.database = database;
        this.name = name;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public InfluxDatabase getDatabase() {
        return this.database;
    }

    public String getDescription() {
        return null;
    }

    public InfluxDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public InfluxDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @Association
    public List<InfluxMeasurementField> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getFields(monitor);
    }

    @Association
    public List<InfluxMeasurementField> getFields(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.fieldCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<InfluxMeasurementTag> getTags(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tagCache.getAllObjects(monitor, this);
    }

    public InfluxMeasurementField getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.fieldCache.getObject(monitor, this, attributeName);
    }

    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.measurementKey == null) {
            this.measurementKey = new MeasurementKey();
        }
        return Collections.singletonList(this.measurementKey);
    }

    public Collection<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public int getSupportedFeatures() {
        return 458757;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        try {
            DBCStatistics statistics;
            block24: {
                InfluxSession influxSession = (InfluxSession)session;
                statistics = new DBCStatistics();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ").append(DBUtils.getQuotedIdentifier((DBSObject)this));
                SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
                SQLUtils.appendQueryOrder((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
                Throwable throwable = null;
                Object var16_15 = null;
                try (InfluxSelectStatement statement = new InfluxSelectStatement(influxSession, this.getDatabase(), query.toString());){
                    statement.setStatementSource(source);
                    statement.setLimit(firstRow, maxRows);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                    if (!statement.executeStatement()) break block24;
                    Throwable throwable2 = null;
                    Object var19_20 = null;
                    try (InfluxResultSet resultSet = statement.openResultSet();){
                        dataReceiver.fetchStart((DBCSession)influxSession, (DBCResultSet)resultSet, firstRow, maxRows);
                        try {
                            DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
                            while (resultSet.nextRow()) {
                                if (fetchProgress.isCanceled()) break;
                                dataReceiver.fetchRow((DBCSession)influxSession, (DBCResultSet)resultSet);
                                fetchProgress.monitorRowFetch();
                            }
                            fetchProgress.dumpStatistics(statistics);
                        }
                        finally {
                            dataReceiver.fetchEnd((DBCSession)influxSession, (DBCResultSet)resultSet);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return statistics;
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getExecutionContext());
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        QueryResult queryResult;
        block5: {
            InfluxSession influxSession = (InfluxSession)session;
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) FROM ").append(DBUtils.getQuotedIdentifier((DBSObject)this));
            SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
            InfluxDB influxDB = influxSession.getInfluxDB();
            queryResult = influxDB.query(new Query(query.toString(), this.getDatabase().getName()));
            if (queryResult != null && !CommonUtils.isEmpty((Collection)queryResult.getResults())) break block5;
            return -1L;
        }
        try {
            for (QueryResult.Series series : CommonUtils.safeList((List)((QueryResult.Result)queryResult.getResults().get(0)).getSeries())) {
                for (List row : CommonUtils.safeList((List)series.getValues())) {
                    if (row.size() <= 1) continue;
                    return CommonUtils.toLong(row.get(1));
                }
            }
            throw new DBException("No count results");
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] updateAttributes, @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    private String getAttributeName(DBSAttributeBase attribute) {
        return DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)attribute.getName());
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.fieldCache.clearCache();
        this.tagCache.clearCache();
        return this;
    }

    class FieldCache
    extends AbstractObjectCache<InfluxMeasurement, InfluxMeasurementField> {
        FieldCache() {
        }

        @NotNull
        public List<InfluxMeasurementField> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable InfluxMeasurement measurement) throws DBException {
            if (!this.isFullyCached()) {
                InfluxDataSource dataSource = measurement.getDataSource();
                ArrayList<InfluxMeasurementField> fields = new ArrayList<InfluxMeasurementField>();
                fields.add(new InfluxMeasurementField(measurement, 0, "time", dataSource.getLocalDataType(InfluxDataType.TypeName.TIMESTAMP.getTypeName())));
                InfluxDB influxDB = ((InfluxExecutionContext)InfluxMeasurement.this.getDataSource().getDefaultContext(monitor, true)).getInfluxDB();
                QueryResult dbListResult = influxDB.query(new Query("SHOW FIELD KEYS FROM " + DBUtils.getQuotedIdentifier((DBSObject)measurement), DBUtils.getQuotedIdentifier((DBSObject)measurement.getDatabase())));
                for (QueryResult.Result result : dbListResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List dbObj : CommonUtils.safeList((List)series.getValues())) {
                            InfluxDataType dataType;
                            Object fieldType;
                            Object fieldName = dbObj.get(0);
                            Object v0 = fieldType = dbObj.size() > 1 ? dbObj.get(1) : null;
                            if (fieldType == null) {
                                dataType = dataSource.getLocalDataType(InfluxDataType.TypeName.FLOAT.getTypeName());
                            } else {
                                dataType = dataSource.getLocalDataType(CommonUtils.toString(fieldType));
                                if (dataType == null) {
                                    log.error((Object)("Can't find data type '" + fieldType + "' for field '" + fieldName + "'"));
                                    dataType = dataSource.getLocalDataType(InfluxDataType.TypeName.UNKNOWN.getTypeName());
                                }
                            }
                            InfluxMeasurementField field = new InfluxMeasurementField(measurement, fields.size(), CommonUtils.toString(fieldName), dataType);
                            fields.add(field);
                        }
                    }
                }
                fields.sort(DBUtils.nameComparator());
                this.setCache(fields);
            }
            return this.getCachedObjects();
        }

        public InfluxMeasurementField getObject(@NotNull DBRProgressMonitor monitor, @Nullable InfluxMeasurement measurement, @NotNull String name) throws DBException {
            return (InfluxMeasurementField)DBUtils.findObject(this.getAllObjects(monitor, measurement), (String)name);
        }
    }

    public class MeasurementKey
    implements DBSEntityConstraint,
    DBSEntityReferrer {
        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return "time_key";
        }

        @Property(viewable=true, editable=true, order=2)
        @NotNull
        public DBSEntityConstraintType getConstraintType() {
            return TIME_KEY;
        }

        @NotNull
        public InfluxMeasurement getParentObject() {
            return InfluxMeasurement.this;
        }

        public String getDescription() {
            return null;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return InfluxMeasurement.this.getDataSource();
        }

        public boolean isPersisted() {
            return true;
        }

        public List<FieldColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
            InfluxMeasurementField timeField = InfluxMeasurement.this.fieldCache.getObject(monitor, InfluxMeasurement.this, "time");
            return timeField == null ? Collections.emptyList() : Collections.singletonList(new FieldColumn(timeField));
        }

        public class FieldColumn
        implements DBSObject,
        DBSEntityAttributeRef {
            private final InfluxMeasurementField timeField;

            public FieldColumn(InfluxMeasurementField timeField) {
                this.timeField = timeField;
            }

            @NotNull
            public DBSEntityAttribute getAttribute() {
                return this.timeField;
            }

            public DBSObject getParentObject() {
                return MeasurementKey.this;
            }

            @NotNull
            public DBPDataSource getDataSource() {
                return MeasurementKey.this.getDataSource();
            }

            @Property(viewable=true, editable=true, order=1)
            @NotNull
            public String getName() {
                return this.timeField.getName();
            }

            public boolean isPersisted() {
                return true;
            }

            public String getDescription() {
                return null;
            }
        }
    }

    class TagCache
    extends AbstractObjectCache<InfluxMeasurement, InfluxMeasurementTag> {
        TagCache() {
        }

        @NotNull
        public Collection<InfluxMeasurementTag> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable InfluxMeasurement measurement) throws DBException {
            if (!this.isFullyCached()) {
                measurement.getDataSource();
                ArrayList<InfluxMeasurementTag> fields = new ArrayList<InfluxMeasurementTag>();
                InfluxDB influxDB = ((InfluxExecutionContext)InfluxMeasurement.this.getDataSource().getDefaultContext(monitor, true)).getInfluxDB();
                QueryResult dbListResult = influxDB.query(new Query("SHOW TAG KEYS FROM " + DBUtils.getQuotedIdentifier((DBSObject)measurement), DBUtils.getQuotedIdentifier((DBSObject)measurement.getDatabase())));
                for (QueryResult.Result result : dbListResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List dbObj : CommonUtils.safeList((List)series.getValues())) {
                            Object fieldName = dbObj.get(0);
                            InfluxMeasurementTag tag = new InfluxMeasurementTag(measurement, fields.size(), CommonUtils.toString(fieldName));
                            fields.add(tag);
                        }
                    }
                }
                fields.sort(DBUtils.nameComparator());
                this.setCache(fields);
            }
            return this.getCachedObjects();
        }

        public InfluxMeasurementTag getObject(@NotNull DBRProgressMonitor monitor, @Nullable InfluxMeasurement InfluxDatabase2, @NotNull String name) throws DBException {
            return (InfluxMeasurementTag)DBUtils.findObject(this.getAllObjects(monitor, InfluxDatabase2), (String)name);
        }
    }
}

