/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxBaseStatement;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import java.util.Collection;
import java.util.Locale;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class InfluxSelectStatement
extends InfluxBaseStatement {
    private static final Log log = Log.getLog(InfluxSelectStatement.class);

    public InfluxSelectStatement(InfluxSession session, InfluxDatabase database, String query) {
        super(session, database, query);
    }

    public boolean executeStatement() throws DBCException {
        String queryString = this.getQueryString();
        String testQuery = queryString.toLowerCase(Locale.ENGLISH);
        String queryStart = SQLUtils.getFirstKeyword((SQLDialect)this.session.getDataSource().getSQLDialect(), (String)testQuery);
        if (queryStart.equals("select") && this.getLimit() > 0 && !testQuery.contains("limit")) {
            queryString = String.valueOf(queryString) + " LIMIT " + this.getLimit();
            if (this.getOffset() > 0 && !testQuery.contains("offset")) {
                queryString = String.valueOf(queryString) + " OFFSET " + this.getOffset();
            }
        }
        this.beforeExecute();
        try {
            InfluxDatabase curDatabase = this.getCurrentDatabase();
            if (curDatabase == null) {
                throw new DBCException("Can't execute query - no active database");
            }
            InfluxDB influxDB = this.getSession().getInfluxDB();
            QueryResult queryResult = influxDB.query(new Query(queryString, curDatabase.getName()));
            if (queryResult == null || CommonUtils.isEmpty((Collection)queryResult.getResults())) {
                this.setQueryResult(null);
                return false;
            }
            QueryResult.Result result = (QueryResult.Result)queryResult.getResults().get(0);
            if (!CommonUtils.isEmpty((String)result.getError())) {
                throw new DBCException("InfluxDB error: " + result.getError());
            }
            if (CommonUtils.isEmpty((Collection)result.getSeries())) {
                this.setQueryResult(null);
                return false;
            }
            this.setQueryResult(queryResult);
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }
}

