/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class InfluxExecutionContext
extends AbstractExecutionContext<InfluxDataSource>
implements DBCExecutionContextDefaults<InfluxDatabase, DBSSchema> {
    private static final Log log = Log.getLog(InfluxExecutionContext.class);
    private InfluxDB influxDB;
    private InfluxDB.ConsistencyLevel currentConsistencyLevel = InfluxDB.ConsistencyLevel.ONE;
    private String defaultDatabase;

    public InfluxExecutionContext(InfluxDataSource dataSource, String purpose, String databaseName) {
        super((DBPDataSource)dataSource, purpose);
        this.defaultDatabase = databaseName;
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((InfluxDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open influx session");
                DBPConnectionConfiguration configuration = ((InfluxDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient().newBuilder().connectTimeout((long)CommonUtils.toInt((Object)configuration.getProviderProperty("influxdb.timeout.connect"), (int)10000), TimeUnit.MILLISECONDS).readTimeout((long)CommonUtils.toInt((Object)configuration.getProviderProperty("influxdb.timeout.read"), (int)60000), TimeUnit.MILLISECONDS).writeTimeout((long)CommonUtils.toInt((Object)configuration.getProviderProperty("influxdb.timeout.write"), (int)10000), TimeUnit.MILLISECONDS);
                this.influxDB = InfluxDBFactory.connect((String)configuration.getUrl(), (String)configuration.getUserName(), (String)configuration.getUserPassword(), (OkHttpClient.Builder)okHttpClientBuilder);
                this.influxDB.ping();
                String defCL = ((InfluxDataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@");
                if (!CommonUtils.isEmpty((String)defCL)) {
                    try {
                        this.currentConsistencyLevel = InfluxDB.ConsistencyLevel.valueOf((String)defCL);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.debug((Object)("Bad default consistency level: " + defCL));
                    }
                }
                this.influxDB.setConsistency(this.currentConsistencyLevel);
                super.initContextBootstrap(monitor, true);
                ((InfluxDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((InfluxDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public InfluxSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new InfluxSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            Pong pong = this.influxDB.ping();
            pong.getVersion();
        }
        catch (Exception e) {
            throw new DBException("Error pinging Influx", (Throwable)e);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.influxDB.close();
        InfluxExecutionContext influxExecutionContext = this;
        synchronized (influxExecutionContext) {
            ((InfluxDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }

    public InfluxDB.ConsistencyLevel getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public void setCurrentConsistencyLevel(InfluxDB.ConsistencyLevel currentConsistencyLevel) {
        this.currentConsistencyLevel = currentConsistencyLevel;
        this.influxDB.setConsistency(this.currentConsistencyLevel);
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public InfluxDatabase getDefaultCatalog() {
        List<InfluxDatabase> databases = ((InfluxDataSource)this.getDataSource()).getDatabases();
        if (databases == null) {
            return null;
        }
        for (InfluxDatabase db : databases) {
            if (this.defaultDatabase == null || !CommonUtils.equalObjects((Object)db.getName(), (Object)this.defaultDatabase)) continue;
            return db;
        }
        return null;
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, InfluxDatabase catalog, DBSSchema schema) throws DBCException {
        InfluxDatabase oldSelectedDB = this.getDefaultCatalog();
        if (oldSelectedDB == catalog) {
            return;
        }
        this.defaultDatabase = catalog.getName();
        if (oldSelectedDB != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedDB, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)catalog, (boolean)true);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return true;
    }
}

