/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Replace
extends Prepared {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private Prepared update;

    public Replace(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    @Override
    public int update() {
        int n;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            n = 0;
            int n2 = this.list.size();
            for (int i = 0; i < n2; ++i) {
                this.setCurrentRowNumber(i + 1);
                Expression[] expressionArray = this.list.get(i);
                Row row = this.table.getTemplateRow();
                int n3 = this.columns.length;
                for (int j = 0; j < n3; ++j) {
                    Column column = this.columns[j];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n4, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Replace.getSQL(expressionArray));
                    }
                }
                this.replace(row);
                ++n;
            }
        } else {
            ResultInterface resultInterface = this.query.query(0);
            n = 0;
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, true, false);
            while (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n5 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i]);
                        row.setValue(n5, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Replace.getSQL(valueArray));
                    }
                }
                this.replace(row);
            }
            resultInterface.close();
            this.table.fire(this.session, 3, false);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replace(Row row) {
        int n = this.update(row);
        if (n == 0) {
            try {
                this.table.validateConvertUpdateSequence(this.session, row);
                boolean bl = this.table.fireBeforeRow(this.session, null, row);
                if (bl) return;
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException dbException) {
                Index index;
                if (dbException.getErrorCode() != 23505 || (index = (Index)dbException.getSource()) == null) throw dbException;
                Column[] columnArray = index.getColumns();
                boolean bl = false;
                if (columnArray.length <= this.keys.length) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        if (columnArray[i] == this.keys[i]) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) throw dbException;
                throw DbException.get(90131, this.table.getName());
            }
        } else {
            if (n == 1) return;
            throw DbException.get(23505, this.table.getSQL());
        }
    }

    private int update(Row row) {
        Parameter parameter;
        Value value;
        Column column;
        int n;
        if (this.update == null) {
            return 0;
        }
        ArrayList<Parameter> arrayList = this.update.getParameters();
        for (n = 0; n < this.columns.length; ++n) {
            column = this.columns[n];
            value = row.getValue(column.getColumnId());
            parameter = arrayList.get(n);
            parameter.setValue(value);
        }
        for (n = 0; n < this.keys.length; ++n) {
            column = this.keys[n];
            value = row.getValue(column.getColumnId());
            if (value == null) {
                throw DbException.get(90081, column.getSQL());
            }
            parameter = arrayList.get(this.columns.length + n);
            parameter.setValue(value);
        }
        return this.update.update();
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("REPLACE INTO ");
        statementBuilder.append(this.table.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(')');
        statementBuilder.append('\n');
        if (this.list.size() > 0) {
            statementBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.list) {
                if (n++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepare() {
        void var4_14;
        void var4_12;
        Object object;
        int n;
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] expressionArray : this.list) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (n = 0; n < expressionArray.length; ++n) {
                    Expression expression = expressionArray[n];
                    if (expression == null) continue;
                    expressionArray[n] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.table.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        for (Column column : this.keys) {
            boolean bl = false;
            for (Column column2 : this.columns) {
                if (column2.getColumnId() != column.getColumnId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return;
        }
        object = new StatementBuilder("UPDATE ");
        ((StatementBuilder)object).append(this.table.getSQL()).append(" SET ");
        Column[] object3 = this.columns;
        n = object3.length;
        boolean bl = false;
        while (var4_12 < n) {
            Column column = object3[var4_12];
            ((StatementBuilder)object).appendExceptFirst(", ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
            ++var4_12;
        }
        ((StatementBuilder)object).append(" WHERE ");
        ((StatementBuilder)object).resetCount();
        Column[] columnArray = this.keys;
        n = columnArray.length;
        boolean bl2 = false;
        while (var4_14 < n) {
            Column column = columnArray[var4_14];
            ((StatementBuilder)object).appendExceptFirst(" AND ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
            ++var4_14;
        }
        String string = ((StatementBuilder)object).toString();
        this.update = this.session.prepare(string);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 63;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

