/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.iam;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AuthModelIAMCredentials
extends AuthModelDatabaseNativeCredentials {
    private static final Log log = Log.getLog(AuthModelIAMCredentials.class);
    private static final String ROLE_SESSION_NAME = "dbeaver";
    private String region;
    private String profileName;
    private String pluginName;
    private boolean defaultAwsCredentials;
    @SecureProperty
    private String awsAccessKey;
    @SecureProperty
    private String awsSecretKey;
    private boolean ssoOverCli;
    private boolean crossAccountAccess;
    private String awsAssumeAccountId;
    private String awsAssumeRoleName;

    public AuthModelIAMCredentials() {
    }

    public AuthModelIAMCredentials(AuthModelIAMCredentials source) {
        this.region = source.region;
        this.profileName = source.profileName;
        this.pluginName = source.pluginName;
        this.defaultAwsCredentials = source.defaultAwsCredentials;
        this.awsAccessKey = source.awsAccessKey;
        this.awsSecretKey = source.awsSecretKey;
        this.ssoOverCli = source.ssoOverCli;
        this.crossAccountAccess = source.crossAccountAccess;
        this.awsAssumeAccountId = source.awsAssumeAccountId;
        this.awsAssumeRoleName = source.awsAssumeRoleName;
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getProfileName() {
        return this.profileName;
    }

    void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Region getAwsRegion() {
        if (CommonUtils.isEmpty((String)this.region)) {
            return Region.AWS_GLOBAL;
        }
        return Region.of((String)this.region);
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public boolean isDefaultAwsCredentials() {
        return this.defaultAwsCredentials;
    }

    void setDefaultAwsCredentials(boolean defaultAwsCredentials) {
        this.defaultAwsCredentials = defaultAwsCredentials;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    @Property(password=true)
    @AuthProperty(contextProvided=true)
    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public boolean isSsoOverCli() {
        return this.ssoOverCli;
    }

    public void setSsoOverCli(boolean ssoOverCli) {
        this.ssoOverCli = ssoOverCli;
    }

    public boolean isCrossAccountAccess() {
        return this.crossAccountAccess;
    }

    public void setCrossAccountAccess(boolean crossAccountAccess) {
        this.crossAccountAccess = crossAccountAccess;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public String getAwsAssumeAccountId() {
        return this.awsAssumeAccountId;
    }

    void setAwsAssumeAccountId(String awsAssumeAccountId) {
        this.awsAssumeAccountId = awsAssumeAccountId;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public String getAwsAssumeRoleName() {
        return this.awsAssumeRoleName;
    }

    void setAwsAssumeRoleName(String awsAssumeRoleName) {
        this.awsAssumeRoleName = awsAssumeRoleName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor) throws DBCException {
        return this.getAuthCredentialsProvider(monitor, null);
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBCException {
        AwsCredentialsProvider credentialsProvider = this.resolveCredentialsProvider(monitor, configuration);
        if (this.ssoOverCli) {
            try {
                credentialsProvider.resolveCredentials();
            }
            catch (Throwable throwable) {
                this.initializeSSO(monitor);
            }
        }
        if (this.crossAccountAccess && !CommonUtils.isEmpty((String)this.awsAssumeAccountId)) {
            monitor.subTask("Assume AWS role");
            if (CommonUtils.isEmpty((String)this.awsAssumeRoleName)) {
                throw new DBCException("AWS IAM role name must be specified when 3rd party IAM account is specified");
            }
            Region awsRegion = this.getAwsRegion();
            String roleArn = "arn:aws:iam::" + this.awsAssumeAccountId + ":role/" + this.awsAssumeRoleName;
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(awsRegion)).credentialsProvider(credentialsProvider)).build();
            AssumeRoleRequest arRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(ROLE_SESSION_NAME).build();
            credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
        }
        return credentialsProvider;
    }

    private AwsCredentialsProvider resolveCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBCException {
        DefaultCredentialsProvider credentialsProvider;
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            monitor.subTask("Read AWS profiles");
            if (CommonUtils.isEmpty((String)this.profileName)) {
                throw new DBCException("AWS profile name must be specified");
            }
            credentialsProvider = ProfileCredentialsProvider.builder().profileName(this.profileName).build();
        } else if (this.defaultAwsCredentials) {
            credentialsProvider = DefaultCredentialsProvider.builder().reuseLastProviderEnabled(Boolean.valueOf(false)).build();
        } else {
            String accessKey = this.awsAccessKey;
            String secretKey = this.awsSecretKey;
            if (configuration != null) {
                if (CommonUtils.isEmpty((String)accessKey)) {
                    accessKey = configuration.getUserName();
                }
                if (CommonUtils.isEmpty((String)secretKey)) {
                    secretKey = configuration.getUserPassword();
                }
            }
            if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                DBPAuthInfo authInfo;
                monitor.subTask("Acquire secret credentials in interactive mode");
                try {
                    authInfo = DBWorkbench.getPlatformUI().promptUserCredentials("Please enter access key and secret key", "Access Key", accessKey, "Secret Key", secretKey, false, false);
                }
                catch (Exception e) {
                    authInfo = null;
                    log.error((Object)e);
                }
                if (authInfo != null) {
                    accessKey = authInfo.getUserName();
                    secretKey = authInfo.getUserPassword();
                } else {
                    throw new DBCException("AWS access key and secret key must be specified");
                }
            }
            AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        return credentialsProvider;
    }

    private void initializeSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Initialize SSO over AWS CLI");
        String cliParams = "aws sso login";
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            cliParams = String.valueOf(cliParams) + " --profile " + this.profileName;
        }
        log.debug((Object)("Perform AWS SSO init [" + cliParams + "]"));
        DBRShellCommand cliCommand = new DBRShellCommand(cliParams);
        cliCommand.setEnabled(true);
        final DBRProcessDescriptor cliProcess = new DBRProcessDescriptor(cliCommand);
        try {
            cliProcess.execute();
        }
        catch (DBException e) {
            throw new DBCException("Error running AWS CLI. Is it installed on the local machine?", (Throwable)e);
        }
        final String[] cliErrorLog = new String[2];
        AbstractJob dumpJob = null;
        if (cliProcess.isRunning()) {
            dumpJob = new AbstractJob(String.valueOf(cliProcess.getName()) + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        cliErrorLog[0] = cliProcess.dumpErrors();
                        cliErrorLog[1] = cliProcess.dumpOutput();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            dumpJob.schedule();
        }
        while (cliProcess.isRunning()) {
            if (monitor.isCanceled()) {
                cliProcess.terminate();
                throw new DBCException("AWS SSO initialization has been canceled");
            }
            RuntimeUtils.pause((int)50);
        }
        if (dumpJob != null) {
            try {
                dumpJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        int resCode = cliProcess.getExitValue();
        String infoMessage = cliErrorLog[1];
        if (!CommonUtils.isEmptyTrimmed((String)infoMessage)) {
            log.debug((Object)("AWS SSO login info message:\n" + infoMessage));
        }
        if (resCode != 0) {
            String errorMessage = cliErrorLog[0];
            if (!CommonUtils.isEmptyTrimmed((String)errorMessage)) {
                errorMessage = "AWS SSO login failed: " + errorMessage.trim();
                throw new DBCException(errorMessage);
            }
            log.debug((Object)("AWS SSO login ended with result  code " + resCode));
        }
        monitor.subTask("SSO init finished");
    }
}

