/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.iam;

import com.dbeaver.net.auth.iam.AuthModelIAMCredentials;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.utils.CommonUtils;

public abstract class AuthModelIAMAbstract
extends AuthModelDatabaseNative<AuthModelIAMCredentials> {
    @NotNull
    public AuthModelIAMCredentials createCredentials() {
        return new AuthModelIAMCredentials();
    }

    @NotNull
    public AuthModelIAMCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelIAMCredentials credentials = (AuthModelIAMCredentials)((Object)configuration.getRuntimeAttribute("iam.credentials"));
        if (credentials == null) {
            credentials = (AuthModelIAMCredentials)super.loadCredentials(dataSource, configuration);
            if (configuration.getAuthProperties() != null) {
                AuthModelIAMAbstract.loadCredentialsFromMap(credentials, configuration.getAuthProperties());
            }
        } else {
            credentials = new AuthModelIAMCredentials(credentials);
            super.loadCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
        }
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelIAMCredentials credentials) {
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        AuthModelIAMAbstract.saveCredentialsToMap(credentials, authProperties);
        for (Map.Entry ap : authProperties.entrySet()) {
            configuration.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
        }
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public static void loadCredentialsFromMap(AuthModelIAMCredentials credentials, Map<String, String> authProperties) {
        credentials.setProfileName(authProperties.get("iam.profile_name"));
        credentials.setRegion(authProperties.get("iam.region"));
        credentials.setDefaultAwsCredentials(CommonUtils.getBoolean((String)authProperties.get("iam.use_default_aws")));
        credentials.setAwsAccessKey(authProperties.get("iam.aws_access_key"));
        credentials.setAwsSecretKey(authProperties.get("iam.aws_secret_key"));
        credentials.setSsoOverCli(CommonUtils.getBoolean((String)authProperties.get("iam.sso_over_cli")));
        credentials.setCrossAccountAccess(CommonUtils.getBoolean((String)authProperties.get("iam.cross_account_access")));
        credentials.setAwsAssumeAccountId(authProperties.get("iam.account_id"));
        credentials.setAwsAssumeRoleName(authProperties.get("iam.role_name"));
    }

    public static void saveCredentialsToMap(@NotNull AuthModelIAMCredentials credentials, Map<String, String> authProperties) {
        if (!CommonUtils.isEmpty((String)credentials.getProfileName())) {
            authProperties.put("iam.profile_name", credentials.getProfileName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getRegion())) {
            authProperties.put("iam.region", credentials.getRegion());
        }
        authProperties.put("iam.use_default_aws", String.valueOf(credentials.isDefaultAwsCredentials()));
        if (!CommonUtils.isEmpty((String)credentials.getAwsAccessKey())) {
            authProperties.put("iam.aws_access_key", credentials.getAwsAccessKey());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsSecretKey())) {
            authProperties.put("iam.aws_secret_key", credentials.getAwsSecretKey());
        }
        authProperties.put("iam.sso_over_cli", String.valueOf(credentials.isSsoOverCli()));
        authProperties.put("iam.cross_account_access", String.valueOf(credentials.isCrossAccountAccess()));
        if (!CommonUtils.isEmpty((String)credentials.getAwsAssumeAccountId())) {
            authProperties.put("iam.account_id", credentials.getAwsAssumeAccountId());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsAssumeRoleName())) {
            authProperties.put("iam.role_name", credentials.getAwsAssumeRoleName());
        }
    }

    public boolean supportsDatabaseUser() {
        return true;
    }
}

