/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.sql;

import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockToggleToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class PostgreDollarQuoteRule
implements TPPredicateRule {
    private final boolean partitionRule;
    private final boolean ddPlainIsString;
    private final boolean ddTagIsString;
    private final TPToken stringToken;
    private final TPToken delimiterToken;

    public PostgreDollarQuoteRule(DBPDataSourceContainer dataSource, boolean partitionRule) {
        this.partitionRule = partitionRule;
        boolean ddPlainDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.plain.string");
        boolean ddTagDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.tag.string");
        this.ddPlainIsString = dataSource == null ? ddPlainDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.plain.string"), (boolean)ddPlainDefault);
        this.ddTagIsString = dataSource == null ? ddTagDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.tag.string"), (boolean)ddTagDefault);
        this.stringToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_STRING);
        this.delimiterToken = new SQLBlockToggleToken();
    }

    public TPToken evaluate(TPCharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public TPToken getSuccessToken() {
        return this.stringToken;
    }

    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        int totalRead = 0;
        int c = scanner.read();
        ++totalRead;
        if (c == 36) {
            int charsRead = 0;
            do {
                c = scanner.read();
                ++charsRead;
                ++totalRead;
                if (c != 36) continue;
                if (charsRead <= 1 ? this.ddPlainIsString : this.ddTagIsString) {
                    boolean stringEndFound = false;
                    while (true) {
                        c = scanner.read();
                        ++totalRead;
                        if (c == -1) break;
                        if (c != 36) continue;
                        int c2 = scanner.read();
                        ++totalRead;
                        if (c2 == 36) {
                            stringEndFound = true;
                            break;
                        }
                        scanner.unread();
                        --totalRead;
                    }
                    if (!stringEndFound) {
                        if (this.partitionRule) break;
                        PostgreDollarQuoteRule.unread(scanner, totalRead - 2);
                        return this.delimiterToken;
                    }
                    return this.stringToken;
                }
                if (this.partitionRule) break;
                return this.delimiterToken;
            } while (Character.isLetterOrDigit(c) || c == 95);
        }
        PostgreDollarQuoteRule.unread(scanner, totalRead);
        return TPTokenAbstract.UNDEFINED;
    }

    private static void unread(TPCharacterScanner scanner, int totalRead) {
        while (totalRead-- > 0) {
            scanner.unread();
        }
    }
}

