/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMMCollector;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.utils.LongKeyMap;

public class QMMCollectorImpl
extends DefaultExecutionHandler
implements QMMCollector {
    private static final Log log = Log.getLog(QMMCollectorImpl.class);
    private static final long EVENT_DISPATCH_PERIOD = 250L;
    private static final int MAX_HISTORY_EVENTS = 10000;
    private LongKeyMap<QMMSessionInfo> sessionMap = new LongKeyMap();
    private List<Long> closedSessions = new ArrayList<Long>();
    private final List<QMMetaListener> listeners = new ArrayList<QMMetaListener>();
    private List<QMMetaEvent> eventPool = new ArrayList<QMMetaEvent>();
    private final Object historySync = new Object();
    private List<QMMetaEvent> pastEvents = new ArrayList<QMMetaEvent>();
    private boolean running = true;

    public QMMCollectorImpl() {
        new EventDispatcher().schedule(250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (!this.sessionMap.isEmpty()) {
            ArrayList<QMMSessionInfo> openSessions = new ArrayList<QMMSessionInfo>();
            for (QMMSessionInfo session : this.sessionMap.values()) {
                if (session.isClosed()) continue;
                openSessions.add(session);
            }
            if (!openSessions.isEmpty()) {
                log.warn("Some sessions are still open: " + openSessions);
            }
        }
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.isEmpty()) {
                log.warn("Some QM meta collector listeners are still open: " + this.listeners);
                this.listeners.clear();
            }
        }
        this.running = false;
    }

    boolean isRunning() {
        return this.running;
    }

    @Override
    @NotNull
    public String getHandlerName() {
        return "Meta info collector";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(QMMetaListener listener) {
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(QMMetaListener listener) {
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.remove(listener)) {
                log.warn("Listener '" + listener + "' is not registered in QM meta collector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QMMetaListener> getListeners() {
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.listeners.size() == 1) {
                return Collections.singletonList(this.listeners.get(0));
            }
            return new ArrayList<QMMetaListener>(this.listeners);
        }
    }

    private synchronized void fireMetaEvent(QMMObject object, QMMetaEvent.Action action) {
        this.eventPool.add(new QMMetaEvent(object, action));
    }

    private synchronized List<QMMetaEvent> obtainEvents() {
        if (this.eventPool.isEmpty()) {
            return Collections.emptyList();
        }
        List<QMMetaEvent> events = this.eventPool;
        this.eventPool = new ArrayList<QMMetaEvent>();
        return events;
    }

    @Override
    public QMMSessionInfo getSessionInfo(DBCExecutionContext context) {
        QMMSessionInfo sessionInfo = (QMMSessionInfo)this.sessionMap.get(context.getContextId());
        if (sessionInfo == null) {
            log.debug("Can't find sessionInfo meta information: " + context.getContextId() + " (" + context.getContextName() + ")");
        }
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QMMetaEvent> getPastEvents() {
        Object object = this.historySync;
        synchronized (object) {
            return new ArrayList<QMMetaEvent>(this.pastEvents);
        }
    }

    @Override
    public synchronized void handleContextOpen(@NotNull DBCExecutionContext context, boolean transactional) {
        long contextId = context.getContextId();
        QMMSessionInfo session = (QMMSessionInfo)this.sessionMap.get(contextId);
        if (session == null) {
            session = new QMMSessionInfo(context, transactional);
            this.sessionMap.put(contextId, (Object)session);
        } else {
            session.reopen(context);
        }
        this.closedSessions.remove(contextId);
        this.fireMetaEvent(session, QMMetaEvent.Action.BEGIN);
    }

    @Override
    public synchronized void handleContextClose(@NotNull DBCExecutionContext context) {
        QMMSessionInfo session = this.getSessionInfo(context);
        if (session != null) {
            session.close();
            this.fireMetaEvent(session, QMMetaEvent.Action.END);
        }
        this.closedSessions.add(context.getContextId());
    }

    @Override
    public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
        QMMSessionInfo sessionInfo = this.getSessionInfo(context);
        if (sessionInfo != null) {
            QMMTransactionInfo oldTxn = sessionInfo.changeTransactional(!autoCommit);
            if (oldTxn != null) {
                this.fireMetaEvent(oldTxn, QMMetaEvent.Action.END);
            }
            this.fireMetaEvent(sessionInfo, QMMetaEvent.Action.UPDATE);
        }
    }

    @Override
    public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
        QMMTransactionInfo oldTxn;
        QMMSessionInfo sessionInfo = this.getSessionInfo(context);
        if (sessionInfo != null && (oldTxn = sessionInfo.commit()) != null) {
            this.fireMetaEvent(oldTxn, QMMetaEvent.Action.END);
        }
    }

    @Override
    public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
        QMMObject oldTxn;
        QMMSessionInfo sessionInfo = this.getSessionInfo(context);
        if (sessionInfo != null && (oldTxn = sessionInfo.rollback(savepoint)) != null) {
            this.fireMetaEvent(oldTxn, QMMetaEvent.Action.END);
        }
    }

    @Override
    public synchronized void handleStatementOpen(@NotNull DBCStatement statement) {
        QMMSessionInfo session = this.getSessionInfo(statement.getSession().getExecutionContext());
        if (session != null) {
            QMMStatementInfo stat = session.openStatement(statement);
            this.fireMetaEvent(stat, QMMetaEvent.Action.BEGIN);
        }
    }

    @Override
    public synchronized void handleStatementClose(@NotNull DBCStatement statement, long rows) {
        QMMSessionInfo session = this.getSessionInfo(statement.getSession().getExecutionContext());
        if (session != null) {
            QMMStatementInfo stat = session.closeStatement(statement, rows);
            if (stat == null) {
                log.warn("Can't properly handle statement close");
            } else {
                this.fireMetaEvent(stat, QMMetaEvent.Action.END);
            }
        }
    }

    @Override
    public synchronized void handleStatementExecuteBegin(@NotNull DBCStatement statement) {
        QMMStatementExecuteInfo exec;
        QMMSessionInfo session = this.getSessionInfo(statement.getSession().getExecutionContext());
        if (session != null && (exec = session.beginExecution(statement)) != null) {
            this.fireMetaEvent(exec, QMMetaEvent.Action.BEGIN);
        }
    }

    @Override
    public synchronized void handleStatementExecuteEnd(@NotNull DBCStatement statement, long rows, Throwable error) {
        QMMStatementExecuteInfo exec;
        QMMSessionInfo session = this.getSessionInfo(statement.getSession().getExecutionContext());
        if (session != null && (exec = session.endExecution(statement, rows, error)) != null) {
            this.fireMetaEvent(exec, QMMetaEvent.Action.END);
        }
    }

    @Override
    public synchronized void handleResultSetOpen(@NotNull DBCResultSet resultSet) {
        QMMStatementExecuteInfo exec;
        QMMSessionInfo session = this.getSessionInfo(resultSet.getSession().getExecutionContext());
        if (session != null && (exec = session.beginFetch(resultSet)) != null) {
            this.fireMetaEvent(exec, QMMetaEvent.Action.UPDATE);
        }
    }

    @Override
    public synchronized void handleResultSetClose(@NotNull DBCResultSet resultSet, long rowCount) {
        QMMStatementExecuteInfo exec;
        QMMSessionInfo session = this.getSessionInfo(resultSet.getSession().getExecutionContext());
        if (session != null && (exec = session.endFetch(resultSet, rowCount)) != null) {
            this.fireMetaEvent(exec, QMMetaEvent.Action.UPDATE);
        }
    }

    private class EventDispatcher
    extends AbstractJob {
        protected EventDispatcher() {
            super("QM meta events dispatcher");
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IStatus run(DBRProgressMonitor monitor) {
            List sessionsToClose;
            List events;
            QMMCollectorImpl qMMCollectorImpl = QMMCollectorImpl.this;
            synchronized (qMMCollectorImpl) {
                events = QMMCollectorImpl.this.obtainEvents();
                sessionsToClose = QMMCollectorImpl.this.closedSessions;
                QMMCollectorImpl.this.closedSessions.clear();
            }
            List listeners = QMMCollectorImpl.this.getListeners();
            if (!listeners.isEmpty() && !events.isEmpty()) {
                Collections.reverse(events);
                for (QMMetaListener listener : listeners) {
                    try {
                        listener.metaInfoChanged(monitor, events);
                    }
                    catch (Throwable e) {
                        log.error("Error notifying event listener", e);
                    }
                }
            }
            Object object = QMMCollectorImpl.this.historySync;
            synchronized (object) {
                QMMCollectorImpl.this.pastEvents.addAll(events);
                int size = QMMCollectorImpl.this.pastEvents.size();
                if (size > 10000) {
                    QMMCollectorImpl.this.pastEvents = new ArrayList(QMMCollectorImpl.this.pastEvents.subList(size - 10000, size));
                }
            }
            object = QMMCollectorImpl.this;
            synchronized (object) {
                for (Long sessionId : sessionsToClose) {
                    QMMSessionInfo session = (QMMSessionInfo)QMMCollectorImpl.this.sessionMap.get((Object)sessionId);
                    if (session == null || session.isClosed()) continue;
                    QMMCollectorImpl.this.sessionMap.remove((Object)sessionId);
                }
            }
            if (QMMCollectorImpl.this.isRunning()) {
                this.schedule(250L);
            }
            return Status.OK_STATUS;
        }
    }
}

