/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLUpperFunction
extends Expression {
    Expression expression;

    public SQLUpperFunction(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object retval = this.expression.eval(env);
        if (retval != null) {
            retval = retval.toString().toUpperCase();
        }
        return retval;
    }

    public String toString() {
        return "UPPER(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression.aggregateFunctions());
        return result;
    }
}

