/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LikePattern;
import org.relique.jdbc.csv.LogicalExpression;

class LikeExpression
extends LogicalExpression {
    Expression arg1;
    Expression arg2;
    Expression escapeArg;

    public LikeExpression(Expression arg1, Expression arg2, Expression escapeArg) {
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.escapeArg = escapeArg;
    }

    @Override
    public Boolean isTrue(Map<String, Object> env) throws SQLException {
        Object left = this.arg1.eval(env);
        Object right = this.arg2.eval(env);
        String escape = "\\";
        if (this.escapeArg != null) {
            String s;
            escape = "";
            Object o = this.escapeArg.eval(env);
            if (o != null && (s = o.toString()).length() > 0) {
                escape = s.substring(0, 1);
            }
        }
        Boolean result = null;
        if (left != null && right != null) {
            result = LikePattern.matches(right.toString(), escape, left.toString());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("L ");
        sb.append(this.arg1);
        sb.append(" ");
        sb.append(this.arg2);
        if (this.escapeArg != null) {
            sb.append(" ESCAPE ");
            sb.append(this.escapeArg);
        }
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.arg1.usedColumns(availableColumns));
        result.addAll(this.arg2.usedColumns(availableColumns));
        if (this.escapeArg != null) {
            result.addAll(this.escapeArg.usedColumns(availableColumns));
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.arg1.aggregateFunctions());
        result.addAll(this.arg2.aggregateFunctions());
        if (this.escapeArg != null) {
            result.addAll(this.escapeArg.aggregateFunctions());
        }
        return result;
    }
}

