/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.import2;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.ImportInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataContentType;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.TableNames;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.import2.ImportInfoImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.import2.KeyMap;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.import2.TableColumnIterator;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.AppWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CaptureDataWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ContactWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.DBInfoWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.DeptabData;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroupMemberWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroupWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadatasourceStmtWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ProjectReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ProjectWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.SourceStatementWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.SourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.StackWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.StmtWriter;
import com.ibm.db2.cmx.runtime.internal.repository.util.Base64;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipDataImporter {
    private static final String META_INF = "META-INF";
    private Connection connection = null;
    private String schema = null;
    private String fixedRuntimeGroupName = null;
    private String fixedRuntimeGroupVersion = null;
    private Integer staticAppKey = null;
    private RepositoryVersion repositoryVersion = null;
    private boolean isOPM = false;
    private HashMap<String, KeyMap> keyMaps = null;
    private ImportInfoImpl importInfo = null;
    private byte[] capturePdqxmlContent = null;
    private Integer pdqxmlContentMetadataSourceKey = null;

    public ZipDataImporter(Connection connection, String string, RepositoryVersion repositoryVersion) {
        this.connection = connection;
        this.schema = string;
        this.repositoryVersion = repositoryVersion;
        this.isOPM = this.repositoryVersion.compareTo(RepositoryVersion.OPMVersion) <= 0;
    }

    public ImportInfo loadApplication(ZipInputStream zipInputStream, int n2) throws IOException, MetadataException {
        return this.load(zipInputStream, n2, null, null);
    }

    public ImportInfo loadRuntimeGroup(ZipInputStream zipInputStream, String string, String string2) throws IOException, MetadataException {
        return this.load(zipInputStream, null, string, string2);
    }

    public byte[] getZippedPdqxmlContent() {
        return this.capturePdqxmlContent;
    }

    public Integer getPdqxmlContentMetadataSourceKey() {
        return this.pdqxmlContentMetadataSourceKey;
    }

    private ImportInfo load(ZipInputStream zipInputStream, Integer n2, String string, String string2) throws IOException, MetadataException {
        List<String> list = null;
        list = this.isOPM ? Arrays.asList(TableNames.AllTablesV22) : (this.repositoryVersion.isFullRepository() ? Arrays.asList(TableNames.AllTables) : Arrays.asList(TableNames.COTables));
        this.fixedRuntimeGroupName = string;
        this.fixedRuntimeGroupVersion = string2;
        this.staticAppKey = n2;
        this.importInfo = new ImportInfoImpl();
        String string3 = null;
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string4 = this.getGroupNameFrom(zipEntry.getName());
            if (!META_INF.equalsIgnoreCase(string4)) {
                String string5 = this.getTableNameFrom(zipEntry.getName());
                if (string4 != null && string5 != null) {
                    if (!string4.equals(string3)) {
                        string3 = string4;
                        this.initKeyMaps();
                    }
                    if (list.contains(string5)) {
                        this.loadTable(zipInputStream, string5);
                    }
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return this.importInfo;
    }

    private void initKeyMaps() {
        this.keyMaps = new HashMap();
        for (String string : TableNames.AllTables) {
            this.keyMaps.put(string, new KeyMap());
        }
    }

    private void loadTable(ZipInputStream zipInputStream, String string) throws MetadataException {
        TableColumnIterator tableColumnIterator = new TableColumnIterator(zipInputStream);
        String[] stringArray = tableColumnIterator.getColumnNames();
        if (stringArray == null || stringArray.length == 0) {
            String string2 = Messages.getText("ERR_COULD_NOT_READ_COLUMN_NAMES", string);
            throw new MetadataException(string2, null);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            arrayList.add(string3.toUpperCase());
        }
        KeyMap keyMap = this.keyMaps.get(string);
        int n2 = 0;
        while (tableColumnIterator.hasNext()) {
            Object object;
            Object[] objectArray = tableColumnIterator.next();
            ++n2;
            try {
                String string4;
                Object object2;
                Integer n3;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                String string5;
                Object object7;
                Object object8;
                int n4;
                if ("APP_T".equals(string)) {
                    n4 = this.getIndexOfColumn("APP_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    if (this.staticAppKey == null) {
                        n4 = this.getIndexOfColumn("NAME", arrayList, string, true);
                        object8 = (String)objectArray[n4];
                        n4 = this.getIndexOfColumn("VERSION", arrayList, string, true);
                        String string6 = (String)objectArray[n4];
                        int n5 = AppWriter.getInstance(this.schema).createEntry(this.connection, (String)object8, string6);
                        keyMap.put(object, n5);
                        continue;
                    }
                    keyMap.put(object, this.staticAppKey);
                    continue;
                }
                if ("CAPTUREDATA_T".equals(string)) {
                    n4 = this.getIndexOfColumn("GROUP_NAME", arrayList, string, true);
                    object = this.fixedRuntimeGroupName;
                    if (object == null) {
                        object = (String)objectArray[n4];
                    }
                    if ((object8 = this.fixedRuntimeGroupVersion) == null) {
                        n4 = this.getIndexOfColumn("GROUP_VERSION", arrayList, string, true);
                        object8 = (String)objectArray[n4];
                    }
                    n4 = this.getIndexOfColumn("UPDATE_TIME", arrayList, string, true);
                    long l10 = this.getLongFromTimestamp(n4, objectArray);
                    n4 = this.getIndexOfColumn("CONTENT", arrayList, string, true);
                    object7 = this.getByteArray(n4, objectArray);
                    n4 = this.getIndexOfColumn("CONTENT_LENGTH", arrayList, string, true);
                    int n6 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("STATE", arrayList, string, true);
                    string5 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("STATE_TRANSITION_TIME", arrayList, string, true);
                    object6 = this.getLong(n4, objectArray);
                    object5 = CaptureDataWriter.getInstance(this.schema);
                    ((CaptureDataWriter)object5).createEntry(this.connection, (String)object, (String)object8, (byte[])object7, n6, l10, string5, (Long)object6);
                    continue;
                }
                if ("CONTACT_T".equals(string)) {
                    n4 = this.getIndexOfColumn("CONTACT_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("CONTACT", arrayList, string, true);
                    object8 = (String)objectArray[n4];
                    int n7 = ContactWriter.getInstance(this.schema).createEntry(this.connection, (String)object8);
                    keyMap.put(object, n7);
                    continue;
                }
                if ("DBINFO_T".equals(string)) {
                    n4 = this.getIndexOfColumn("DBPKG_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("DBPKGROOT", arrayList, string, true);
                    object8 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("COLLECTIONID", arrayList, string, true);
                    String string7 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("CONTOKEN", arrayList, string, true);
                    String string8 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("VERSION", arrayList, string, true);
                    object7 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("IS_BINDABLE", arrayList, string, true);
                    Character c10 = this.getCharacter(n4, objectArray);
                    int n8 = DBInfoWriter.getInstance(this.schema).createDBInfo(this.connection, (String)object8, string7, string8, (String)object7, c10.charValue());
                    keyMap.put(object, n8);
                    continue;
                }
                if ("DEPTAB_T".equals(string)) {
                    n4 = this.getIndexOfColumn("STMT_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    object = this.mapKey((Integer)object, "STMT_T", string);
                    n4 = this.getIndexOfColumn("SCHEMANAME", arrayList, string, true);
                    object8 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("TABLENAME", arrayList, string, true);
                    String string9 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("COLUMNNAME", arrayList, string, true);
                    String string10 = (String)objectArray[n4];
                    object7 = new DeptabData(this.schema);
                    ((DeptabData)object7).createDeptab(this.connection, (Integer)object, (String)object8, string9, string10);
                    continue;
                }
                if ("METADATAGROUPMEMBERS_T".equals(string)) {
                    n4 = this.getIndexOfColumn("METADATAGROUP_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    if (object != null) {
                        object = this.mapKey((Integer)object, "METADATAGROUP_T", string);
                    }
                    n4 = this.getIndexOfColumn("MEMBER_TYPE", arrayList, string, true);
                    object8 = this.getCharacter(n4, objectArray);
                    n4 = this.getIndexOfColumn("METADATASRC_KEY", arrayList, string, true);
                    Integer n9 = this.getInteger(n4, objectArray);
                    if (n9 != null) {
                        n9 = this.mapKey(n9, "METADATASOURCE_T", string);
                    }
                    n4 = this.getIndexOfColumn("CHILDGROUP_NAME", arrayList, string, true);
                    String string11 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("CHILDGROUP_TYPE", arrayList, string, true);
                    object7 = this.getCharacter(n4, objectArray);
                    MetadataGroupMemberWriter.getInstance(this.schema).createEntry(this.connection, (Integer)object, ((Character)object8).charValue(), n9, string11, (Character)object7);
                    continue;
                }
                if ("METADATAGROUP_T".equals(string)) {
                    String string12;
                    n4 = this.getIndexOfColumn("METADATAGROUP_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    object8 = this.fixedRuntimeGroupName;
                    if (object8 == null) {
                        n4 = this.getIndexOfColumn("NAME", arrayList, string, true);
                        object8 = (String)objectArray[n4];
                    }
                    if ((string12 = this.fixedRuntimeGroupVersion) == null) {
                        n4 = this.getIndexOfColumn("VERSION", arrayList, string, true);
                        string12 = (String)objectArray[n4];
                    }
                    n4 = this.getIndexOfColumn("TYPE_", arrayList, string, true);
                    Character c11 = this.getCharacter(n4, objectArray);
                    n4 = this.getIndexOfColumn("CONTACT_KEY", arrayList, string, true);
                    object7 = this.getInteger(n4, objectArray);
                    if (object7 != null) {
                        object7 = this.mapKey((Integer)object7, "CONTACT_T", string);
                    }
                    int n10 = MetadataGroupWriter.getInstance(this.schema).createEntry(this.connection, (String)object8, string12, Character.valueOf('N'), c11, (Integer)object7);
                    keyMap.put(object, n10);
                    continue;
                }
                if ("METADATASOURCE_T".equals(string)) {
                    n4 = this.getIndexOfColumn("METADATASRC_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("SOURCE", arrayList, string, true);
                    object8 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("IMPORT_TIME", arrayList, string, true);
                    long l11 = this.getLongFromTimestamp(n4, objectArray);
                    n4 = this.getIndexOfColumn("CONTENT", arrayList, string, true);
                    object7 = this.getByteArray(n4, objectArray);
                    n4 = this.getIndexOfColumn("CONTENT_LENGTH", arrayList, string, true);
                    int n11 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("SOURCEFILE", arrayList, string, true);
                    string5 = (String)objectArray[n4];
                    object6 = SavedDataContentType.fromSQLString((String)object8);
                    object5 = null;
                    if (this.isOPM) {
                        if (!(SavedDataContentType.BindProps.equals(object6) || SavedDataContentType.GenProps.equals(object6) || SavedDataContentType.PdqProps.equals(object6))) {
                            object4 = MetadataSourceWriter.getInstance(this.schema);
                            object5 = ((MetadataSourceWriter)object4).createEntry(this.connection, (String)object8, string5);
                            object3 = new ByteArrayInputStream((byte[])object7);
                            ((MetadataSourceWriter)object4).setContent(this.connection, (Integer)object5, (InputStream)object3);
                        }
                    } else {
                        object5 = MetadataSourceWriter.getInstance(this.schema).createEntry(this.connection, (String)object8, string5, (byte[])object7, n11, l11);
                    }
                    if (object5 != null) {
                        keyMap.put(object, object5);
                    }
                    if (!SavedDataContentType.PDQXML.equals(object6)) continue;
                    this.capturePdqxmlContent = object7;
                    this.pdqxmlContentMetadataSourceKey = object5;
                    continue;
                }
                if ("METADATASOURCE_STMT_T".equals(string)) {
                    n4 = this.getIndexOfColumn("STMT_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    object = this.mapKey((Integer)object, "STMT_T", string);
                    if (this.isOPM && object == null) continue;
                    n4 = this.getIndexOfColumn("METADATASRC_KEY", arrayList, string, true);
                    object8 = this.getInteger(n4, objectArray);
                    object8 = this.mapKey((Integer)object8, "METADATASOURCE_T", string);
                    n4 = this.getIndexOfColumn("APP_KEY", arrayList, string, true);
                    Integer n12 = this.getInteger(n4, objectArray);
                    n12 = this.staticAppKey != null ? this.staticAppKey : this.mapKey(n12, "APP_T", string);
                    n4 = this.getIndexOfColumn("PROJECT_KEY", arrayList, string, true);
                    Integer n13 = this.getInteger(n4, objectArray);
                    n13 = this.mapKey(n13, "PROJECT_T", string);
                    MetadatasourceStmtWriter.getInstance(this.schema).createEntry(this.connection, (Integer)object8, (Integer)object, n12, n13);
                    continue;
                }
                if ("PROJECT_T".equals(string)) {
                    n4 = this.getIndexOfColumn("PROJECT_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("NAME", arrayList, string, true);
                    object8 = (String)objectArray[n4];
                    Integer n14 = ProjectReader.getProjectKeyFor(this.connection, (String)object8);
                    if (n14 == null) {
                        n14 = ProjectWriter.getInstance(this.schema).createEntry(this.connection, (String)object8);
                    }
                    keyMap.put(object, n14);
                    continue;
                }
                if ("STACK_T".equals(string)) {
                    n4 = this.getIndexOfColumn("STACK_ID", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("METADATASRC_KEY", arrayList, string, true);
                    object8 = this.getInteger(n4, objectArray);
                    object8 = this.mapKey((Integer)object8, "METADATASOURCE_T", string);
                    int n15 = StackWriter.getInstance(this.schema).createStackId(this.connection, (Integer)object8);
                    keyMap.put(object, n15);
                    continue;
                }
                if ("SRC_STMT_T".equals(string)) {
                    n4 = this.getIndexOfColumn("STACK_ID", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    object = this.mapKey((Integer)object, "STACK_T", string);
                    n4 = this.getIndexOfColumn("STMT_KEY", arrayList, string, true);
                    object8 = this.getInteger(n4, objectArray);
                    object8 = this.mapKey((Integer)object8, "STMT_T", string);
                    n4 = this.getIndexOfColumn("APP_KEY", arrayList, string, true);
                    Integer n16 = this.getInteger(n4, objectArray);
                    n16 = this.staticAppKey != null ? this.staticAppKey : this.mapKey(n16, "APP_T", string);
                    n4 = this.getIndexOfColumn("STMT_OP", arrayList, string, true);
                    String string13 = (String)objectArray[n4];
                    SourceStatementWriter.getInstance(this.schema).createEntry(this.connection, ((Integer)object).intValue(), ((Integer)object8).intValue(), n16, string13);
                    continue;
                }
                if ("SRCINFO_T".equals(string)) {
                    n4 = this.getIndexOfColumn("STACK_ID", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    object = this.mapKey((Integer)object, "STACK_T", string);
                    n4 = this.getIndexOfColumn("STACKTRACEORDER", arrayList, string, true);
                    object8 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("PATH", arrayList, string, true);
                    String string14 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("VERSION", arrayList, string, true);
                    Integer n17 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("LINENO", arrayList, string, true);
                    object7 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("CLASSNAME", arrayList, string, true);
                    String string15 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("METHODNAME", arrayList, string, true);
                    string5 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("METHODSIGNATURE", arrayList, string, true);
                    object6 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("NATIVEMETHOD", arrayList, string, true);
                    object5 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("JAVA_PKGNAME", arrayList, string, true);
                    object4 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("LANGUAGE", arrayList, string, true);
                    object3 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("PROJECT_KEY", arrayList, string, true);
                    n3 = this.getInteger(n4, objectArray);
                    n3 = this.mapKey(n3, "PROJECT_T", string);
                    n4 = this.getIndexOfColumn("LABEL", arrayList, string, true);
                    object2 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("LABEL_TYPE", arrayList, string, true);
                    string4 = (String)objectArray[n4];
                    if (this.isOPM) {
                        SourceWriter.getInstance(this.schema).createSource_V221(this.connection, n3, string14, n17, (Integer)object7, (String)object4, string15, string5, (String)object6, (String)object5, (String)object3, (Integer)object8, (Integer)object);
                        continue;
                    }
                    SourceWriter.getInstance(this.schema).createSource(this.connection, n3, string14, n17, (Integer)object7, (String)object4, string15, string5, (String)object6, (String)object5, (String)object3, (Integer)object8, (Integer)object, (String)object2, string4);
                    continue;
                }
                if ("STMT_T".equals(string)) {
                    n4 = this.getIndexOfColumn("STMT_KEY", arrayList, string, true);
                    object = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("EXPRESSION", arrayList, string, true);
                    object8 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("QUERYTEXT", arrayList, string, true);
                    String string16 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("QUERYTEXTTYPE", arrayList, string, true);
                    Character c12 = this.getCharacter(n4, objectArray);
                    n4 = this.getIndexOfColumn("STATEMENTTYPE", arrayList, string, true);
                    object7 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("EXPRESSIONTYPE", arrayList, string, true);
                    Character c13 = this.getCharacter(n4, objectArray);
                    n4 = this.getIndexOfColumn("PROCESSEDSQLTEXT", arrayList, string, true);
                    string5 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("TOTALCOST", arrayList, string, true);
                    object6 = this.getDouble(n4, objectArray);
                    n4 = this.getIndexOfColumn("CARDINALITY", arrayList, string, true);
                    object5 = this.getLong(n4, objectArray);
                    n4 = this.getIndexOfColumn("JOINCOUNT", arrayList, string, true);
                    object4 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("TBSCANCOUNT", arrayList, string, true);
                    object3 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("IXSCANCOUNT", arrayList, string, true);
                    n3 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("SECTIONNUM", arrayList, string, true);
                    object2 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("ID", arrayList, string, true);
                    string4 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("PATH", arrayList, string, true);
                    String string17 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("DEFAULTSCHEMA", arrayList, string, true);
                    String string18 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("SPECREG", arrayList, string, true);
                    String string19 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("LASTUSEDTS", arrayList, string, true);
                    String string20 = (String)objectArray[n4];
                    n4 = this.getIndexOfColumn("EXECOUNT", arrayList, string, true);
                    Integer n18 = this.getInteger(n4, objectArray);
                    n4 = this.getIndexOfColumn("IS_BINDABLE", arrayList, string, true);
                    Character c14 = this.getCharacter(n4, objectArray);
                    n4 = this.getIndexOfColumn("DBPKG_KEY", arrayList, string, true);
                    Integer n19 = this.getInteger(n4, objectArray);
                    n19 = this.mapKey(n19, "DBINFO_T", string);
                    int n20 = 0;
                    n20 = this.isOPM ? StmtWriter.getInstance(this.schema).createStmtV221(this.connection, (String)object8, string16, string5, (String)object7, c13.charValue(), c12.charValue(), (Integer)object2, string4, n19, c14.charValue(), (Double)object6, (Long)object5, (Integer)object4, (Integer)object3, n3) : StmtWriter.getInstance(this.schema).createStmt(this.connection, (String)object8, string16, string5, (String)object7, c13.charValue(), c12.charValue(), (Integer)object2, string4, n19, c14.charValue(), (Double)object6, (Long)object5, (Integer)object4, (Integer)object3, n3, string18, string17, string19, n18, string20);
                    keyMap.put(object, n20);
                    this.importInfo.incrementStatementsAdded();
                    continue;
                }
                String string21 = Messages.getText("ERR_IGNORING_UNKNOWN_TABLE", string);
                this.importInfo.getMsgs().add(string21);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                object = Messages.getText("ERR_FORMATTING_VALUE_FOR_IMPORT_ROW", n2, string);
                throw new MetadataException((String)object, numberFormatException);
            }
        }
    }

    private Long getLongFromTimestamp(int n2, Object[] objectArray) {
        Long l10 = null;
        if (objectArray[n2] != null) {
            Timestamp timestamp = Timestamp.valueOf(objectArray[n2].toString());
            l10 = timestamp.getTime();
        }
        return l10;
    }

    private Double getDouble(int n2, Object[] objectArray) {
        Double d10 = null;
        if (objectArray[n2] != null) {
            d10 = Double.valueOf(objectArray[n2].toString());
        }
        return d10;
    }

    private Long getLong(int n2, Object[] objectArray) {
        Long l10 = null;
        if (objectArray[n2] != null) {
            l10 = Long.valueOf(objectArray[n2].toString());
        }
        return l10;
    }

    private Integer getInteger(int n2, Object[] objectArray) {
        Integer n3 = null;
        if (objectArray[n2] != null) {
            n3 = Integer.valueOf(objectArray[n2].toString());
        }
        return n3;
    }

    private byte[] getByteArray(int n2, Object[] objectArray) {
        byte[] byArray = null;
        if (objectArray[n2] != null) {
            String string = objectArray[n2].toString();
            byArray = Base64.decode(string.toCharArray(), string.length());
        }
        return byArray;
    }

    private Character getCharacter(int n2, Object[] objectArray) {
        String string;
        Character c10 = null;
        if (objectArray[n2] != null && (string = objectArray[n2].toString()).length() > 0) {
            c10 = Character.valueOf(string.charAt(0));
        }
        return c10;
    }

    private Integer mapKey(Integer n2, String string, String string2) throws MetadataException {
        KeyMap keyMap;
        Integer n3 = null;
        if (n2 != null && (n3 = (Integer)(keyMap = this.keyMaps.get(string)).get(n2)) == null) {
            String string3 = Messages.getText("ERR_KEY_MISSING_IN_EXPORT_DATA", n2, string, string2);
            throw new MetadataException(string3, null);
        }
        return n3;
    }

    private int getIndexOfColumn(String string, List<String> list, String string2, boolean bl2) throws MetadataException {
        int n2 = list.indexOf(string.toUpperCase());
        if (n2 < 0 && bl2) {
            String string3 = Messages.getText("ERR_COLUMN_NOT_PRESENT_IN_EXPORT_DATA", string, string2);
            throw new MetadataException(string3, null);
        }
        return n2;
    }

    private String getTableNameFrom(String string) {
        String string2 = null;
        int n2 = string.lastIndexOf(47);
        if (n2 > 0 && n2 + 1 < string.length()) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    private String getGroupNameFrom(String string) {
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }
}

