/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.json;

import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.TextRenderer;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.json.JSONUtils;

public class JSONRenderer
extends TextRenderer {
    private Color colorDefault;
    private Color colorKey;
    private Color colorString;
    private Color colorValue;
    private DecimalFormat decimalFormat = new DecimalFormat("0");

    public JSONRenderer(IDocumentFrame documentFrame) {
        super(documentFrame);
        this.decimalFormat.setMaximumFractionDigits(340);
    }

    @Override
    public void paintDocument(@NotNull GC gc, @NotNull Canvas canvas, @NotNull Rectangle bounds) {
        ColorRegistry colorRegistry = this.documentFrame.getController().getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorKey = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        this.colorString = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        this.colorValue = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.number.foreground");
        this.colorDefault = canvas.getForeground();
        super.paintDocument(gc, canvas, bounds);
    }

    @Override
    protected void renderNode(TextRenderer.TextProcessor textProcessor, Object node, int x, int y) {
        this.renderJsonNode(textProcessor, node, x, y, 1, false, true);
    }

    private int renderJsonNode(TextRenderer.TextProcessor painter, Object node, int x, int y, int nodeLevel, boolean colItem, boolean lastItem) {
        String valueStr;
        Color color;
        if (painter.isOutOfRange(y)) {
            return 0;
        }
        if (node instanceof DBDComposite) {
            node = ((DBDComposite)node).getRawValue();
        }
        if (node instanceof Map || node instanceof Collection) {
            int attrX;
            boolean isList;
            boolean isEmpty = node instanceof Map ? ((Map)node).isEmpty() : ((Collection)node).isEmpty();
            boolean collapsed = this.isNodeCollapsed(node);
            if (nodeLevel > 1 && !colItem && !isEmpty) {
                painter.drawState(node, collapsed ? TextRenderer.NodeState.collapsed : TextRenderer.NodeState.expanded, (nodeLevel - 1) * 4 - 2, y);
            }
            painter.drawText((isList = node instanceof Collection) ? "[" : "{", x, y, this.colorDefault);
            int lineNum = 0;
            if (collapsed) {
                if (isEmpty) {
                    attrX = x + 4 + 1;
                } else {
                    painter.drawText("...", x + 2, y, this.colorDefault);
                    attrX = x + 4 + 6;
                }
            } else {
                attrX = nodeLevel * 4;
                if (isList) {
                    Collection collection = (Collection)node;
                    lineNum = collection.isEmpty() ? 0 : 1;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object item = iterator.next();
                        int attrY = y + lineNum;
                        lineNum += this.renderJsonNode(painter, item, attrX, attrY, nodeLevel + 1, true, !iterator.hasNext());
                    }
                } else {
                    Map map = (Map)node;
                    lineNum = map.isEmpty() ? 0 : 1;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String attrName = (String)entry.getKey();
                        int attrY = y + lineNum;
                        painter.drawText(attrName, attrX, attrY, this.colorKey);
                        painter.drawText(":", attrX + attrName.length(), attrY, this.colorDefault);
                        lineNum += this.renderJsonNode(painter, entry.getValue(), attrX + attrName.length() + 2, attrY, nodeLevel + 1, false, !iterator.hasNext());
                    }
                }
                if (lineNum == 0) {
                    attrX = x + 4 + 1;
                }
            }
            painter.drawText(String.valueOf(isList ? "]" : "}") + (lastItem ? "" : ","), attrX - 4, y + lineNum, this.colorDefault);
            return ++lineNum;
        }
        if (node == null || node instanceof Number || node instanceof Boolean) {
            color = this.colorValue;
            valueStr = node instanceof Double || node instanceof Float ? this.decimalFormat.format(node) : String.valueOf(node);
        } else if (node instanceof Date) {
            valueStr = JSONUtils.formatISODate((Date)((Date)node));
            color = this.colorValue;
        } else if (node instanceof CharSequence) {
            valueStr = "\"" + node + "\"";
            color = this.colorString;
        } else {
            color = this.colorValue;
            valueStr = node.toString();
        }
        return this.renderText(painter, x, y, valueStr, color, lastItem);
    }

    private int renderText(TextRenderer.TextProcessor painter, int x, int y, String text, Color color, boolean lastItem) {
        int divPos = text.indexOf(10);
        int lineNum = 0;
        int lastLineLen = 0;
        if (divPos == -1) {
            painter.drawText(text, x, y, color);
            lineNum = 1;
            lastLineLen = text.length();
        } else {
            int prevPos = 0;
            do {
                painter.drawText(text.substring(prevPos, divPos), x, y + lineNum, color);
                ++lineNum;
            } while ((divPos = text.indexOf(10, prevPos = divPos + 1)) >= 0);
            painter.drawText(text.substring(prevPos, text.length()), x, y + lineNum, color);
            lastLineLen = text.length() - prevPos;
            ++lineNum;
        }
        if (!lastItem) {
            painter.drawText(",", x + lastLineLen, y + lineNum - 1, this.colorDefault);
        }
        return lineNum;
    }
}

