/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.support.ILogger;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginProfilesConfigFile
extends ProfilesConfigFile {
    private Map<String, CredentialsHolder> cache = new ConcurrentHashMap<String, CredentialsHolder>();
    private PGJDBCSettings m_settings;
    private ILogger m_log;

    public PluginProfilesConfigFile(PGJDBCSettings pGJDBCSettings, ILogger iLogger) {
        this.m_settings = pGJDBCSettings;
        this.m_log = iLogger;
    }

    @Override
    public CredentialsHolder getCredentials(String string) {
        Object object;
        CredentialsHolder credentialsHolder = this.cache.get(string);
        if (credentialsHolder != null && !credentialsHolder.isExpired()) {
            return credentialsHolder;
        }
        Map<String, BasicProfile> map = this.getAllBasicProfiles();
        BasicProfile basicProfile = map.get(string);
        if (basicProfile == null) {
            throw new SdkClientException("No AWS profile named '" + string + "'");
        }
        if (basicProfile.isRoleBasedProfile()) {
            String string2 = basicProfile.getRoleSourceProfile();
            CredentialsHolder credentialsHolder2 = this.getCredentials(string2);
            AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider(credentialsHolder2);
            credentialsHolder = this.assumeRole(basicProfile, aWSStaticCredentialsProvider);
            credentialsHolder.setMetadata(credentialsHolder2.getMetadata());
            this.cache.put(string, credentialsHolder);
            return credentialsHolder;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = basicProfile.getPropertyValue("plugin_name");
        if (!StringUtils.isNullOrEmpty(string7)) {
            try {
                object = Class.forName(string7).asSubclass(AWSCredentialsProvider.class);
                AWSCredentialsProvider aWSCredentialsProvider = (AWSCredentialsProvider)((Class)object).newInstance();
                if (aWSCredentialsProvider instanceof IPlugin) {
                    String string8;
                    IPlugin iPlugin = (IPlugin)aWSCredentialsProvider;
                    iPlugin.setILogger(this.m_log);
                    Map<String, String> map2 = basicProfile.getProperties();
                    for (Map.Entry<String, String> entry : map2.entrySet()) {
                        string8 = entry.getKey().toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string8)) continue;
                        String string9 = entry.getValue();
                        iPlugin.addParameter(string8, string9);
                        if ("DbUser".equalsIgnoreCase(string8)) {
                            string3 = string9;
                            continue;
                        }
                        if ("DbGroups".equalsIgnoreCase(string8)) {
                            string5 = string9;
                            continue;
                        }
                        if ("ForceLowercase".equalsIgnoreCase(string8)) {
                            string6 = string9;
                            continue;
                        }
                        if (!"AutoCreate".equalsIgnoreCase(string8)) continue;
                        string4 = string9;
                    }
                    for (Map.Entry<String, String> entry : this.m_settings.m_pluginArgs.entrySet()) {
                        string8 = entry.getKey().toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string8)) continue;
                        iPlugin.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                credentialsHolder = CredentialsHolder.newInstance(aWSCredentialsProvider.getCredentials());
            }
            catch (InstantiationException instantiationException) {
                throw new SdkClientException("Invalid plugin: '" + string7 + "'");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SdkClientException("Invalid plugin: '" + string7 + "'");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SdkClientException("Invalid plugin: '" + string7 + "'");
            }
        } else {
            object = new ProfileStaticCredentialsProvider(basicProfile).getCredentials();
            credentialsHolder = CredentialsHolder.newInstance((AWSCredentials)object);
        }
        object = credentialsHolder.getMetadata();
        if (null == object) {
            object = new CredentialsHolder.IamMetadata();
        }
        if (null != string3) {
            ((CredentialsHolder.IamMetadata)object).setProfileDbUser(string3);
        }
        if (null != string4) {
            ((CredentialsHolder.IamMetadata)object).setAutoCreate(Boolean.valueOf(string4));
        }
        if (null != string5) {
            ((CredentialsHolder.IamMetadata)object).setDbGroups(string5);
        }
        if (null != string6) {
            ((CredentialsHolder.IamMetadata)object).setForceLowercase(Boolean.valueOf(string6));
        }
        credentialsHolder.setMetadata((CredentialsHolder.IamMetadata)object);
        this.cache.put(string, credentialsHolder);
        return credentialsHolder;
    }

    private CredentialsHolder assumeRole(BasicProfile basicProfile, AWSCredentialsProvider aWSCredentialsProvider) {
        AWSSecurityTokenServiceClientBuilder aWSSecurityTokenServiceClientBuilder = AWSSecurityTokenServiceClientBuilder.standard();
        if (!StringUtils.isNullOrEmpty(this.m_settings.m_awsRegion)) {
            aWSSecurityTokenServiceClientBuilder.setRegion(this.m_settings.m_awsRegion);
        }
        AWSSecurityTokenService aWSSecurityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)aWSSecurityTokenServiceClientBuilder.withCredentials(aWSCredentialsProvider)).build();
        String string = basicProfile.getRoleArn();
        String string2 = basicProfile.getRoleSessionName();
        if (StringUtils.isNullOrEmpty(string2)) {
            string2 = "redshift-jdbc-" + System.currentTimeMillis();
        }
        String string3 = basicProfile.getRoleExternalId();
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(string).withRoleSessionName(string2);
        if (!StringUtils.isNullOrEmpty(string3)) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(string3);
        }
        AssumeRoleResult assumeRoleResult = aWSSecurityTokenService.assumeRole(assumeRoleRequest);
        Credentials credentials = assumeRoleResult.getCredentials();
        Date date = credentials.getExpiration();
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        return CredentialsHolder.newInstance(basicSessionCredentials, date);
    }
}

