/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.api;

import com.amazon.dsi.dataengine.utilities.TimestampTz;
import com.amazon.redshift.api.PGDataTypeUtilities;
import java.util.Calendar;

public class PGTimestamp
extends TimestampTz {
    private static final long FIRST_AD_TIMESTAMP = -62135769599767L;
    private static final long serialVersionUID = 3723996436961531836L;
    private int offSetHour = 0;
    private int offSetMinute = 0;
    private boolean isAD = true;

    public PGTimestamp(long l) {
        super(l, null);
        int n = this.getTimezoneCalendar().getTimeZone().getRawOffset();
        this.offSetHour = n / 3600000;
        this.offSetMinute = n / 60000 % 60;
        if (-62135769599767L > l) {
            this.isAD = false;
        }
    }

    public PGTimestamp(long l, int n, int n2, boolean bl, Calendar calendar) {
        super(l, calendar);
        this.offSetHour = n;
        this.offSetMinute = n2;
        this.isAD = bl;
    }

    @Override
    public String toString() {
        if (this.getTime() == Long.MIN_VALUE) {
            return "-infinity";
        }
        if (this.getTime() == Long.MAX_VALUE) {
            return "infinity";
        }
        return this.getPostgresqlString();
    }

    public String getPostgresqlString() {
        if (this.getTime() == Long.MIN_VALUE) {
            return "-infinity";
        }
        if (this.getTime() == Long.MAX_VALUE) {
            return "infinity";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar = this.getTimezoneCalendar();
        calendar.setTime(this.getAdjustedTimestamp());
        stringBuilder.append(PGDataTypeUtilities.TIMESTAMP_FORMAT.get().format(calendar.getTime()));
        String string = String.valueOf(this.getNanos());
        if (0 < this.getNanos()) {
            stringBuilder.append(".");
            stringBuilder.append(string);
            if (6 < string.length()) {
                stringBuilder.delete(stringBuilder.length() - (string.length() - 6), stringBuilder.length());
            }
        }
        if (25 != this.offSetHour) {
            stringBuilder.append(this.offSetHour < 0 ? (char)'-' : '+');
            if (0 != this.offSetHour) {
                stringBuilder.append(String.format("%02d", Math.abs(this.offSetHour)));
            } else {
                stringBuilder.append("00");
            }
            if (0 != this.offSetMinute) {
                stringBuilder.append(":");
                stringBuilder.append(String.format("%02d", Math.abs(this.offSetMinute)));
            }
        }
        if (!this.isAD) {
            stringBuilder.append(" BC");
        }
        return stringBuilder.toString();
    }
}

