/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.io.IOException;
import java.sql.SQLException;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public class CreateForeignKeyCommand
implements ICommand {
    private String tableName;
    private String referencedTable;
    private String execId;

    public CreateForeignKeyCommand(String tableName, String referencedTable, String execId) {
        this.tableName = tableName;
        this.referencedTable = referencedTable;
        this.execId = execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.DDL;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            Persist2Jet p2a = new Persist2Jet();
            p2a.createForeignKey(this.tableName, this.referencedTable);
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
        return null;
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        return null;
    }
}

