/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLControlToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLScriptParser {
    protected static final Log log = Log.getLog(SQLScriptParser.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType;

    /*
     * Unable to fully structure code
     */
    public static SQLScriptElement parseQuery(SQLParserContext context, int startPos, int endPos, int currentPos, boolean scriptMode, boolean keepDelimiters) {
        length = endPos - startPos;
        document = context.getDocument();
        if (length <= 0 || length > document.getLength()) {
            return null;
        }
        dialect = context.getDialect();
        ruleScanner = context.getScanner();
        useBlankLines = scriptMode == false && context.getSyntaxManager().isBlankLineDelimiter() != false;
        lineFeedIsDelimiter = ArrayUtils.contains((Object[])context.getSyntaxManager().getStatementDelimiters(), (Object)"\n");
        ruleScanner.setRange(document, startPos, endPos - startPos);
        statementStart = startPos;
        hasValuableTokens = false;
        curBlock = null;
        hasBlocks = false;
        lastTokenLineFeeds = 0;
        prevNotEmptyTokenType = SQLTokenType.T_UNKNOWN;
        firstKeyword = null;
        lastKeyword = null;
        while (true) lbl-1000:
        // 9 sources

        {
            block54: {
                block53: {
                    block50: {
                        block51: {
                            block52: {
                                block49: {
                                    block48: {
                                        block58: {
                                            block57: {
                                                block56: {
                                                    block55: {
                                                        token = ruleScanner.nextToken();
                                                        tokenOffset = ruleScanner.getTokenOffset();
                                                        tokenLength = ruleScanner.getTokenLength();
                                                        v0 = tokenType = token instanceof TPTokenDefault != false ? (SQLTokenType)((TPTokenDefault)token).getData() : SQLTokenType.T_OTHER;
                                                        if (tokenOffset < startPos) {
                                                            return null;
                                                        }
                                                        isControl = false;
                                                        delimiterText = null;
                                                        v1 = isDelimiter = tokenType == SQLTokenType.T_DELIMITER || lineFeedIsDelimiter != false && token.isWhitespace() != false && document.get(tokenOffset, tokenLength).contains("\n") != false;
                                                        if (isDelimiter) {
                                                            delimiterText = document.get(tokenOffset, tokenLength);
                                                        } else if (useBlankLines && token.isWhitespace() && tokenLength > 1 && lastTokenLineFeeds + SQLScriptParser.countLineFeeds(document, tokenOffset, tokenLength) >= 2) {
                                                            isDelimiter = true;
                                                        }
                                                        lastTokenLineFeeds = 0;
                                                        if (tokenLength == 1) {
                                                            aChar = document.getChar(tokenOffset);
                                                            if (aChar == '(' || aChar == '{' || aChar == '[') {
                                                                curBlock = new ScriptBlockInfo(curBlock, false);
                                                            } else if ((aChar == ')' || aChar == '}' || aChar == ']') && curBlock != null) {
                                                                curBlock = curBlock.parent;
                                                            }
                                                        }
                                                        if (tokenType == SQLTokenType.T_BLOCK_BEGIN && prevNotEmptyTokenType == SQLTokenType.T_BLOCK_END) {
                                                            tokenType = SQLTokenType.T_UNKNOWN;
                                                        }
                                                        if (tokenType == SQLTokenType.T_DELIMITER && prevNotEmptyTokenType == SQLTokenType.T_BLOCK_BEGIN && curBlock != null) {
                                                            curBlock = curBlock.parent;
                                                        }
                                                        if (tokenType != SQLTokenType.T_BLOCK_HEADER) break block55;
                                                        curBlock = new ScriptBlockInfo(curBlock, true);
                                                        hasBlocks = true;
                                                        ** GOTO lbl89
                                                    }
                                                    if (tokenType != SQLTokenType.T_BLOCK_TOGGLE) break block56;
                                                    try {
                                                        togglePattern = document.get(tokenOffset, tokenLength);
                                                    }
                                                    catch (BadLocationException e) {
                                                        SQLScriptParser.log.warn((Object)e);
                                                        togglePattern = "";
                                                    }
                                                    if (curBlock != null && togglePattern.equals(curBlock.togglePattern)) {
                                                        curBlock = curBlock.parent;
                                                    } else {
                                                        curBlock = new ScriptBlockInfo(curBlock, togglePattern);
                                                        hasBlocks = true;
                                                    }
                                                    ** GOTO lbl89
                                                }
                                                if (tokenType != SQLTokenType.T_BLOCK_BEGIN) break block57;
                                                if (curBlock != null && curBlock.isHeader && !ArrayUtils.containsIgnoreCase((String[])dialect.getInnerBlockPrefixes(), lastKeyword)) {
                                                    curBlock = curBlock.parent;
                                                }
                                                curBlock = new ScriptBlockInfo(curBlock, false);
                                                hasBlocks = true;
                                                ** GOTO lbl89
                                            }
                                            if (tokenType != SQLTokenType.T_BLOCK_END) break block58;
                                            if (curBlock != null) {
                                                curBlock = curBlock.parent;
                                            }
                                            ** GOTO lbl89
                                        }
                                        if (!isDelimiter || curBlock == null) break block48;
                                        if (token.isWhitespace() || token.isEOF()) ** GOTO lbl-1000
                                        prevNotEmptyTokenType = tokenType;
                                    }
                                    if (tokenType == SQLTokenType.T_SET_DELIMITER || tokenType == SQLTokenType.T_CONTROL) {
                                        isDelimiter = true;
                                        isControl = true;
                                    } else if (tokenType == SQLTokenType.T_COMMENT) {
                                        v2 = lastTokenLineFeeds = tokenLength < 2 ? 0 : SQLScriptParser.countLineFeeds(document, tokenOffset + tokenLength - 2, 2);
                                    }
lbl89:
                                    // 9 sources

                                    if (tokenLength > 0 && !token.isWhitespace()) {
                                        switch (SQLScriptParser.$SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType()[tokenType.ordinal()]) {
                                            case 1: 
                                            case 6: 
                                            case 7: 
                                            case 8: 
                                            case 9: 
                                            case 10: {
                                                lastKeyword = document.get(tokenOffset, tokenLength);
                                                if (firstKeyword != null) break;
                                                firstKeyword = lastKeyword;
                                            }
                                        }
                                    }
                                    v3 = cursorInsideToken = currentPos >= tokenOffset && currentPos < tokenOffset + tokenLength;
                                    if (!isControl || !scriptMode && !cursorInsideToken || hasValuableTokens) ** GOTO lbl109
                                    controlText = document.get(tokenOffset, tokenLength);
                                    commandId = null;
                                    if (token instanceof SQLControlToken) {
                                        commandId = ((SQLControlToken)token).getCommandId();
                                    }
                                    if (!(command = new SQLControlCommand(context.getDataSource(), context.getSyntaxManager(), controlText.trim(), commandId, tokenOffset, tokenLength, tokenType == SQLTokenType.T_SET_DELIMITER)).isEmptyCommand() && (command.getCommandId() == null || SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId()) == null)) break block49;
                                    var32_35 = command;
                                    if (!token.isWhitespace() && !token.isEOF()) {
                                        prevNotEmptyTokenType = tokenType;
                                    }
                                    return var32_35;
                                }
                                isControl = false;
lbl109:
                                // 2 sources

                                if (!hasValuableTokens || !token.isEOF() && (!isDelimiter || tokenOffset + tokenLength < currentPos) && tokenOffset <= endPos) break block50;
                                if (tokenOffset > endPos) {
                                    tokenOffset = endPos;
                                }
                                if (tokenOffset >= document.getLength()) {
                                    tokenOffset = document.getLength();
                                }
                                if (SQLScriptParser.$assertionsDisabled || tokenOffset >= currentPos) ** GOTO lbl117
                                throw new AssertionError();
lbl-1000:
                                // 1 sources

                                {
                                    ++statementStart;
lbl117:
                                    // 2 sources

                                    ** while (statementStart < tokenOffset && Character.isWhitespace((char)document.getChar((int)statementStart)))
                                }
lbl118:
                                // 1 sources

                                if (tokenOffset != statementStart) break block51;
                                if (!token.isEOF()) break block52;
                                if (!token.isWhitespace() && !token.isEOF()) {
                                    prevNotEmptyTokenType = tokenType;
                                }
                                return null;
                            }
                            statementStart = tokenOffset + tokenLength;
                            continue;
                        }
                        queryText = document.get(statementStart, tokenOffset - statementStart);
                        queryText = SQLUtils.fixLineFeeds((String)queryText);
                        if (isDelimiter && (keepDelimiters || hasBlocks && dialect.isDelimiterAfterQuery() || SQLScriptParser.needsDelimiterAfterBlock(firstKeyword, lastKeyword, dialect)) && delimiterText != null && delimiterText.equals(";")) {
                            queryText = String.valueOf(queryText) + delimiterText;
                        }
                        queryEndPos = tokenOffset;
                        if (tokenType == SQLTokenType.T_DELIMITER) {
                            queryEndPos += tokenLength;
                        }
                        if (curBlock != null) {
                            SQLScriptParser.log.trace((Object)"Found leftover blocks in script after parsing");
                        }
                        var32_36 = new SQLQuery(context.getDataSource(), queryText, statementStart, queryEndPos - statementStart);
                        if (!token.isWhitespace() && !token.isEOF()) {
                            prevNotEmptyTokenType = tokenType;
                        }
                        return var32_36;
                    }
                    if (isDelimiter) {
                        statementStart = tokenOffset + tokenLength;
                    }
                    if (!token.isEOF()) break block53;
                    if (!token.isWhitespace() && !token.isEOF()) {
                        prevNotEmptyTokenType = tokenType;
                    }
                    return null;
                }
                try {
                    try {
                        if (hasValuableTokens || token.isWhitespace() || isControl) break block54;
                        hasValuableTokens = tokenType == SQLTokenType.T_COMMENT ? dialect.supportsCommentQuery() : true;
                    }
                    catch (BadLocationException e) {
                        SQLScriptParser.log.warn((Object)"Error parsing query", (Throwable)e);
                    }
                }
                catch (Throwable var31_37) {
                    throw var31_37;
                }
                finally {
                    if (token.isWhitespace() || token.isEOF()) continue;
                    prevNotEmptyTokenType = tokenType;
                    continue;
                }
            }
            if (token.isWhitespace() || token.isEOF()) continue;
            prevNotEmptyTokenType = tokenType;
        }
    }

    private static boolean needsDelimiterAfterBlock(String firstKeyword, String lastKeyword, SQLDialect dialect) {
        if (dialect.needsDelimiterFor(firstKeyword, lastKeyword)) {
            return true;
        }
        if (!dialect.isDelimiterAfterBlock()) {
            return false;
        }
        if (firstKeyword == null) {
            return false;
        }
        if (!"END".equalsIgnoreCase(lastKeyword)) {
            return false;
        }
        firstKeyword = firstKeyword.toUpperCase(Locale.ENGLISH);
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] bb = stringArray[n2];
                if (bb[0].equals(firstKeyword)) {
                    return true;
                }
                ++n2;
            }
        }
        return ArrayUtils.contains((Object[])dialect.getBlockHeaderStrings(), (Object)firstKeyword) || ArrayUtils.contains((Object[])dialect.getDDLKeywords(), (Object)firstKeyword);
    }

    private static int countLineFeeds(IDocument document, int offset, int length) {
        int lfCount = 0;
        try {
            int i = offset;
            while (i < offset + length) {
                if (document.getChar(i) == '\n') {
                    ++lfCount;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return lfCount;
    }

    public static SQLScriptElement extractQueryAtPos(SQLParserContext context, int currentPos) {
        int startPos;
        IDocument document;
        block24: {
            int currentLine;
            boolean lineFeedIsDelimiter;
            int lastPos;
            Object[] statementDelimiters;
            boolean useBlankLines;
            IDocumentPartitioner partitioner;
            int docLength;
            block22: {
                block23: {
                    int originalPosLine;
                    document = context.getDocument();
                    if (document.getLength() == 0) {
                        return null;
                    }
                    SQLSyntaxManager syntaxManager = context.getSyntaxManager();
                    docLength = document.getLength();
                    IDocumentPartitioner iDocumentPartitioner = partitioner = document instanceof IDocumentExtension3 ? ((IDocumentExtension3)document).getDocumentPartitioner("___sql_partitioning") : null;
                    if (partitioner != null) {
                        while (currentPos < docLength && SQLScriptParser.isMultiCommentPartition(partitioner, currentPos)) {
                            ++currentPos;
                        }
                    }
                    startPos = 0;
                    useBlankLines = syntaxManager.isBlankLineDelimiter();
                    statementDelimiters = syntaxManager.getStatementDelimiters();
                    lastPos = currentPos >= docLength ? docLength - 1 : currentPos;
                    lineFeedIsDelimiter = ArrayUtils.contains((Object[])statementDelimiters, (Object)"\n");
                    currentLine = originalPosLine = document.getLineOfOffset(currentPos);
                    if (!useBlankLines || !TextUtils.isEmptyLine(document, currentLine)) break block22;
                    if (currentLine != 0) break block23;
                    return null;
                }
                if (!TextUtils.isEmptyLine(document, --currentLine)) break block22;
                return null;
            }
            try {
                if (!lineFeedIsDelimiter) {
                    document.getLineOffset(currentLine);
                    int firstLine = currentLine;
                    while (firstLine > 0) {
                        if (useBlankLines && TextUtils.isEmptyLine(document, firstLine) && SQLScriptParser.isDefaultPartition(partitioner, document.getLineOffset(firstLine))) break;
                        if (currentLine == firstLine) {
                            Object[] objectArray = statementDelimiters;
                            int n = statementDelimiters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int delimOffset;
                                int offset;
                                Object delim = objectArray[n2];
                                if (!Character.isLetterOrDigit(((String)delim).charAt(0)) && (offset = TextUtils.getOffsetOf(document, firstLine, (String)delim)) >= 0 && SQLScriptParser.isDefaultPartition(partitioner, delimOffset = document.getLineOffset(firstLine) + offset + ((String)delim).length()) && currentPos > startPos && docLength > delimOffset) {
                                    boolean hasValuableChars = false;
                                    int i = delimOffset;
                                    while (i <= lastPos) {
                                        if (!Character.isWhitespace(document.getChar(i))) {
                                            hasValuableChars = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (hasValuableChars) {
                                        startPos = delimOffset;
                                        break;
                                    }
                                }
                                ++n2;
                            }
                        }
                        --firstLine;
                    }
                    if (startPos == 0) {
                        startPos = document.getLineOffset(firstLine);
                    }
                }
                IRegion region = document.getLineInformation(currentLine);
                if (lineFeedIsDelimiter) {
                    startPos = currentPos = region.getOffset();
                    break block24;
                }
                if (region.getLength() <= 0) break block24;
                int offsetFromLineStart = currentPos - region.getOffset();
                String lineStr = document.get(region.getOffset(), offsetFromLineStart);
                Object[] objectArray = statementDelimiters;
                int n = statementDelimiters.length;
                int n3 = 0;
                while (n3 < n) {
                    Object delim = objectArray[n3];
                    int delimIndex = lineStr.lastIndexOf((String)delim);
                    if (delimIndex != -1) {
                        boolean hasValuableChars = false;
                        int i = region.getOffset() + delimIndex + ((String)delim).length();
                        while (i < currentPos) {
                            if (!Character.isWhitespace(document.getChar(i))) {
                                hasValuableChars = true;
                                break;
                            }
                            ++i;
                        }
                        if (!hasValuableChars) {
                            currentPos = region.getOffset() + delimIndex - 1;
                            break;
                        }
                    }
                    ++n3;
                }
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
            }
        }
        return SQLScriptParser.parseQuery(context, startPos, document.getLength(), currentPos, false, false);
    }

    private static boolean isDefaultPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner == null || "__dftl_partition_content_type".equals(partitioner.getContentType(currentPos));
    }

    private static boolean isMultiCommentPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner != null && "sql_multiline_comment".equals(partitioner.getContentType(currentPos));
    }

    public static SQLScriptElement extractNextQuery(SQLParserContext context, int offset, boolean next) {
        int curPos;
        block15: {
            SQLScriptElement curElement = SQLScriptParser.extractQueryAtPos(context, offset);
            if (curElement == null) {
                return null;
            }
            IDocument document = context.getDocument();
            try {
                int docLength = document.getLength();
                if (next) {
                    String[] statementDelimiters = context.getSyntaxManager().getStatementDelimiters();
                    curPos = curElement.getOffset() + curElement.getLength();
                    while (curPos < docLength) {
                        char c = document.getChar(curPos);
                        if (!Character.isWhitespace(c)) {
                            boolean isDelimiter = false;
                            String[] stringArray = statementDelimiters;
                            int n = statementDelimiters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String delim = stringArray[n2];
                                if (delim.indexOf(c) != -1) {
                                    isDelimiter = true;
                                }
                                ++n2;
                            }
                            if (!isDelimiter) break;
                        }
                        ++curPos;
                    }
                } else {
                    curPos = curElement.getOffset() - 1;
                    while (curPos >= 0) {
                        char c = document.getChar(curPos);
                        if (!Character.isLetter(c)) {
                            --curPos;
                            continue;
                        }
                        break;
                    }
                }
                if (curPos > 0 && curPos < docLength) break block15;
                return null;
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
                return null;
            }
        }
        return SQLScriptParser.extractQueryAtPos(context, curPos);
    }

    @Nullable
    public static SQLScriptElement extractActiveQuery(SQLParserContext context, int selOffset, int selLength) {
        SQLScriptElement element;
        String selText = null;
        if (selOffset >= 0 && selLength > 0) {
            try {
                selText = context.getDocument().get(selOffset, selLength);
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
        }
        if (selText != null && context.getPreferenceStore().getBoolean("script.sql.query.remove.trailing.delimiter")) {
            SQLSyntaxManager syntaxManager;
            selText = SQLUtils.trimQueryStatement((SQLSyntaxManager)syntaxManager, (String)selText, (!(syntaxManager = context.getSyntaxManager()).getDialect().isDelimiterAfterQuery() ? 1 : 0) != 0);
        }
        if (!CommonUtils.isEmpty(selText)) {
            SQLScriptElement parsedElement = SQLScriptParser.parseQuery(context, selOffset, selOffset + selLength, selOffset, false, false);
            if (parsedElement instanceof SQLControlCommand) {
                element = parsedElement;
            } else {
                selText = SQLUtils.fixLineFeeds((String)selText);
                element = new SQLQuery(context.getDataSource(), selText, selOffset, selLength);
            }
        } else {
            element = selOffset >= 0 ? SQLScriptParser.extractQueryAtPos(context, selOffset) : null;
        }
        if (element == null || CommonUtils.isEmpty((String)element.getText())) {
            return null;
        }
        if (element instanceof SQLQuery && context.getPreferenceStore().getBoolean("sql.parameter.enabled")) {
            SQLQuery query = (SQLQuery)element;
            query.setParameters(SQLScriptParser.parseParameters(context, query.getOffset(), query.getLength()));
        }
        return element;
    }

    public static List<SQLQueryParameter> parseParameters(SQLParserContext context, int queryOffset, int queryLength) {
        SQLDialect sqlDialect = context.getDialect();
        IDocument document = context.getDocument();
        if (queryOffset + queryLength > document.getLength()) {
            queryLength = document.getLength() - queryOffset;
        }
        SQLSyntaxManager syntaxManager = context.getSyntaxManager();
        boolean supportParamsInDDL = context.getPreferenceStore().getBoolean("sql.parameter.ddl.enabled");
        boolean execQuery = false;
        boolean ddlQuery = false;
        ArrayList<Object> parameters = null;
        TPRuleBasedScanner ruleScanner = context.getScanner();
        ruleScanner.setRange(document, queryOffset, queryLength);
        boolean firstKeyword = true;
        while (true) {
            SQLTokenType tokenType;
            TPToken token = ruleScanner.nextToken();
            int tokenOffset = ruleScanner.getTokenOffset();
            int tokenLength = ruleScanner.getTokenLength();
            if (token.isEOF() || tokenOffset > queryOffset + queryLength) break;
            SQLTokenType sQLTokenType = tokenType = token instanceof TPTokenDefault ? (SQLTokenType)((TPTokenDefault)token).getData() : null;
            if (token.isWhitespace() || tokenType == SQLTokenType.T_COMMENT) continue;
            if (firstKeyword) {
                try {
                    String tokenText = document.get(tokenOffset, tokenLength);
                    if (ArrayUtils.containsIgnoreCase((String[])sqlDialect.getDDLKeywords(), (String)tokenText)) {
                        ddlQuery = true;
                    } else {
                        execQuery = ArrayUtils.containsIgnoreCase((String[])sqlDialect.getExecuteKeywords(), (String)tokenText);
                    }
                }
                catch (BadLocationException e) {
                    log.warn((Object)e);
                }
                firstKeyword = false;
            }
            if (tokenType != SQLTokenType.T_PARAMETER || tokenLength <= 0) continue;
            try {
                String paramName = document.get(tokenOffset, tokenLength);
                if (!supportParamsInDDL && ddlQuery || execQuery && paramName.equals(String.valueOf(syntaxManager.getAnonymousParameterMark()))) continue;
                if (parameters == null) {
                    parameters = new ArrayList<SQLQueryParameter>();
                }
                SQLQueryParameter parameter = new SQLQueryParameter(syntaxManager, parameters.size(), paramName, tokenOffset - queryOffset, tokenLength);
                parameter.setPrevious(SQLScriptParser.getPreviousParameter(parameters, parameter));
                parameters.add(parameter);
            }
            catch (BadLocationException e) {
                log.warn((Object)"Can't extract query parameter", (Throwable)e);
            }
        }
        if (syntaxManager.isVariablesEnabled()) {
            try {
                String query = document.get(queryOffset, queryLength);
                Matcher matcher = SQLQueryParameter.getVariablePattern().matcher(query);
                int position = 0;
                while (matcher.find(position)) {
                    int start = matcher.start();
                    int orderPos = 0;
                    SQLQueryParameter param = null;
                    if (parameters != null) {
                        for (SQLQueryParameter sQLQueryParameter : parameters) {
                            if (sQLQueryParameter.getTokenOffset() == start) {
                                param = sQLQueryParameter;
                                break;
                            }
                            if (sQLQueryParameter.getTokenOffset() >= start) continue;
                            ++orderPos;
                        }
                    }
                    if (param == null) {
                        param = new SQLQueryParameter(syntaxManager, orderPos, matcher.group(0), start, matcher.end() - matcher.start());
                        if (parameters == null) {
                            parameters = new ArrayList();
                        }
                        param.setPrevious(SQLScriptParser.getPreviousParameter(parameters, param));
                        parameters.add(param.getOrdinalPosition(), param);
                    }
                    position = matcher.end();
                }
            }
            catch (BadLocationException e) {
                log.warn((Object)"Error parsing variables", (Throwable)e);
            }
        }
        return parameters;
    }

    private static SQLQueryParameter getPreviousParameter(List<SQLQueryParameter> parameters, SQLQueryParameter parameter) {
        String varName = parameter.getVarName();
        if (parameter.isNamed()) {
            int i = parameters.size();
            while (i > 0) {
                if (parameters.get(i - 1).getVarName().equals(varName)) {
                    return parameters.get(i - 1);
                }
                --i;
            }
        }
        return null;
    }

    public static List<SQLScriptElement> extractScriptQueries(SQLParserContext parserContext, int startOffset, int length, boolean scriptMode, boolean keepDelimiters, boolean parseParameters) {
        ArrayList<SQLScriptElement> queryList = new ArrayList<SQLScriptElement>();
        IDocument document = parserContext.getDocument();
        if (document.getLength() == 0) {
            return queryList;
        }
        parserContext.startScriptEvaluation();
        try {
            SQLScriptElement query;
            int queryOffset = startOffset;
            while ((query = SQLScriptParser.parseQuery(parserContext, queryOffset, startOffset + length, queryOffset, scriptMode, keepDelimiters)) != null) {
                queryList.add(query);
                queryOffset = query.getOffset() + query.getLength();
            }
        }
        finally {
            parserContext.endScriptEvaluation();
        }
        if (parseParameters && parserContext.getPreferenceStore().getBoolean("sql.parameter.enabled")) {
            for (SQLScriptElement element : queryList) {
                if (!(element instanceof SQLQuery)) continue;
                SQLQuery query = (SQLQuery)element;
                query.setParameters(SQLScriptParser.parseParameters(parserContext, query.getOffset(), query.getLength()));
            }
        }
        return queryList;
    }

    public static List<SQLScriptElement> parseScript(DBCExecutionContext executionContext, String sqlScriptContent) {
        DBPContextProvider contextProvider = () -> executionContext;
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(executionContext.getDataSource());
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules(executionContext.getDataSource(), false);
        Document sqlDocument = new Document(sqlScriptContent);
        SQLParserContext parserContext = new SQLParserContext(contextProvider, syntaxManager, ruleManager, (IDocument)sqlDocument);
        return SQLScriptParser.extractScriptQueries(parserContext, 0, sqlScriptContent.length(), true, false, true);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType;
        }
        int[] nArray = new int[SQLTokenType.values().length];
        try {
            nArray[SQLTokenType.T_BLOCK_BEGIN.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_END.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_HEADER.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_TOGGLE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_COMMENT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_CONTROL.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_DELIMITER.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_KEYWORD.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_NUMBER.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_OTHER.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_PARAMETER.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_QUOTED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_SET_DELIMITER.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_STRING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_TYPE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_UNKNOWN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_VARIABLE.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType = nArray;
        return nArray;
    }

    private static class ScriptBlockInfo {
        final ScriptBlockInfo parent;
        final String togglePattern;
        boolean isHeader;

        ScriptBlockInfo(ScriptBlockInfo parent, boolean isHeader) {
            this.parent = parent;
            this.togglePattern = null;
            this.isHeader = isHeader;
        }

        ScriptBlockInfo(ScriptBlockInfo parent, String togglePattern) {
            this.parent = parent;
            this.togglePattern = togglePattern;
        }
    }
}

