/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.server;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Server;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class EmbeddedDatabase {
    private static final Log log = Log.getLog(EmbeddedDatabase.class);
    private final String databaseId;
    private File databasePath;
    private Server h2Server;
    private Connection h2Connection;
    private boolean oldFormat = false;

    public EmbeddedDatabase(String databaseId) {
        this.databaseId = databaseId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public File getDatabasePath() {
        return this.databasePath;
    }

    public boolean isOldFormat() {
        return this.oldFormat;
    }

    public void setOldFormat(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    public void start() throws DBException {
        this.databasePath = new File(GeneralUtils.getMetadataFolder(), this.databaseId);
        if (!this.databasePath.exists() && !this.databasePath.mkdir()) {
            throw new DBException("Can't create QM database data folder: " + this.databasePath.getAbsolutePath());
        }
        System.setProperty("h2.bindAddress", "localhost");
        Properties props = new Properties();
        String h2URL = this.makeURL();
        try {
            this.h2Connection = new Driver().connect(h2URL, props);
        }
        catch (SQLException e) {
            throw new DBException("Error openings H2 connection [" + h2URL + "]", (Throwable)e);
        }
        try {
            int freePort;
            try {
                Throwable throwable = null;
                Object var5_9 = null;
                try (ServerSocket ss = new ServerSocket(0);){
                    freePort = ss.getLocalPort();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
                freePort = 9123;
            }
            this.h2Server = Server.createTcpServer((String[])new String[]{"-tcpPort", String.valueOf(freePort)});
            this.h2Server.start();
        }
        catch (Exception e) {
            throw new DBException("Error starting H2 server", (Throwable)e);
        }
    }

    private String makeURL() {
        File dbFile = new File(this.databasePath, this.databaseId);
        String url = "jdbc:h2:" + dbFile.getAbsolutePath();
        if (this.oldFormat) {
            url = String.valueOf(url) + ";MV_STORE=FALSE;MVCC=FALSE";
        }
        return url;
    }

    public boolean isRunning() {
        if (this.h2Server != null) {
            return this.h2Server.isRunning(true);
        }
        return false;
    }

    public void stop() throws DBException {
        if (this.h2Connection != null) {
            try {
                this.h2Connection.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error closing H2 connection", (Throwable)e);
            }
            this.h2Connection = null;
        }
        if (this.h2Server != null) {
            try {
                this.h2Server.stop();
            }
            catch (Exception e) {
                log.error((Object)"Error stopping HJ2 server", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.h2Connection;
    }

    public void backupDatabase(File toFile) throws DBException {
        if (this.h2Connection == null) {
            throw new DBException("H2 server not started");
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement dbStat = this.h2Connection.createStatement();){
                dbStat.execute("BACKUP TO '" + toFile.getAbsolutePath() + "'");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error running backup", (Throwable)e);
        }
    }

    public void restoreDatabase(File backupFile) throws DBException {
        Restore.execute((String)backupFile.getAbsolutePath(), (String)this.databasePath.getAbsolutePath(), (String)this.databaseId);
    }

    public File dumpDatabaseToSQL() throws DBException {
        try {
            Recover.execute((String)this.databasePath.getAbsolutePath(), (String)this.databaseId);
            File sqlFile = new File(this.databasePath, String.valueOf(this.databaseId) + ".h2.sql");
            if (!sqlFile.exists()) {
                throw new DBException("Error dumping database - target file '" + sqlFile.getAbsolutePath() + "' doesn't exists");
            }
            return sqlFile;
        }
        catch (Exception e) {
            throw new DBException("Error running recover", (Throwable)e);
        }
    }

    public void restoreFromSQL(File backupFile) throws DBException {
        try {
            String url = this.makeURL();
            RunScript.execute((String)url, (String)"", (String)"", (String)backupFile.getAbsolutePath(), (Charset)Charset.defaultCharset(), (boolean)true);
        }
        catch (Exception e) {
            throw new DBException("Error restoring SQL dump", (Throwable)e);
        }
    }

    public void deleteDatabaseFiles() {
        File[] files = this.databasePath.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().endsWith(".db")) {
                    log.debug((Object)("Delete DB file " + file.getName()));
                    if (!file.delete()) {
                        log.debug((Object)"Delete failed");
                    }
                }
                ++n2;
            }
        }
    }
}

