/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.model;

import com.dbeaver.ee.qmdb.model.QMDBModel;
import com.dbeaver.ee.qmdb.model.QMDBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class QMDBEventListener
implements QMMetaListener {
    private static final Log log = Log.getLog(QMDBEventListener.class);
    private final QMDBModel model;
    private final PreparedStatement dbStatQueryRead;
    private final PreparedStatement dbStatQueryWrite;
    private final PreparedStatement dbStatEvent;
    private final PreparedStatement dbStatStatement;
    private Map<String, Long> connectionMap = new HashMap<String, Long>();

    public QMDBEventListener(QMDBModel model) throws SQLException {
        this.model = model;
        this.dbStatQueryRead = model.getConnection().prepareStatement("SELECT QUERY_ID,QUERY_TEXT FROM " + model.getTableName("QM_QUERY") + " WHERE QUERY_HASH=?");
        this.dbStatQueryWrite = model.getConnection().prepareStatement("INSERT INTO " + model.getTableName("QM_QUERY") + "(QUERY_HASH,QUERY_TEXT) VALUES(?,?)", 1);
        this.dbStatEvent = model.getConnection().prepareStatement("INSERT INTO " + model.getTableName("QM_EVENT") + " (CONNECTION_ID,SOURCE_ID,EVENT_ACTION,EVENT_TYPE,EVENT_TIME) VALUES(?,?,?,?,?)", 1);
        this.dbStatStatement = model.getConnection().prepareStatement("INSERT INTO " + model.getTableName("QM_STATEMENT") + " (STATEMENT_ID,STATEMENT_PURPOSE,QUERY_ID,ROW_COUNT,ERROR_CODE,ERROR_MESSAGE,EXECUTE_TIME,FETCH_TIME) VALUES(?,?,?,?,?,?,?,?)");
    }

    public void dispose() {
        try {
            if (this.dbStatQueryWrite != null) {
                this.dbStatQueryWrite.close();
            }
            if (this.dbStatQueryRead != null) {
                this.dbStatQueryRead.close();
            }
            if (this.dbStatEvent != null) {
                this.dbStatEvent.close();
            }
            if (this.dbStatStatement != null) {
                this.dbStatStatement.close();
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    public synchronized void metaInfoChanged(DBRProgressMonitor monitor, @NotNull List<QMMetaEvent> events) {
        if (this.model.getConnection() == null) {
            return;
        }
        monitor.beginTask("Persist events", events.size());
        int i = events.size();
        while (i > 0) {
            QMMetaEvent event = events.get(i - 1);
            monitor.subTask("Event " + event.getObject().getObjectId());
            try {
                this.processEvent(event);
            }
            catch (SQLException e) {
                log.debug((Object)"QMDB error", (Throwable)e);
            }
            monitor.worked(1);
            --i;
        }
        monitor.done();
    }

    @NotNull
    private static String makeConnectionKey(QMMSessionInfo sessionInfo) {
        return String.valueOf(sessionInfo.getContainerId()) + ": " + sessionInfo.getInstanceId() + ":" + sessionInfo.getContextName();
    }

    private int getEventTypeId(QMMObject object) {
        Class<?> eventClass = object.getClass();
        if (eventClass == QMMSessionInfo.class) {
            return 1;
        }
        if (eventClass == QMMTransactionInfo.class) {
            return 2;
        }
        if (eventClass == QMMTransactionSavepointInfo.class) {
            return 3;
        }
        if (eventClass == QMMStatementInfo.class) {
            return 4;
        }
        if (eventClass == QMMStatementExecuteInfo.class) {
            return 5;
        }
        return -1;
    }

    private synchronized void processEvent(QMMetaEvent event) throws SQLException {
        if (event.getAction() == QMMetaEvent.Action.UPDATE) {
            return;
        }
        QMMObject object = event.getObject();
        if (object instanceof QMMSessionInfo) {
            if (event.getAction() == QMMetaEvent.Action.BEGIN) {
                this.createConnectionInfo((QMMSessionInfo)object);
                this.createConnectionEvent(event, (QMMSessionInfo)object, event.getAction() == QMMetaEvent.Action.BEGIN);
            } else if (event.getAction() == QMMetaEvent.Action.END) {
                this.createConnectionEvent(event, (QMMSessionInfo)object, event.getAction() == QMMetaEvent.Action.BEGIN);
                this.closeConnectionInfo((QMMSessionInfo)object);
            }
        } else if (object instanceof QMMTransactionInfo) {
            this.createTransactionEvent(event, (QMMTransactionInfo)object, event.getAction() == QMMetaEvent.Action.BEGIN);
        } else if (object instanceof QMMStatementExecuteInfo) {
            this.createStatementEvent(event, (QMMStatementExecuteInfo)object);
        }
    }

    private long createConnectionInfo(QMMSessionInfo sessionInfo) throws SQLException {
        Long connectionId = this.connectionMap.get(QMDBEventListener.makeConnectionKey(sessionInfo));
        if (connectionId != null) {
            log.debug((Object)"Connection info already exists. Mixed events?");
            return connectionId;
        }
        Long runId = this.model.getRunId();
        String dsName = (String)JDBCUtils.executeQuery((Connection)this.model.getConnection(), (String)("SELECT NAME  FROM " + this.model.getTableName("QM_DATASOURCE") + " WHERE DATASOURCE_ID=?"), (Object[])new Object[]{sessionInfo.getContainerId()});
        if (dsName == null) {
            JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("INSERT INTO " + this.model.getTableName("QM_DATASOURCE") + " (DATASOURCE_ID,NAME,URL,DRIVER,UPDATE_TIME) VALUES(?,?,?,?,?)"), (Object[])new Object[]{sessionInfo.getContainerId(), sessionInfo.getContainerName(), CommonUtils.notEmpty((String)sessionInfo.getConnectionConfiguration().getUrl()), sessionInfo.getDriverId(), new Date()});
        } else {
            JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("UPDATE " + this.model.getTableName("QM_DATASOURCE") + " SET NAME=?,URL=?,DRIVER=?,UPDATE_TIME=? WHERE DATASOURCE_ID=?"), (Object[])new Object[]{sessionInfo.getContainerName(), CommonUtils.notEmpty((String)sessionInfo.getConnectionConfiguration().getUrl()), sessionInfo.getDriverId(), new Date(), sessionInfo.getContainerId()});
        }
        connectionId = QMDBUtils.executeInsertAutoIncrement(this.model.getConnection(), "INSERT INTO " + this.model.getTableName("QM_CONNECTION") + " (RUN_ID,DATASOURCE_ID,INSTANCE_ID,CONTEXT_NAME,CONNECTION_USER,CONNECT_TIME) VALUES(?,?,?,?,?,?)", runId, sessionInfo.getContainerId(), CommonUtils.truncateString((String)CommonUtils.notEmpty((String)sessionInfo.getInstanceId()), (int)64), CommonUtils.notEmpty((String)sessionInfo.getContextName()), CommonUtils.notEmpty((String)sessionInfo.getConnectionConfiguration().getUserName()), new Date());
        this.connectionMap.put(QMDBEventListener.makeConnectionKey(sessionInfo), connectionId);
        return connectionId;
    }

    private void closeConnectionInfo(QMMSessionInfo sessionInfo) throws SQLException {
        Long connectionId = this.connectionMap.get(QMDBEventListener.makeConnectionKey(sessionInfo));
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for close"));
            return;
        }
        JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("UPDATE " + this.model.getTableName("QM_CONNECTION") + " SET DISCONNECT_TIME=? WHERE CONNECTION_ID=?"), (Object[])new Object[]{new Date(), connectionId});
        this.connectionMap.remove(QMDBEventListener.makeConnectionKey(sessionInfo));
    }

    private long createEventInfo(QMMetaEvent event, QMMSessionInfo sessionInfo) throws SQLException {
        Long connectionId = this.connectionMap.get(QMDBEventListener.makeConnectionKey(sessionInfo));
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for event " + event.getAction() + ". Create new one"));
            connectionId = this.createConnectionInfo(sessionInfo);
        }
        this.dbStatEvent.setLong(1, connectionId);
        this.dbStatEvent.setNull(2, 12);
        this.dbStatEvent.setInt(3, event.getAction().getId());
        this.dbStatEvent.setInt(4, this.getEventTypeId(event.getObject()));
        this.dbStatEvent.setTimestamp(5, new Timestamp(event.getObject().getOpenTime()));
        this.dbStatEvent.execute();
        return QMDBUtils.getGeneratedKey(this.dbStatEvent);
    }

    private void createConnectionEvent(QMMetaEvent event, QMMSessionInfo sessionInfo, boolean start) throws SQLException {
        this.createEventInfo(event, sessionInfo);
    }

    private void createTransactionEvent(QMMetaEvent event, QMMTransactionInfo transactionInfo, boolean start) throws SQLException {
        this.createEventInfo(event, transactionInfo.getSession());
    }

    private void createStatementEvent(QMMetaEvent event, QMMStatementExecuteInfo executeInfo) throws SQLException {
        long eventId = this.createEventInfo(event, executeInfo.getStatement().getSession());
        long queryId = this.getQueryId(executeInfo.getQueryString());
        if (event.getAction() == QMMetaEvent.Action.END) {
            this.dbStatStatement.setLong(1, eventId);
            this.dbStatStatement.setInt(2, executeInfo.getStatement().getPurpose().getId());
            this.dbStatStatement.setLong(3, queryId);
            this.dbStatStatement.setLong(4, executeInfo.getUpdateRowCount());
            this.dbStatStatement.setInt(5, executeInfo.getErrorCode());
            if (CommonUtils.isEmpty((String)executeInfo.getErrorMessage())) {
                this.dbStatStatement.setNull(6, 12);
            } else {
                this.dbStatStatement.setString(6, executeInfo.getErrorMessage());
            }
            this.dbStatStatement.setInt(7, (int)(executeInfo.getCloseTime() - executeInfo.getOpenTime()));
            long fetchEndTime = executeInfo.getFetchEndTime();
            this.dbStatStatement.setInt(8, (int)(fetchEndTime > 0L ? fetchEndTime - executeInfo.getFetchBeginTime() : 0L));
            this.dbStatStatement.execute();
        }
    }

    public long getQueryId(String query) throws SQLException {
        long hashCode = QMDBUtils.getHashCode(query);
        this.dbStatQueryRead.setLong(1, hashCode);
        Throwable throwable = null;
        Object var5_5 = null;
        try (ResultSet dbResult = this.dbStatQueryRead.executeQuery();){
            while (dbResult.next()) {
                String storedText = dbResult.getString(2);
                if (!storedText.equals(query)) continue;
                return dbResult.getLong(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.dbStatQueryWrite.setLong(1, hashCode);
        this.dbStatQueryWrite.setString(2, query);
        this.dbStatQueryWrite.execute();
        return QMDBUtils.getGeneratedKey(this.dbStatQueryWrite);
    }
}

