/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.graph;

import com.dbeaver.model.sql.plan.emf.SQLPlan;
import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.model.sql.plan.emf.SQLPlanOwner;
import com.dbeaver.ui.editors.sql.plan.diagram.actions.ZoomResetAction;
import com.dbeaver.ui.editors.sql.plan.diagram.features.PlanCreateConnectionFeature;
import com.dbeaver.ui.editors.sql.plan.diagram.features.PlansCollapseDummyFeature;
import com.dbeaver.ui.editors.sql.plan.diagram.features.PlansDetailInfoFeature;
import com.dbeaver.ui.editors.sql.plan.diagram.layout.PlanLayouts;
import com.dbeaver.ui.editors.sql.plan.diagram.provider.PlansDiagramTypeProvider;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import com.dbeaver.ui.editors.sql.plan.diagram.view.CreatePlanContext;
import com.dbeaver.ui.editors.sql.plan.diagram.view.DummyPlanEditor;
import com.dbeaver.ui.editors.sql.plan.graph.SQLPlanDiagramBehavior;
import com.dbeaver.ui.editors.sql.plan.graph.SQLPlanPropertiesPopupDialog;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.elk.alg.graphiti.GraphitiLayoutSetup;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramComposite;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.action.SaveImageAction;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ProxyWorkbenchPart;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;

public class SQLPlanViewerGraphiti
extends Viewer
implements IAdaptable,
SQLPlanOwner {
    private static final int POPUP_DETAILS_HEIGHT = 220;
    private static final int POPUP_DETAILS_WIDTH = 400;
    static final Log log = Log.getLog(SQLPlanViewerGraphiti.class);
    public static final String GRAPHITI_ACTION_SAVE_IMAGE = "org.eclipse.graphiti.ui.internal.action.SaveImageAction";
    private IWorkbenchPart ownerPart;
    private Composite group;
    private DiagramComposite diagramComposite;
    private SQLPlan sqlPlan = null;
    private DummyPlanEditor planEditor;
    private LayoutConfigurator layoutConfig = PlanLayouts.PLAN_HORIZONTAL;
    private IDiagramTypeProvider diagramTypeProvider;
    private IFeatureProvider featureProvider;
    private SQLPlanPropertiesPopupDialog popupProp;
    private Diagram diagram;
    private DiagramBehavior diagramBehavior;
    private boolean gridVisible = false;

    public SQLPlanViewerGraphiti(IWorkbenchPart workbenchPart, Composite parent) {
        this.ownerPart = workbenchPart;
        this.group = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.group.addDisposeListener(e -> {
            if (this.diagramComposite != null) {
                this.diagramComposite.dispose();
            }
        });
        this.configELK();
    }

    public Control getControl() {
        return this.group;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void showPlan(SQLQuery query, DBCPlan plan) {
        SQLPlan sqlPlan = this.makePlanModel(query, plan);
        this.buildDiagram(sqlPlan);
        Composite parent = this.group.getParent();
        parent.layout(true, true);
    }

    private ICreateContext createCreateContext(ContainerShape target, EObject newClass) {
        CreatePlanContext ret = new CreatePlanContext(newClass);
        ret.setTargetContainer(target);
        ret.setLocation(20, 40);
        ret.setSize(50, 50);
        return ret;
    }

    private URI createDiagramFileUri() {
        URI uri = null;
        try {
            uri = URI.createFileURI((String)File.createTempFile(UUID.randomUUID().toString(), ".diagram").getAbsolutePath());
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return uri;
    }

    private void configELK() {
        GraphitiLayoutSetup setup = new GraphitiLayoutSetup();
        GraphitiLayoutSetup.GraphitiLayoutModule glModule = new GraphitiLayoutSetup.GraphitiLayoutModule();
        Injector injector = setup.createInjector((Module)glModule);
        IDiagramLayoutConnector cfr_ignored_0 = (IDiagramLayoutConnector)injector.getInstance(IDiagramLayoutConnector.class);
        ILayoutConfigurationStore.Provider cfr_ignored_1 = (ILayoutConfigurationStore.Provider)injector.getInstance(ILayoutConfigurationStore.Provider.class);
    }

    private void buildDiagram(SQLPlan plan) {
        if (this.diagramComposite != null) {
            this.diagramComposite.dispose();
        }
        this.sqlPlan = plan;
        ProxyWorkbenchPart proxyWorkbenchPart = new ProxyWorkbenchPart(this.ownerPart){

            public <T> T getAdapter(Class<T> adapter) {
                return SQLPlanViewerGraphiti.this.getAdapter(adapter);
            }
        };
        this.diagramComposite = new DiagramComposite((IWorkbenchPart)proxyWorkbenchPart, this.group, 0){

            protected DiagramBehavior createDiagramBehavior() {
                return new SQLPlanDiagramBehavior((IDiagramContainerUI)SQLPlanViewerGraphiti.this.diagramComposite);
            }
        };
        this.diagramComposite.setLayoutData((Object)new GridData(1808));
        this.diagramComposite.setBackground(UIStyles.getDefaultTextBackground());
        this.diagram = Graphiti.getPeService().createDiagram("dbeaver.plan", "Plans");
        TransactionalEditingDomain editingDomain = GraphitiUiInternal.getEmfService().createResourceSetAndEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        URI diagramUri = this.createDiagramFileUri();
        final Resource resource = resourceSet.createResource(diagramUri);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                resource.setTrackingModification(true);
                resource.getContents().add((Object)SQLPlanViewerGraphiti.this.diagram);
            }
        });
        try {
            resource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        DiagramEditorInput input = DiagramEditorInput.createEditorInput((Diagram)this.diagram, (String)PlansDiagramTypeProvider.class.getName());
        this.diagramComposite.setInput((IDiagramEditorInput)input);
        this.diagramTypeProvider = this.diagramComposite.getDiagramTypeProvider();
        this.featureProvider = this.diagramTypeProvider.getFeatureProvider();
        this.diagramComposite.getEditDomain().getCommandStack();
        this.diagramBehavior = this.diagramComposite.getDiagramBehavior();
        this.diagramBehavior.disableAdapters();
        try {
            SQLPlanViewerGraphiti.executeInRecordingCommand((IDiagramBehavior)this.diagramBehavior, () -> this.loadDiagramContents(this.diagramBehavior));
        }
        finally {
            this.diagramBehavior.enableAdapters();
        }
        this.planGrid(this.gridVisible);
        this.planEditor = new DummyPlanEditor(this.diagramComposite.getWorkbenchPart(), this.diagramBehavior, this.diagramTypeProvider);
        this.layoutDiagram();
        this.diagramComposite.getGraphicalViewer().getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SQLPlanPropertiesPopupDialog popup = SQLPlanViewerGraphiti.this.getPropPopup();
                if (popup == null || popup.isClosed()) {
                    return;
                }
                if (!popup.isFocused()) {
                    SQLPlanViewerGraphiti.this.clearPopupDialog();
                }
            }
        });
        this.diagramComposite.getGraphicalViewer().getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (SQLPlanViewerGraphiti.this.diagramBehavior == null || SQLPlanViewerGraphiti.this.diagramBehavior.getDiagramContainer() == null || SQLPlanViewerGraphiti.this.diagramBehavior.getDiagramContainer().getGraphicalViewer() == null) {
                    return;
                }
                EditPart targetEditPart = SQLPlanViewerGraphiti.this.diagramBehavior.getDiagramContainer().getGraphicalViewer().findObjectAt(new Point(Double.valueOf(e.x).doubleValue(), Double.valueOf(e.y).doubleValue()));
                if (SQLPlanViewerGraphiti.this.getPropPopup() != null && targetEditPart instanceof DiagramEditPart) {
                    SQLPlanViewerGraphiti.this.popupProp.close();
                    SQLPlanViewerGraphiti.this.popupProp = null;
                }
            }

            public void mouseHover(MouseEvent e) {
                SQLPlanPropertiesPopupDialog popup = SQLPlanViewerGraphiti.this.getPropPopup();
                if (popup == null || popup.isClosed()) {
                    Rectangle rect = new Rectangle(e.x, e.y, 400, 220);
                    SQLPlanViewerGraphiti.this.initPopupDialog(rect);
                } else {
                    PlanNodeRenderInfo renderInfo = SQLPlanViewerGraphiti.this.getNodeAtPoint(e.x, e.y);
                    if (renderInfo == null || renderInfo == popup.getRenderInfo()) {
                        return;
                    }
                    if (!popup.isFocused()) {
                        SQLPlanViewerGraphiti.this.clearPopupDialog();
                        Rectangle rect = new Rectangle(e.x, e.y, 400, 220);
                        SQLPlanViewerGraphiti.this.initPopupDialog(rect);
                    }
                }
            }
        });
    }

    private SQLPlanPropertiesPopupDialog getPropPopup() {
        return this.popupProp;
    }

    private void planGrid(boolean visible) {
        this.diagramBehavior.getDiagramContainer().getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(visible));
        this.diagramBehavior.getDiagramContainer().getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(visible));
    }

    private void clearPopupDialog() {
        if (this.popupProp != null) {
            this.popupProp.close();
            this.popupProp = null;
        }
    }

    private PlanNodeRenderInfo getNodeAtPoint(int x, int y) {
        if (this.diagram == null) {
            return null;
        }
        if (this.diagramBehavior == null || this.diagramBehavior.getDiagramContainer() == null || this.diagramBehavior.getDiagramContainer().getGraphicalViewer() == null) {
            return null;
        }
        EditPart targetEditPart = this.diagramBehavior.getDiagramContainer().getGraphicalViewer().findObjectAt(new Point(Double.valueOf(x).doubleValue(), Double.valueOf(y).doubleValue()));
        if (targetEditPart == null) {
            return null;
        }
        if (!(targetEditPart instanceof ShapeEditPart)) {
            return null;
        }
        ShapeEditPart shapeEditPart = (ShapeEditPart)targetEditPart;
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(shapeEditPart.getPictogramElement());
        if (bo == null) {
            return null;
        }
        if (!(bo instanceof PlanNodeRenderInfo)) {
            return null;
        }
        return (PlanNodeRenderInfo)bo;
    }

    private void initPopupDialog(Rectangle rect) {
        if (this.diagram == null) {
            return;
        }
        PlanNodeRenderInfo renderInfo = this.getNodeAtPoint(rect.x, rect.y);
        if (renderInfo == null) {
            return;
        }
        if (renderInfo.getNode().isDetailsVisible() || renderInfo.getNodeDetails().length() == 0) {
            return;
        }
        this.popupProp = new SQLPlanPropertiesPopupDialog(new Shell(), rect, renderInfo, "Node details", "Select and hit ESC close");
        this.popupProp.open();
    }

    private void loadDiagramContents(DiagramBehavior diagramBehavior) {
        ICreateFeature[] createFeatures;
        ICreateFeature[] iCreateFeatureArray = createFeatures = this.featureProvider.getCreateFeatures();
        int n = createFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature createFeature = iCreateFeatureArray[n2];
            for (SQLPlanNode node : this.sqlPlan.getAllNodes()) {
                ICreateContext createContext = this.createCreateContext((ContainerShape)this.diagramTypeProvider.getDiagram(), (EObject)node);
                diagramBehavior.executeFeature((IFeature)createFeature, (IContext)createContext);
            }
            ++n2;
        }
        for (SQLPlanNode node : this.sqlPlan.getAllNodes()) {
            ICreateConnectionFeature[] ccfs;
            if (node.getParent() == null) continue;
            Anchor sourceAnchor = (Anchor)node.getParent().getAnchorOUT();
            Anchor targetAnchor = (Anchor)node.getAnchorIN();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourceAnchor(sourceAnchor);
            ccc.setTargetAnchor(targetAnchor);
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = ccfs = new ICreateConnectionFeature[]{new PlanCreateConnectionFeature(this.featureProvider, "plan", "plan node connection")};
            int n3 = ccfs.length;
            int n4 = 0;
            while (n4 < n3) {
                ICreateConnectionFeature ccf = iCreateConnectionFeatureArray[n4];
                diagramBehavior.executeFeature((IFeature)ccf, (IContext)ccc);
                ++n4;
            }
        }
    }

    private SQLPlan makePlanModel(SQLQuery query, DBCPlan plan) {
        SQLPlan sqlPlan = new SQLPlan(query, plan);
        sqlPlan.setOwnerPart((SQLPlanOwner)this);
        return sqlPlan;
    }

    private void expandDiagram() {
        ICustomFeature[] customFeature;
        ICustomFeature[] iCustomFeatureArray = customFeature = this.featureProvider.getCustomFeatures((ICustomContext)new CustomContext(new PictogramElement[0]));
        int n = customFeature.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature feature = iCustomFeatureArray[n2];
            if (feature instanceof PlansCollapseDummyFeature) {
                this.sqlPlan.getAllNodes().stream().filter(SQLPlanNode::isCollapsed).forEach(p -> {
                    for (Object o : ((PictogramElement)p.getContainer()).getLink().getBusinessObjects()) {
                        if (!(o instanceof PlanNodeRenderInfo)) continue;
                        SQLPlanViewerGraphiti.executeInRecordingCommand((IDiagramBehavior)this.diagramComposite.getDiagramBehavior(), () -> ((PlansCollapseDummyFeature)feature).expandNode((SQLPlanNode)p, (PlanNodeRenderInfo)((Object)((Object)((Object)o)))));
                    }
                });
            }
            ++n2;
        }
        this.layoutDiagram();
    }

    private void collapseDiagram() {
        ICustomFeature[] customFeature;
        ICustomFeature[] iCustomFeatureArray = customFeature = this.featureProvider.getCustomFeatures((ICustomContext)new CustomContext(new PictogramElement[0]));
        int n = customFeature.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature feature = iCustomFeatureArray[n2];
            if (feature instanceof PlansCollapseDummyFeature) {
                this.sqlPlan.getRoutePart().stream().filter(p -> !p.isCollapsed()).forEach(p -> {
                    for (Object o : ((PictogramElement)p.getContainer()).getLink().getBusinessObjects()) {
                        if (!(o instanceof PlanNodeRenderInfo)) continue;
                        SQLPlanViewerGraphiti.executeInRecordingCommand((IDiagramBehavior)this.diagramComposite.getDiagramBehavior(), () -> ((PlansCollapseDummyFeature)feature).collapseNode((SQLPlanNode)p, (PlanNodeRenderInfo)((Object)((Object)((Object)o)))));
                    }
                });
            }
            ++n2;
        }
        this.layoutDiagram();
    }

    private void detailDiagram() {
        ICustomFeature[] customFeature;
        ICustomFeature[] iCustomFeatureArray = customFeature = this.featureProvider.getCustomFeatures((ICustomContext)new CustomContext(new PictogramElement[0]));
        int n = customFeature.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature feature = iCustomFeatureArray[n2];
            if (feature instanceof PlansDetailInfoFeature) {
                this.sqlPlan.getAllNodes().stream().filter(p -> !p.isCollapsed() && !p.isDetailsVisible()).forEach(p -> {
                    for (Object o : ((PictogramElement)p.getContainer()).getLink().getBusinessObjects()) {
                        if (!(o instanceof PlanNodeRenderInfo)) continue;
                        SQLPlanViewerGraphiti.executeInRecordingCommand((IDiagramBehavior)this.diagramComposite.getDiagramBehavior(), () -> ((PlansDetailInfoFeature)feature).setDetailInfo((SQLPlanNode)p, (PlanNodeRenderInfo)((Object)((Object)((Object)o))), true));
                    }
                });
            }
            ++n2;
        }
        this.layoutDiagram();
    }

    private void shortenDiagram() {
        ICustomFeature[] customFeature;
        ICustomFeature[] iCustomFeatureArray = customFeature = this.featureProvider.getCustomFeatures((ICustomContext)new CustomContext(new PictogramElement[0]));
        int n = customFeature.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature feature = iCustomFeatureArray[n2];
            if (feature instanceof PlansDetailInfoFeature) {
                this.sqlPlan.getAllNodes().stream().filter(p -> p.isDetailsVisible()).forEach(p -> {
                    for (Object o : ((PictogramElement)p.getContainer()).getLink().getBusinessObjects()) {
                        if (!(o instanceof PlanNodeRenderInfo)) continue;
                        SQLPlanViewerGraphiti.executeInRecordingCommand((IDiagramBehavior)this.diagramComposite.getDiagramBehavior(), () -> ((PlansDetailInfoFeature)feature).setDetailInfo((SQLPlanNode)p, (PlanNodeRenderInfo)((Object)((Object)((Object)o))), false));
                    }
                });
            }
            ++n2;
        }
        this.layoutDiagram();
    }

    private void detailHotDiagram() {
        ICustomFeature[] customFeature;
        ICustomFeature[] iCustomFeatureArray = customFeature = this.featureProvider.getCustomFeatures((ICustomContext)new CustomContext(new PictogramElement[0]));
        int n = customFeature.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature feature = iCustomFeatureArray[n2];
            if (feature instanceof PlansDetailInfoFeature) {
                this.sqlPlan.getAllNodes().stream().filter(p -> !p.isCollapsed() && !p.isDetailsVisible() && p.isHeavyRoute()).forEach(p -> {
                    for (Object o : ((PictogramElement)p.getContainer()).getLink().getBusinessObjects()) {
                        if (!(o instanceof PlanNodeRenderInfo)) continue;
                        SQLPlanViewerGraphiti.executeInRecordingCommand((IDiagramBehavior)this.diagramComposite.getDiagramBehavior(), () -> ((PlansDetailInfoFeature)feature).setDetailInfo((SQLPlanNode)p, (PlanNodeRenderInfo)((Object)((Object)((Object)o))), true));
                    }
                });
            }
            ++n2;
        }
        this.layoutDiagram();
    }

    private void rotateLayout() {
        this.layoutConfig = this.layoutConfig == PlanLayouts.PLAN_HORIZONTAL ? PlanLayouts.PLAN_VERTICAL : PlanLayouts.PLAN_HORIZONTAL;
        this.layoutDiagram();
    }

    private void layoutDiagram() {
        DiagramLayoutEngine.Parameters params = new DiagramLayoutEngine.Parameters();
        params.setOverrideDiagramConfig(true);
        params.getGlobalSettings().setProperty(CoreOptions.ANIMATE, (Object)false).setProperty(CoreOptions.PROGRESS_BAR, (Object)false).setProperty(CoreOptions.LAYOUT_ANCESTORS, (Object)false).setProperty(CoreOptions.ZOOM_TO_FIT, (Object)false);
        params.addLayoutRun(this.layoutConfig);
        ArrayList<PictogramElement> diagramElements = new ArrayList<PictogramElement>(this.sqlPlan.getAllNodes().size());
        for (SQLPlanNode node : this.sqlPlan.getAllNodes()) {
            PictogramElement pe;
            if (!(node.getContainer() instanceof PictogramElement) || !(pe = (PictogramElement)node.getContainer()).isVisible()) continue;
            diagramElements.add(pe);
        }
        if (diagramElements.size() > 1) {
            try {
                DiagramLayoutEngine.invokeLayout((IWorkbenchPart)this.planEditor, diagramElements, (DiagramLayoutEngine.Parameters)params);
                this.diagramComposite.selectPictogramElements(new PictogramElement[]{(PictogramElement)diagramElements.get(0)});
            }
            catch (Exception e) {
                log.error((Object)"Error during plan diagram layout", (Throwable)e);
            }
        }
    }

    public static void executeInRecordingCommand(IDiagramBehavior diagramBehavior, final Runnable run) {
        TransactionalEditingDomain editingDomain = diagramBehavior.getEditingDomain();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                run.run();
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object returnObj = null;
        if (this.diagramComposite != null && !this.diagramComposite.isDisposed()) {
            returnObj = this.diagramComposite.getAdapter(adapter);
        }
        if (returnObj != null) {
            return (T)returnObj;
        }
        return null;
    }

    void fillActions(IContributionManager contributionManager, SQLQuery query, DBCPlan plan) {
        if (this.planEditor == null) {
            return;
        }
        contributionManager.add((IAction)new Action("Refresh layout", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_LAYOUT)){

            public void run() {
                SQLPlanViewerGraphiti.this.layoutDiagram();
            }
        });
        contributionManager.add((IAction)new Action("Toggle layout", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROTATE)){

            public void run() {
                SQLPlanViewerGraphiti.this.rotateLayout();
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action("Expand secondary nodes", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.TREE_EXPAND_ALL)){

            public void run() {
                SQLPlanViewerGraphiti.this.expandDiagram();
            }
        });
        contributionManager.add((IAction)new Action("Collapse secondary nodes", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.TREE_COLLAPSE_ALL)){

            public void run() {
                SQLPlanViewerGraphiti.this.collapseDiagram();
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        ZoomManager zoomManager = (ZoomManager)this.planEditor.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (zoomManager != null) {
            ArrayList<String> zoomLevels = new ArrayList<String>(3);
            zoomLevels.add(ZoomManager.FIT_ALL);
            zoomLevels.add(ZoomManager.FIT_WIDTH);
            zoomLevels.add(ZoomManager.FIT_HEIGHT);
            zoomManager.setZoomLevelContributions(zoomLevels);
            zoomManager.setZoomLevels(new double[]{0.1, 0.1, 0.2, 0.3, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.5, 3.0, 4.0});
            ZoomInAction zoomInAction = new ZoomInAction(zoomManager);
            zoomInAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_IN));
            ZoomOutAction zoomOutAction = new ZoomOutAction(zoomManager);
            zoomOutAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_OUT));
            contributionManager.add((IAction)zoomInAction);
            contributionManager.add((IAction)zoomOutAction);
            contributionManager.add((IAction)new ZoomResetAction(zoomManager));
        }
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new SaveImageAction((IDiagramBehavior)this.diagramComposite.getDiagramBehavior(), this.diagramComposite.getDiagramBehavior().getConfigurationProvider()), (DBPImage)DBIcon.TYPE_IMAGE));
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action("Show all details", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_ALL_DETAILS)){

            public void run() {
                SQLPlanViewerGraphiti.this.detailDiagram();
            }
        });
        contributionManager.add((IAction)new Action("Show significant nodes details", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_MAIN_DETAILS)){

            public void run() {
                SQLPlanViewerGraphiti.this.detailHotDiagram();
            }
        });
        contributionManager.add((IAction)new Action("Hide all details", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.HIDE_ALL_DETAILS)){

            public void run() {
                SQLPlanViewerGraphiti.this.shortenDiagram();
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action("Show Grid", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.RS_GRID)){

            public int getStyle() {
                return 2;
            }

            public void run() {
                SQLPlanViewerGraphiti.this.gridVisible = !SQLPlanViewerGraphiti.this.gridVisible;
                this.setText(SQLPlanViewerGraphiti.this.gridVisible ? "Hide grid" : "Show Grid");
                SQLPlanViewerGraphiti.this.planGrid(SQLPlanViewerGraphiti.this.gridVisible);
                this.setChecked(SQLPlanViewerGraphiti.this.gridVisible);
            }
        });
    }

    public Object getContainerComposite() {
        return this.diagramComposite;
    }

    public Object getHostPart() {
        return this.planEditor;
    }

    public Object getLayoutConfiguration() {
        return this.layoutConfig;
    }
}

