/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatashare;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class RedshiftDatashareConsumer
implements DBSObject {
    private final RedshiftDatashare datashare;
    private final String consumerAccount;
    private final String consumerNamespace;
    private final Date shareDate;

    public RedshiftDatashareConsumer(RedshiftDatashare datashare, JDBCResultSet resultSet) {
        this.datashare = datashare;
        this.consumerAccount = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"consumer_account");
        this.consumerNamespace = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"consumer_namespace");
        this.shareDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"share_date");
    }

    @Nullable
    public RedshiftDatashare getParentObject() {
        return this.datashare;
    }

    @NotNull
    public RedshiftDataSource getDataSource() {
        return this.datashare.getDataSource();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.getConsumerNamespace();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getConsumerAccount() {
        return this.consumerAccount;
    }

    @Property(viewable=true, order=2)
    public String getConsumerNamespace() {
        return this.consumerNamespace;
    }

    @Property(viewable=true, order=3)
    public Date getShareDate() {
        return this.shareDate;
    }
}

