/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.ClassAnalizer;
import com.intersys.gateway.JavaGateway;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.jalapeno.tools.objects.DefaultMappingProvider;
import com.jalapeno.tools.objects.DefaultMappingTool;
import com.jalapeno.tools.objects.MappingToolInterface;
import com.jalapeno.tools.objects.PersistentPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JavaCacheClassMapper {
    protected MappingToolInterface mMappingTool;
    protected Set mDependencies = new HashSet();
    protected Class mInitialClass;
    protected boolean mIgnoreExcludedProperties = true;
    protected String mInferredId = null;

    public JavaCacheClassMapper() {
        this.mMappingTool = new DefaultMappingTool(this.mDependencies);
    }

    public void setORMTool(MappingToolInterface mappingToolInterface) {
        this.mMappingTool = mappingToolInterface;
        this.mMappingTool.setDependecies(this.mDependencies);
    }

    public void setDefaultReplacement(char c, String string) {
        this.mMappingTool.setDefaultReplacement(c, string);
    }

    public void setDefaultAccessLevel(int n) {
        int n2;
        if (Modifier.isPrivate(n)) {
            n2 = 2;
        } else if (Modifier.isProtected(n)) {
            n2 = 4;
        } else if (Modifier.isPublic(n)) {
            n2 = 1;
        } else {
            throw new IllegalArgumentException("Invalid value for access level:" + n);
        }
        this.mMappingTool.setDefaultAccessLevel(n2);
    }

    public void addExclusions(Collection collection) {
        this.mMappingTool.addExclusions(collection);
    }

    public void ignoreNestedGenerics() {
        this.mMappingTool.setIgnoreNestedGenerics(true);
    }

    public void mapClass(Class clazz) throws Exception {
        int n = this.mMappingTool.getAccessType(clazz);
        switch (n) {
            case 12001: {
                this.mapClassByFields(clazz);
                break;
            }
            case 12002: {
                this.mapInterface(clazz, true);
                break;
            }
            case 12006: {
                this.mapInterface(clazz, false);
                break;
            }
            case 12004: {
                throw new IllegalArgumentException("Setters Only are not implemented.");
            }
            default: {
                throw new IllegalArgumentException("Unknown access type: " + n);
            }
        }
    }

    private void mapClassByFields(Class clazz) throws Exception {
        Set set = ClassAnalizer.getPersistableFields(clazz, null, this.mMappingTool.getAccessLevel(clazz), false);
        this.mapInternal(clazz, set);
    }

    private void mapInterface(Class clazz, boolean bl) throws Exception {
        Set set = ClassAnalizer.getGetSetPairs(clazz, this.mMappingTool.getAccessLevel(clazz), bl);
        this.mapInternal(clazz, set);
    }

    public void mapBean(Class clazz) throws Exception {
        this.mapInterface(clazz, false);
    }

    private void mapInternal(Class clazz, Set set) throws Exception {
        this.mInitialClass = clazz;
        this.mInferredId = null;
        Package package_ = clazz.getPackage();
        String string = package_ == null ? null : package_.getName();
        String string2 = clazz.getName();
        if (string != null && string2.startsWith(string)) {
            string2 = string2.substring(string.length() + 1);
        }
        this.mapClass(set, clazz);
    }

    protected void mapClass(Set set, Class clazz) throws Exception {
        this.mapClassName(clazz);
        this.mapAllFields(set, new HashSet(), clazz);
        this.mapUnmappedFields(clazz);
    }

    public Set getDependencies(boolean bl) {
        return this.mDependencies;
    }

    public Set getJavaGatewayDependencies() {
        if (this.mInitialClass != null) {
            Set set = ClassAnalizer.getMethodDependentTypes(this.mInitialClass, this.mMappingTool.getAccessLevel(this.mInitialClass));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (!JavaGateway.isPrimitiveOrWrapper(clazz) && !this.mMappingTool.testForExclusion(clazz.getName())) continue;
                iterator.remove();
            }
            set.addAll(this.mDependencies);
            return set;
        }
        return this.mDependencies;
    }

    public Map getTypeMap() {
        HashMap hashMap = new HashMap();
        Map map = this.mMappingTool.getTypemap();
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    protected String mapClassName(Class clazz) throws Exception {
        String string = clazz.getName();
        String string2 = this.mMappingTool.cacheMappedClassNameFor(string);
        if (string2 != null) {
            return string;
        }
        string2 = this.mMappingTool.cacheClassNameFor(clazz);
        if (this.mInitialClass == null) {
            this.mInitialClass = clazz;
        }
        this.mMappingTool.classMapped(string, string2, true);
        return string;
    }

    protected void mapField(PropertyDescriptor propertyDescriptor, Set set, Set set2) throws Exception {
        boolean bl = this.mMappingTool.isMemberTransient(propertyDescriptor);
        if (bl) {
            return;
        }
        Class clazz = DefaultMappingProvider.typeOfField(propertyDescriptor);
        String string = this.mMappingTool.cacheFieldTypeFor(propertyDescriptor);
        if (string == null) {
            if (this.mIgnoreExcludedProperties) {
                return;
            }
            string = "%Library.RegisteredObject";
        }
        String string2 = clazz.getName();
        if (!(Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || clazz.isArray())) {
            this.mMappingTool.classMapped(string2, string, false);
        }
        this.generateField(propertyDescriptor, set, set2, clazz, string, string2);
    }

    protected void generateField(Object object, Set set, Set set2, Class clazz, String string, String string2) throws Exception {
    }

    protected void mapUnmappedFields(Class clazz) throws Exception {
        this.mMappingTool.listUnmappedFields(clazz);
    }

    protected void enableVersionChecking(PropertyDescriptor propertyDescriptor, Set set, Set set2) throws Exception {
    }

    protected boolean mapAllFields(Set set, Set set2, Class clazz) throws Exception {
        Object object;
        String string;
        PropertyDescriptor propertyDescriptor2;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>(set.size());
        String string2 = this.mMappingTool.getVersionID(clazz);
        boolean bl2 = false;
        String string3 = this.mMappingTool.getDatabaseID(clazz);
        if (string3 == null) {
            string3 = this.tryInferId(clazz, set);
        }
        if (this.handleIdField(clazz, string3)) {
            string3 = null;
        }
        for (PropertyDescriptor propertyDescriptor2 : set) {
            string = propertyDescriptor2.getName();
            if (string.equals(string2)) {
                this.enableVersionChecking(propertyDescriptor2, hashSet, set2);
                bl2 = true;
                continue;
            }
            if (string.equals(string3)) continue;
            hashSet.add(string);
        }
        if (string2 != null && !bl2) {
            object = clazz.getDeclaredField(string2);
            propertyDescriptor2 = new PersistentPropertyDescriptor(clazz, (Field)object);
            hashSet.add(string2);
            this.enableVersionChecking(propertyDescriptor2, hashSet, set2);
        }
        object = set.iterator();
        while (object.hasNext()) {
            bl = true;
            propertyDescriptor2 = (PropertyDescriptor)object.next();
            string = propertyDescriptor2.getName();
            if (string.equals(string2) || string.equals(string3)) continue;
            this.mapField(propertyDescriptor2, hashSet, set2);
        }
        return bl;
    }

    private boolean handleIdField(Class clazz, String string) throws Exception {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        int n = string.equals(this.mInferredId) ? 0 : this.mMappingTool.getDatabaseIDType(clazz);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ID type: " + n + " for class " + clazz.getName());
            }
        }
        this.handleIdField(clazz, string, n);
        return bl;
    }

    protected void handleIdField(Class clazz, String string, int n) throws Exception {
    }

    private String tryInferId(Class clazz, Set set) throws Exception {
        Object object;
        String string = null;
        for (Object e : set) {
            object = this.mMappingTool.cacheFieldNameFor(e, null);
            if (!"%ID".equals(object)) {
                object = this.mMappingTool.sqlColumnNameFor(e);
            }
            if (!"%ID".equals(object)) continue;
            string = ((PropertyDescriptor)e).getName();
            break;
        }
        if (string == null) {
            return null;
        }
        CacheIndexInfo[] cacheIndexInfoArray = this.mMappingTool.allIndicesFor(clazz);
        if (cacheIndexInfoArray != null) {
            for (int i = 0; i < cacheIndexInfoArray.length; ++i) {
                object = cacheIndexInfoArray[i];
                if (!object.isPrimaryKey() || !string.equals(object.getProperties())) continue;
                this.mInferredId = string;
                break;
            }
        }
        return this.mInferredId;
    }

    public void close() {
        this.mDependencies.clear();
        this.mInitialClass = null;
        this.mInferredId = null;
    }
}

