/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.jalapeno.annotations.AccessType;
import com.jalapeno.annotations.CollectionType;
import com.jalapeno.tools.objects.ClassMetadata;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.PropertyMetadata;
import com.jalapeno.tools.objects.RelationshipMetadata;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HibernateHandler
extends DefaultHandler {
    private static final int PCDATA_PROP_PARAM = 2001;
    private static final int COLLECTION_NONE = 0;
    private static final int COLLECTION_MAP = 1;
    private static final int COLLECTION_LIST = 2;
    private int isCollection;
    private AccessType accessType;
    private SAXParser saxParser;
    private HashMap<Class, ClassMetadata> classMetadata;
    private String className;
    private Class currentClass;
    private ClassMetadata classInfo;
    private Class currentEmbeddedClass = null;
    private Class currentSubClass = null;
    private ClassMetadata embeddedClassInfo = null;
    private ClassMetadata subClassInfo = null;
    private HibernatePropertyMetadata propertyInfo;
    private String propertyName;
    private String packageName = null;
    private int pcdataMode = 0;
    private String currentEmbeddedProperty;
    private boolean processingId = false;
    private boolean idGeneratorDefined;
    private HashMap<String, ArrayList<String>> indices;
    private ArrayList<HashMap<String, ArrayList<String>>> savedIndices;
    private Java2DBMapping nameHelper;

    public HibernateHandler(Class clazz, Java2DBMapping java2DBMapping) {
        this();
        this.currentClass = clazz;
        this.nameHelper = java2DBMapping;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        super.error(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("FATAL ERROR parsing XML Descriptor: " + sAXParseException.toString());
        super.fatalError(sAXParseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HibernateHandler() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            this.saxParser = sAXParserFactory.newSAXParser();
            this.saxParser.getXMLReader().setFeature("http://xml.org/sax/features/validation", Boolean.FALSE);
            this.saxParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            this.classMetadata = new HashMap();
            this.indices = new HashMap();
            this.isCollection = 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.accessType = AccessType.PROPERTY;
    }

    public HashMap<Class, ClassMetadata> parse(File file) throws Throwable {
        this.saxParser.parse(file, (DefaultHandler)this);
        return this.classMetadata;
    }

    public HashMap<Class, ClassMetadata> parse(String string) throws Throwable {
        this.saxParser.parse(string, (DefaultHandler)this);
        return this.classMetadata;
    }

    public HashMap<Class, ClassMetadata> parse(InputStream inputStream) throws Throwable {
        this.saxParser.parse(inputStream, (DefaultHandler)this);
        return this.classMetadata;
    }

    private void getClassInfo(Attributes attributes) throws ClassNotFoundException {
        this.classInfo = new ClassMetadata();
        this.classInfo.setAccessType(this.accessType);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                if (this.packageName != null) {
                    string2 = this.packageName + "." + string2;
                }
                this.currentClass = this.classForName(string2);
                this.classInfo.setClassName(string2);
                continue;
            }
            if (string.equals("table")) {
                this.classInfo.setSQLTableName(string2);
                continue;
            }
            if (!string.equals("proxy") && !string.equals("batch-size") && !string.equals("mutable") && !string.equals("dynamic-update") && !string.equals("polymorphism") && !string.equals("optimistic-lock") && !string.equals("dynamic-insert") && !string.equals("select-before-update") && !string.equals("discriminator-value") && !string.equals("select-before-update")) continue;
        }
    }

    private void getEmbeddedClassInfo(Attributes attributes) throws ClassNotFoundException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.currentEmbeddedProperty = this.propertyName = string2;
                continue;
            }
            if (string.equals("class")) {
                String string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
                if (this.packageName != null) {
                    string3 = this.packageName + "." + string3;
                }
                this.currentEmbeddedClass = this.classForName(string3);
                if (this.classMetadata.get(this.currentEmbeddedClass) != null) continue;
                this.embeddedClassInfo = new ClassMetadata();
                this.embeddedClassInfo.setClassName(string3);
                this.embeddedClassInfo.setIsSerial();
                continue;
            }
            if (!string.equals("update") && !string.equals("insert")) continue;
        }
    }

    private void getSubClassInfo(Attributes attributes) throws ClassNotFoundException {
        this.subClassInfo = new ClassMetadata();
        this.subClassInfo.setAccessType(this.accessType);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                String string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
                if (this.packageName != null) {
                    string3 = this.packageName + "." + string3;
                }
                this.currentSubClass = this.classForName(string3);
                this.subClassInfo.setClassName(string3);
                continue;
            }
            if (string.equals("table")) {
                this.subClassInfo.setSQLTableName(string2);
                continue;
            }
            if (!string.equals("update") && !string.equals("insert")) continue;
        }
    }

    private void getMappingInfo(Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("package")) {
                this.packageName = string2;
                continue;
            }
            if (string.equals("auto-import")) continue;
            if (string.equals("default-access")) {
                if (!"field".equals(string2)) continue;
                this.accessType = AccessType.FIELD;
                continue;
            }
            if (!string.equals("default-cascade")) continue;
        }
    }

    private void getPropertyInfo(Attributes attributes) throws SAXException {
        boolean bl = false;
        this.propertyInfo = new HibernatePropertyMetadata();
        for (int i = 0; i < attributes.getLength(); ++i) {
            ArrayList<String> arrayList;
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                this.propertyInfo.setName(this.propertyName);
                continue;
            }
            if (string.equals("column")) {
                if (!bl && this.currentEmbeddedClass == null) {
                    this.propertyInfo.setName(string2);
                }
                this.propertyInfo.setSQLColumnName(string2);
                continue;
            }
            if (string.equals("type")) {
                this.mapType(string2);
                continue;
            }
            if (string.equals("not-null")) {
                this.propertyInfo.setIsRequired();
                continue;
            }
            if (string.equals("insert")) continue;
            if (string.equals("access")) {
                if ("field".equals(string2)) {
                    this.propertyInfo.propertyAcessType = AccessType.FIELD;
                    continue;
                }
                if (!"property".equals(string2)) continue;
                this.propertyInfo.propertyAcessType = AccessType.PROPERTY;
                continue;
            }
            if (string.equals("update")) continue;
            if (string.equals("index")) {
                arrayList = this.indices.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.indices.put(string2, arrayList);
                }
                if (this.currentEmbeddedClass == null) {
                    arrayList.add(this.propertyName);
                    continue;
                }
                arrayList.add(this.currentEmbeddedProperty + "." + this.propertyName);
                continue;
            }
            if (!string.equals("unique") || !string2.equals("true")) continue;
            arrayList = this.propertyName + "Idx";
            String[] stringArray = new String[]{this.propertyName};
            this.classInfo.setIndex(null, null, false, (String)((Object)arrayList), false, stringArray, null, null, true, null);
        }
    }

    private void getIDInfo(Attributes attributes) throws Exception {
        this.propertyName = null;
        AccessType accessType = this.accessType;
        boolean bl = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                continue;
            }
            if (string.equals("column")) {
                if (!string2.equalsIgnoreCase("%ID")) continue;
                bl = true;
                continue;
            }
            if (!string.equals("access")) continue;
            if ("field".equals(string2)) {
                this.accessType = AccessType.FIELD;
                continue;
            }
            if (!"property".equals(string2)) continue;
            this.accessType = AccessType.PROPERTY;
        }
        if (this.propertyName != null) {
            if (bl) {
                this.propertyInfo = new HibernatePropertyMetadata();
                this.propertyInfo.setName(this.propertyName);
            } else {
                this.getPropertyInfo(attributes);
            }
            this.addPropertyMetadata();
            this.classInfo.setDatabaseID(this.propertyName);
        }
        this.accessType = accessType;
        this.processingId = true;
        this.idGeneratorDefined = false;
    }

    private void getVersionInfo(Attributes attributes) throws Exception {
        this.propertyName = null;
        AccessType accessType = this.accessType;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                continue;
            }
            if (!string.equals("access")) continue;
            if ("field".equals(string2)) {
                this.accessType = AccessType.FIELD;
                continue;
            }
            if (!"property".equals(string2)) continue;
            this.accessType = AccessType.PROPERTY;
        }
        if (this.propertyName != null) {
            this.getPropertyInfo(attributes);
            this.addPropertyMetadata();
            this.classInfo.setVersionID(this.propertyName);
        }
        this.accessType = accessType;
    }

    private void getIdGeneratorInfo(Attributes attributes) {
        if (!this.processingId) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (!string.equals("class")) continue;
            if (string2.equals("native") || string2.equals("identity")) {
                this.classInfo.setDatabaseIDType(0);
                continue;
            }
            if (!string2.equals("assigned")) continue;
            this.classInfo.setDatabaseIDType(1);
        }
        this.idGeneratorDefined = true;
    }

    private void getBagInfo(Attributes attributes) throws SAXException {
        this.propertyInfo = new HibernatePropertyMetadata();
        this.propertyInfo.setCollectionType(CollectionType.ARRAY);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                this.propertyInfo.setName(this.propertyName);
                continue;
            }
            if (!string.equals("lazy") && !string.equals("inverse") && !string.equals("batch-size") && !string.equals("cascade") && !string.equals("outer-join")) continue;
        }
    }

    private void getCollectionInfo(Attributes attributes) {
        this.propertyInfo = new HibernatePropertyMetadata();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                this.propertyInfo.setName(this.propertyName);
                continue;
            }
            if (string.equals("lazy")) continue;
            if (string.equals("inverse")) {
                if (!string2.equals("false")) continue;
                this.propertyInfo.setCollectionType(CollectionType.LIST);
                continue;
            }
            if (!string.equals("batch-size") && !string.equals("cascade") && !string.equals("outer-join")) continue;
        }
    }

    private void getCollectionElementInfo(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("column")) continue;
            if (string.equals("type")) {
                this.mapType(string2);
                continue;
            }
            if (!string.equals("length") && !string.equals("not-null") && !string.equals("unique")) continue;
        }
    }

    private void getRelationshipInfo(Attributes attributes, boolean bl) throws SAXException {
        String string = null;
        String string2 = null;
        if (this.isCollection == 0) {
            this.propertyInfo = new HibernatePropertyMetadata();
        }
        try {
            Object object;
            for (int i = 0; i < attributes.getLength(); ++i) {
                string = attributes.getLocalName(i);
                String string3 = attributes.getValue(i);
                if (string.equals("name")) {
                    this.propertyName = string3;
                    this.propertyInfo.setName(this.propertyName);
                    continue;
                }
                if (string.equals("unique") || string.equals("not-null") || string.equals("outer-join") || string.equals("insert") || string.equals("update") || !string.equals("class")) continue;
                string2 = string3;
                this.propertyInfo.setType(string3);
            }
            if (string2 == null) {
                object = this.getPropertyKey(this.propertyName);
                Class<?> clazz = object instanceof Field ? ((Field)object).getType() : ((Method)object).getReturnType();
                string2 = clazz.getName();
            } else {
                if (string2.indexOf(".") == -1) {
                    string2 = this.packageName + "." + string2;
                }
                Class clazz = this.classForName(string2);
            }
            object = "";
            if (((String)object).equals("")) {
                // empty if block
            }
            RelationshipMetadata relationshipMetadata = new RelationshipMetadata(bl, false, string2, (String)object, "");
            this.propertyInfo.setRelationship(relationshipMetadata);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    private void getMetaInfo(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (!string.equals("attribute")) continue;
            if (string2.equals("populatable")) {
                if (this.embeddedClassInfo != null) {
                    this.embeddedClassInfo.setPopulatable(true);
                    continue;
                }
                if (this.classInfo == null) continue;
                this.classInfo.setPopulatable(true);
                continue;
            }
            if (string2.equals("transient")) {
                if (this.propertyInfo == null) continue;
                this.propertyInfo.setIsTransient();
                continue;
            }
            if (!string2.equals("PropertyParameter")) continue;
            this.pcdataMode = 2001;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string2.equals("class")) {
                this.getClassInfo(attributes);
            } else if (string2.equals("property")) {
                this.getPropertyInfo(attributes);
            } else if (string2.equals("id")) {
                this.getIDInfo(attributes);
            } else if (string2.equals("version")) {
                this.getVersionInfo(attributes);
            } else if (string2.equals("generator")) {
                this.getIdGeneratorInfo(attributes);
            } else if (string2.equals("meta")) {
                this.getMetaInfo(attributes);
            } else if (string2.equals("bag") || string2.equals("map")) {
                this.isCollection = 1;
                this.getBagInfo(attributes);
            } else if (string2.equals("list")) {
                this.isCollection = 2;
                this.getCollectionInfo(attributes);
            } else if (string2.equals("element")) {
                this.getCollectionElementInfo(attributes);
            } else if (!string2.equals("key")) {
                if (string2.equals("one-to-many")) {
                    if (this.isCollection != 0) {
                        this.isCollection = 0;
                    }
                    this.getRelationshipInfo(attributes, true);
                } else if (string2.equals("many-to-one")) {
                    if (this.isCollection != 0) {
                        this.isCollection = 0;
                    }
                    this.getRelationshipInfo(attributes, false);
                } else if (string2.equals("component")) {
                    this.getEmbeddedClassInfo(attributes);
                    this.propertyInfo = new HibernatePropertyMetadata();
                    this.propertyInfo.setName(this.propertyName);
                    this.propertyInfo.setType(this.currentEmbeddedClass.getName());
                    if (this.subClassInfo != null && this.currentSubClass != null) {
                        this.subClassInfo.addPropertyMetadata(this.getSubPropertyKey(this.propertyName), this.propertyInfo);
                    } else {
                        this.classInfo.addPropertyMetadata(this.getPropertyKey(this.propertyName), this.propertyInfo);
                    }
                } else if (string2.equals("subclass") || string2.equals("union-subclass")) {
                    if (this.savedIndices == null) {
                        this.savedIndices = new ArrayList();
                    }
                    this.savedIndices.add(0, this.indices);
                    this.indices = new HashMap();
                    this.getSubClassInfo(attributes);
                } else if (string2.equals("hibernate-mapping")) {
                    this.getMappingInfo(attributes);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    private void dumpAttributes(String string, Attributes attributes) {
        System.out.println(string);
        for (int i = 0; i < attributes.getLength(); ++i) {
            System.out.println(attributes.getLocalName(i) + "  " + attributes.getValue(i));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.pcdataMode == 0) {
            return;
        }
        String string = String.valueOf(cArray, n, n2).trim();
        if (string.length() == 0) {
            return;
        }
        switch (this.pcdataMode) {
            case 2001: {
                this.handlePropertyParameters(string);
            }
        }
    }

    private void handlePropertyParameters(String string) throws SAXException {
        int n = string.indexOf(61);
        if (n < 0) {
            throw new SAXException("Invalid syntax for Property Parameter: " + string + " Must be in the form: Name = Value");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        HashMap<String, String> hashMap = this.propertyInfo.getPropertyParameters();
        if (hashMap == null) {
            hashMap = new HashMap(1);
            this.propertyInfo.setPropertyParameters(hashMap);
        }
        hashMap.put(string2, string3);
    }

    private void mapType(String string) {
        String string2;
        if (string.equals("string")) {
            string2 = "%String";
        } else if (string.equals("integer") || string.equals("long") || string.equals("short")) {
            string2 = "%Integer";
        } else if (string.equals("boolean") || string.equals("yes_no") || string.equals("true_false")) {
            string2 = "%Boolean";
        } else if (string.equals("date")) {
            string2 = "%Date";
        } else if (string.equals("time")) {
            string2 = "%Time";
        } else if (string.equals("timestamp")) {
            string2 = "%TimeStamp";
        } else if (string.equals("double") || string.equals("float")) {
            string2 = "%Float";
        } else if (string.equals("clob") || string.equals("text")) {
            string2 = "%GlobalCharacterStream";
            this.propertyInfo.setKind(64);
        } else if (string.equals("blob") || string.equals("binary")) {
            string2 = "%GlobalBinaryStream";
            this.propertyInfo.setKind(32);
        } else {
            string2 = string;
        }
        this.propertyInfo.setType(string2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string2.equals("class")) {
                this.processIndices();
                this.classMetadata.put(this.currentClass, this.classInfo);
            } else if (string2.equals("meta")) {
                this.pcdataMode = 0;
            } else if (string2.equals("property")) {
                if (this.propertyInfo != null) {
                    this.addPropertyMetadata();
                }
            } else if (string2.equals("one-to-many") || string2.equals("many-to-one")) {
                this.propertyInfo.setName(this.propertyName);
                this.addPropertyMetadata();
            } else if (string2.equals("bag") || string2.equals("map")) {
                if (this.isCollection == 1) {
                    this.addPropertyMetadata();
                }
            } else if (string2.equals("list")) {
                this.addPropertyMetadata();
            } else if (string2.equals("component")) {
                if (this.embeddedClassInfo != null) {
                    this.classMetadata.put(this.currentEmbeddedClass, this.embeddedClassInfo);
                }
                this.currentEmbeddedClass = null;
                this.embeddedClassInfo = null;
                this.currentEmbeddedProperty = null;
            } else if (string2.equals("subclass") || string2.equals("union-subclass")) {
                this.processIndices();
                this.classMetadata.put(this.currentSubClass, this.subClassInfo);
                this.currentSubClass = null;
                this.subClassInfo = null;
                this.indices = this.savedIndices.remove(0);
            } else if (string2.equals("id")) {
                this.processingId = false;
                if (!this.idGeneratorDefined) {
                    this.classInfo.setDatabaseIDType(1);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    private void processIndices() {
        ClassMetadata classMetadata = this.subClassInfo == null ? this.classInfo : this.subClassInfo;
        for (Map.Entry<String, ArrayList<String>> entry : this.indices.entrySet()) {
            String string = entry.getKey();
            ArrayList<String> arrayList = entry.getValue();
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            classMetadata.setIndex(null, null, false, string, false, stringArray, null, null, false, null);
        }
    }

    private void addPropertyMetadata() throws Exception {
        if (this.currentEmbeddedClass != null) {
            if (this.embeddedClassInfo != null) {
                this.embeddedClassInfo.addPropertyMetadata(this.getEmbeddedPropertyKey(this.propertyName), this.propertyInfo);
                this.checkAccessForEmbeddedClass();
            }
        } else if (this.subClassInfo != null && this.currentSubClass != null) {
            this.subClassInfo.addPropertyMetadata(this.getSubPropertyKey(this.propertyName), this.propertyInfo);
        } else {
            this.classInfo.addPropertyMetadata(this.getPropertyKey(this.propertyName), this.propertyInfo);
        }
    }

    private void checkAccessForEmbeddedClass() throws SAXException {
        boolean bl = true;
        AccessType accessType = this.accessType;
        for (PropertyMetadata propertyMetadata : this.embeddedClassInfo.getAllProperties()) {
            AccessType accessType2 = ((HibernatePropertyMetadata)propertyMetadata).propertyAcessType;
            if (bl) {
                accessType = accessType2;
                continue;
            }
            if (accessType == accessType2) continue;
            throw new SAXException("Class " + this.embeddedClassInfo.getClassName() + "Mixed access is not allowed.");
        }
        this.embeddedClassInfo.setAccessType(accessType);
    }

    private Class classForName(String string) throws ClassNotFoundException {
        return Class.forName(string, true, this.currentClass.getClassLoader());
    }

    private Member getPropertyKey(String string) throws Exception {
        return HibernateHandler.getPropertyKey(this.currentClass, string, this.propertyInfo.propertyAcessType);
    }

    private Member getEmbeddedPropertyKey(String string) throws Exception {
        return HibernateHandler.getPropertyKey(this.currentEmbeddedClass, string, this.propertyInfo.propertyAcessType);
    }

    private Member getSubPropertyKey(String string) throws Exception {
        return HibernateHandler.getPropertyKey(this.currentSubClass, string, this.propertyInfo.propertyAcessType);
    }

    private static Member getPropertyKey(Class clazz, String string, AccessType accessType) throws Exception {
        switch (accessType) {
            case PROPERTY: {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    String string2 = propertyDescriptorArray[i].getName();
                    if (string.equals(string2)) {
                        return propertyDescriptorArray[i].getReadMethod();
                    }
                    if (!string.equals(string2 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1))) continue;
                    return propertyDescriptorArray[i].getReadMethod();
                }
                throw new IllegalStateException("No property " + string + " in class " + clazz.getName());
            }
            case FIELD: {
                return clazz.getDeclaredField(string);
            }
        }
        throw new IllegalStateException("No access type for current mapping.");
    }

    public static void main(String[] stringArray) throws Throwable {
        HibernateHandler hibernateHandler = new HibernateHandler();
        hibernateHandler.parse(stringArray[0]);
    }

    private class HibernatePropertyMetadata
    extends PropertyMetadata {
        protected AccessType propertyAcessType;

        public HibernatePropertyMetadata() {
            this.propertyAcessType = HibernateHandler.this.accessType;
        }
    }
}

