/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools;

import com.intersys.objects.CacheException;
import com.jalapeno.tools.objects.Configurator;
import com.jalapeno.tools.objects.Persister;
import com.jalapeno.tools.objects.SchemaBuilderConfigurator;
import com.jalapeno.tools.objects.common.Messages;
import com.jalapeno.tools.objects.common.PersisterProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class SchemaBuilder {
    private Connection mCon;
    PersisterProperties mPersisterProperties;
    private String mOrmProvider;
    private static final String GENERATING_JAVA_PROJECTION_WITH_GENERATION_TYPE = Messages.getString("SchemaBuilder.GENERATION");
    private static final String IN_DIR = Messages.getString("SchemaBuilder.IN_DIR");
    private static final String WORD_SEP = " ";
    private static final String FILE_DOES_NOT_EXIST_WHERE_FILE_NAME_IS = Messages.getString("SchemaBuilder.FILE_DOES_NOT_EXIST_WHERE_FILE_NAME_IS");
    public static final String CONFIG_FILE_NAME = Messages.getString("SchemaBuilderWizard.RUN_PERSISTER_WIZARD_PROPERTIES");

    public PersisterProperties getPersisterProperties() {
        return this.mPersisterProperties;
    }

    public static SchemaBuilder getRunPersister(Properties properties) {
        return new SchemaBuilder(properties);
    }

    public SchemaBuilder(Properties properties) {
        this.mPersisterProperties = new PersisterProperties(properties);
    }

    public SchemaBuilder(Properties properties, String string) {
        this.mPersisterProperties = new PersisterProperties(properties, string);
    }

    public static SchemaBuilder getRunPersister(Properties properties, String string) {
        properties.setProperty("password", string);
        SchemaBuilder schemaBuilder = new SchemaBuilder(properties);
        schemaBuilder.getPersisterProperties().setRunTimeSwitches(properties);
        return schemaBuilder;
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        Properties properties = null;
        try {
            AutoCloseable autoCloseable;
            int n;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-f")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-fd")) {
                    string = CONFIG_FILE_NAME;
                    continue;
                }
                throw new IllegalArgumentException("Unknown option: " + stringArray[i]);
            }
            if (string != null) {
                File file = null;
                n = 1;
                autoCloseable = null;
                try {
                    file = new File(string);
                    autoCloseable = new FileInputStream(file);
                }
                catch (IOException iOException) {
                    n = 0;
                    System.out.println(FILE_DOES_NOT_EXIST_WHERE_FILE_NAME_IS + string);
                    iOException.printStackTrace();
                    throw new Exception(FILE_DOES_NOT_EXIST_WHERE_FILE_NAME_IS + string);
                }
                if (n != 0) {
                    try {
                        bl = true;
                        properties = new Properties();
                        properties.load((InputStream)autoCloseable);
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                }
            }
            SchemaBuilder schemaBuilder = null;
            if (bl) {
                schemaBuilder = new SchemaBuilder(properties);
                schemaBuilder.getPersisterProperties().setRunTimeSwitches(properties);
            } else {
                schemaBuilder = new SchemaBuilder(System.getProperties());
                schemaBuilder.getPersisterProperties().setRunTimeSwitches(System.getProperties());
            }
            n = schemaBuilder.mPersisterProperties.getGenerationType();
            autoCloseable = schemaBuilder.getDB();
            schemaBuilder.run((Connection)autoCloseable, null, new Integer(n).toString(), System.out);
            schemaBuilder.close();
        }
        catch (CacheException cacheException) {
            System.out.println(cacheException.getMessage());
            cacheException.printFullTrace(System.err);
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public Connection getDB() throws ClassNotFoundException, SQLException {
        if (this.mCon != null) {
            return this.mCon;
        }
        Class.forName("com.intersys.jdbc.CacheDriver");
        String string = "jdbc:Cache://" + this.mPersisterProperties.getHost() + ":" + this.mPersisterProperties.getPort() + "/" + this.mPersisterProperties.getNameSpace();
        String string2 = "";
        if (!this.mPersisterProperties.getLogFile().equals("")) {
            string2 = "/" + this.mPersisterProperties.getLogFile();
        }
        string = string + string2;
        this.mCon = DriverManager.getConnection(string, this.mPersisterProperties.getProperties());
        return this.mCon;
    }

    public void close() throws SQLException {
        if (this.mCon != null && !this.mCon.isClosed()) {
            this.mCon.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void run(String[] stringArray) throws ClassNotFoundException, SQLException, CacheException, IOException, Exception {
        this.run(this.getDB(), stringArray, "0", null);
    }

    public void run(Connection connection, Object[] objectArray, String string, PrintStream printStream) throws Exception {
        this.run(connection, objectArray, string, printStream, null, null);
    }

    public void run(Connection connection, Object[] objectArray, String string, PrintStream printStream, URL[] uRLArray, String[] stringArray) throws Exception {
        this.mOrmProvider = this.mPersisterProperties.getOrmProvider();
        String string2 = this.mPersisterProperties.getClassPath();
        SchemaBuilderConfigurator schemaBuilderConfigurator = null;
        schemaBuilderConfigurator = stringArray == null ? new SchemaBuilderConfigurator(this.mPersisterProperties.getInclude(), string2) : new SchemaBuilderConfigurator(uRLArray, stringArray);
        schemaBuilderConfigurator.setJavaSourceDir(this.mPersisterProperties.getProjectionDirectory());
        StringTokenizer stringTokenizer = new StringTokenizer(this.mPersisterProperties.getExclude(), "\t\n\r ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            schemaBuilderConfigurator.addExcludeString(string3);
        }
        int n = SchemaBuilderConfigurator.calcDefaultAccessLevel(this.mPersisterProperties.getDefaultAccessLevel());
        int n2 = SchemaBuilderConfigurator.calcDefaultAccessType(this.mPersisterProperties.getDefaultAccessType());
        schemaBuilderConfigurator.setDefaultAccessLevel(n);
        schemaBuilderConfigurator.setDefaultAccessType(n2);
        schemaBuilderConfigurator.setDollarReplacement(this.mPersisterProperties.getDollarReplacement());
        schemaBuilderConfigurator.setUnderscoreReplacement(this.mPersisterProperties.getUnderscoreReplacement());
        schemaBuilderConfigurator.setRebuildIndices(this.mPersisterProperties.rebuildIndices());
        schemaBuilderConfigurator.setMaxStringLength(this.mPersisterProperties.getMaxStringLength());
        schemaBuilderConfigurator.setMaxStringLengthInKey(this.mPersisterProperties.getMaxStringLengthInKey());
        Persister persister = new Persister((Configurator)schemaBuilderConfigurator, connection);
        if (this.mOrmProvider.equals("annotations")) {
            persister.useAnnotations();
        } else if (this.mOrmProvider.equals("hibernate")) {
            persister.useHibernateXMLDescriptors();
        } else if (this.mOrmProvider.equals("default")) {
            // empty if block
        }
        persister.setOutput(printStream);
        persister.setDoMerge(this.getPersisterProperties().getDoMerge());
        persister.persist();
        int n3 = this.getPersisterProperties().getGenerationType();
        if (n3 != 0) {
            printStream.println(GENERATING_JAVA_PROJECTION_WITH_GENERATION_TYPE + n3 + WORD_SEP + IN_DIR + WORD_SEP + schemaBuilderConfigurator.getJavaSourceDir());
            persister.generateStandardJavaProjections(new Integer(n3).toString());
        }
        persister.close();
    }
}

