/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.classes.CharacterStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheIOException;
import com.intersys.objects.IntegerHolder;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public class CacheReader
extends Reader
implements Serializable {
    private CharacterStream mStream;
    private long mMark;
    private long mCurPos;
    private static final int MAX_READ_LEN = 32000;

    public CacheReader(CharacterStream characterStream) {
        this.mStream = characterStream;
        this.mMark = -1L;
        this.mCurPos = 0L;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        String string = this.read(n2);
        if (string == null) {
            return -1;
        }
        n2 = string.length();
        if (n2 == 0) {
            return -1;
        }
        string.getChars(0, n2, cArray, n);
        return n2;
    }

    @Override
    public int read() throws IOException {
        String string = this.read(1);
        if (string != null && string.length() == 1) {
            return string.charAt(0);
        }
        return -1;
    }

    public void rewind() throws CacheException {
        this.mStream._rewind();
        this.mCurPos = 0L;
    }

    public synchronized long tell() {
        return this.mCurPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) throws IOException {
        this.mMark = this.mCurPos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.seek(this.mMark);
    }

    public synchronized void seek(long l) throws IOException {
        if (l > this.mCurPos) {
            this.skip(l - this.mCurPos);
        } else if (l < this.mCurPos) {
            try {
                this.rewind();
            }
            catch (CacheException cacheException) {
                throw new CacheIOException(cacheException);
            }
            this.skip(l);
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            int n = (int)(l > 32000L ? 32000L : l);
            int n2 = this.read(n).length();
            l2 += (long)n2;
            l -= (long)n2;
            if (n2 >= n) continue;
            break;
        }
        return l2;
    }

    public synchronized String read(int n) throws IOException {
        try {
            int n2 = this.getSize();
            if (n > n2) {
                n = n2;
            }
            if (n == 0) {
                return "";
            }
            IntegerHolder integerHolder = new IntegerHolder(new Integer(n));
            String string = this.mStream._read(integerHolder);
            n = integerHolder.value;
            if (n <= 0) {
                return null;
            }
            this.mCurPos += (long)n;
            if ((n != 1 || string.length() != 0) && n != string.length()) {
                throw new IOException("Inconsistent data reading  Cache Stream: " + n + "/" + string.length());
            }
            return string;
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    @Override
    public boolean ready() throws IOException {
        try {
            return this.getSize() > 0;
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.rewind();
        }
        catch (CacheException cacheException) {
            throw new IOException(cacheException.toString());
        }
    }

    private int getSize() throws CacheException {
        int n = this.mStream._sizeGet();
        return n - (int)this.mCurPos;
    }
}

