/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnectionPoolDataSource;
import com.intersys.jdbc.CachePooledConnection;
import com.intersys.jdbc.CacheXAConnection;
import com.intersys.jdbc.CacheXADataSource;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class ConnectionPoolManager
implements ConnectionEventListener {
    ConnectionPoolManager() {
    }

    synchronized PooledConnection lookup(CacheConnectionPoolDataSource cacheConnectionPoolDataSource, String string, String string2) throws SQLException {
        CachePooledConnection cachePooledConnection = null;
        for (int i = 0; i < cacheConnectionPoolDataSource.pool.size(); ++i) {
            cachePooledConnection = (CachePooledConnection)cacheConnectionPoolDataSource.pool.elementAt(i);
            if (!cachePooledConnection.checkConnectionParameters(cacheConnectionPoolDataSource.getURL(), string, string2) || cacheConnectionPoolDataSource instanceof CacheXADataSource && !(cachePooledConnection instanceof CacheXAConnection)) continue;
            cacheConnectionPoolDataSource.pool.remove(cachePooledConnection);
            ++cacheConnectionPoolDataSource.activeConnections;
            cachePooledConnection.addConnectionEventListener(this);
            return cachePooledConnection;
        }
        if (cacheConnectionPoolDataSource.getMaxPoolSize() <= cacheConnectionPoolDataSource.getPoolCount() + cacheConnectionPoolDataSource.activeConnections) {
            if (cacheConnectionPoolDataSource.getConnectionWaitTimeout() > 0) {
                try {
                    Thread.sleep(cacheConnectionPoolDataSource.getConnectionWaitTimeout() * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (cacheConnectionPoolDataSource.getMaxPoolSize() <= cacheConnectionPoolDataSource.getPoolCount() + cacheConnectionPoolDataSource.activeConnections) {
                throw new SQLException("Unable to get a connection: max pool size exceeded");
            }
        }
        if ((cachePooledConnection = cacheConnectionPoolDataSource instanceof CacheXADataSource ? new CacheXAConnection(cacheConnectionPoolDataSource, string, string2) : new CachePooledConnection(cacheConnectionPoolDataSource, string, string2)) == null) {
            throw new SQLException("Unable to create a new PooledConnection instance");
        }
        cachePooledConnection.addConnectionEventListener(this);
        ++cacheConnectionPoolDataSource.activeConnections;
        return cachePooledConnection;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        CachePooledConnection cachePooledConnection = (CachePooledConnection)connectionEvent.getSource();
        cachePooledConnection.returnToPool();
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

