/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class CacheResultSetMetaData
implements ResultSetMetaData {
    private CacheStatement statement;

    CacheResultSetMetaData(CacheStatement cacheStatement) throws SQLException {
        this.statement = cacheStatement;
    }

    @Override
    public synchronized int getColumnCount() throws SQLException {
        return this.statement.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.isAutoIncrement(n);
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.isCaseSensitive(n);
    }

    @Override
    public synchronized boolean isCurrency(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        if (this.statement.connection.protocolVersion > 40) {
            return this.statement.isCurrency(n);
        }
        return this.statement.getColumnType(n) == 2;
    }

    @Override
    public synchronized int isNullable(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnNullable(n);
    }

    @Override
    public synchronized boolean isSigned(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        switch (this.statement.getColumnType(n)) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int getColumnDisplaySize(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        switch (this.statement.getColumnType(n)) {
            case -5: {
                return 20;
            }
            case 93: {
                return 19;
            }
            case 6: 
            case 8: {
                return 22;
            }
            case 91: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 92: {
                return 8;
            }
            case 7: {
                return 13;
            }
            case 5: {
                return 6;
            }
            case -6: {
                return 4;
            }
            case -7: {
                return 5;
            }
            case 2: 
            case 3: {
                return this.statement.getColumnPrecision(n) + 2;
            }
        }
        return this.statement.getColumnPrecision(n);
    }

    @Override
    public synchronized String getColumnLabel(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnLabel(n);
    }

    @Override
    public synchronized String getColumnName(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnName(n);
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnSchemaName(n);
    }

    @Override
    public synchronized int getPrecision(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnPrecision(n);
    }

    @Override
    public synchronized int getScale(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnScale(n);
    }

    @Override
    public synchronized String getTableName(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnTableName(n);
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return "";
    }

    @Override
    public synchronized int getColumnType(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.getColumnType(n);
    }

    @Override
    public synchronized String getColumnTypeName(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        switch (this.statement.getColumnType(n)) {
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case -2: {
                return "BINARY";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN TYPE";
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return this.statement.isReadOnly(n);
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        switch (this.statement.getColumnType(n)) {
            case -4: 
            case -1: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return !this.statement.isReadOnly(n);
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        return !this.statement.isReadOnly(n);
    }

    @Override
    public synchronized String getColumnClassName(int n) throws SQLException {
        if (n <= 0 || n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        switch (this.statement.getColumnType(n)) {
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.String";
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new SQLException("Receiver not a wrapper");
    }
}

