/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.MachineInfo;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheDataSource;
import com.intersys.jdbc.CacheDatabaseMetaData;
import com.intersys.jdbc.CachePooledConnection;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheSavepoint;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.RegisteredDatabases;
import com.intersys.jdbc.SysList;
import com.intersys.jgss.GSSSocket;
import com.intersys.jsse.SSLSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class CacheConnection
implements Connection {
    private static final int PRE_PREPARSE_CACHE_MAX_SIZE = 50;
    public LogFileStream logFile = null;
    HashMap cachedPrepares = null;
    int nextServerCursorNumber = 0;
    int recycledServerCursorNumber = -1;
    InStream inMessage = null;
    OutStream outMessage = null;
    String serverVersion;
    int delimitedIds = 0;
    String url = null;
    String user = null;
    MessageCount messageCount;
    InputStream inputStream;
    OutputStream outputStream;
    int protocolVersion;
    int isolationLevel = 1;
    int supportedIsolationLevels;
    ConnectionInfo connectionInfo;
    CachePooledConnection pooled = null;
    HashMap prePreparseCache;
    private String cacheJobNumber = "-1";
    private Socket socket = null;
    private String password = null;
    private boolean closed = true;
    private boolean autoCommit = true;
    private boolean isReadOnly = false;
    private Vector statementPool;
    private Vector preparedStatementPool;
    private Vector callableStatementPool;
    private SQLWarning warnings = null;
    private int securityLevel;
    private String principalName;
    private String sSLConfigName;
    private String keyRecoveryPassword;
    private RegisteredDatabases registeredDatabases = null;
    private HashMap savepoints;
    private int savepointId = 0;
    private Properties clientInfo;
    static final int PROTOCOL_VERSION = 48;
    static final byte[] HANDSHAKE = new byte[]{72, 83};
    static final byte[] CONNECT = new byte[]{67, 78};
    static final byte[] DISCONNECT = new byte[]{68, 67};
    static final byte[] PREPARE = new byte[]{80, 80};
    static final byte[] DIRECT_UPDATE = new byte[]{68, 85};
    static final byte[] DIRECT_QUERY = new byte[]{68, 81};
    static final byte[] DIRECT_STORED_PROCEDURE = new byte[]{68, 83};
    static final byte[] PREPARED_UPDATE_EXECUTE = new byte[]{80, 85};
    static final byte[] PREPARED_QUERY_EXECUTE = new byte[]{80, 81};
    static final byte[] FETCH_DATA = new byte[]{70, 68};
    static final byte[] CLOSE_CURSOR = new byte[]{67, 67};
    static final byte[] PREPARE_STORED_PROCEDURE = new byte[]{83, 80};
    static final byte[] STORED_PROCEDURE_UPDATE_EXECUTE = new byte[]{83, 85};
    static final byte[] STORED_PROCEDURE_QUERY_EXECUTE = new byte[]{83, 81};
    static final byte[] STORED_PROCEDURE_FETCH_DATA = new byte[]{83, 70};
    static final byte[] EXECUTE_MULTIPLE_RESULT_SETS = new byte[]{77, 83};
    static final byte[] MULTIPLE_RESULT_SETS_FETCH_DATA = new byte[]{77, 68};
    static final byte[] GET_MORE_RESULTS = new byte[]{77, 82};
    static final byte[] GET_STREAM_SIZE = new byte[]{83, 83};
    static final byte[] RETRIEVE_STREAM = new byte[]{82, 83};
    static final byte[] OPEN_STREAM = new byte[]{79, 83};
    static final byte[] READ_STREAM = new byte[]{74, 83};
    static final byte[] STORE_BINARY_STREAM = new byte[]{83, 66};
    static final byte[] STORE_CHARACTER_STREAM = new byte[]{83, 77};
    static final byte[] STREAM_GET_BYTES = new byte[]{71, 66};
    static final byte[] STREAM_SET_BYTES = new byte[]{83, 90};
    static final byte[] STREAM_TRUNCATE = new byte[]{83, 88};
    static final byte[] STREAM_GET_POSITION = new byte[]{71, 80};
    static final byte[] CLOSE_STREAM = new byte[]{67, 83};
    static final byte[] GET_CACHE_RESULT_SET_OBJECT = new byte[]{70, 82};
    static final byte[] GET_STRUCT_OBJECT = new byte[]{70, 83};
    static final byte[] COMMIT = new byte[]{84, 67};
    static final byte[] ROLLBACK = new byte[]{84, 82};
    static final byte[] READ_COMMITTED = new byte[]{82, 67};
    static final byte[] READ_UNCOMMITTED = new byte[]{82, 85};
    static final byte[] AUTOCOMMIT_OFF = new byte[]{65, 70};
    static final byte[] AUTOCOMMIT_ON = new byte[]{65, 78};
    static final byte[] TOGGLE_SYNCHRONOUS_COMMIT = new byte[]{84, 83};
    static final byte[] GET_AUTO_GENERATED_KEYS = new byte[]{71, 71};
    static final byte[] IN_TRANSACTION = new byte[]{73, 84};
    static final byte[] JDBC_BESTROWID = new byte[]{66, 82};
    static final byte[] JDBC_CATALOGS = new byte[]{67, 65};
    static final byte[] JDBC_COLUMNPRIV = new byte[]{67, 80};
    static final byte[] JDBC_COLUMNS = new byte[]{67, 79};
    static final byte[] JDBC_CROSSREFERENCE = new byte[]{67, 82};
    static final byte[] JDBC_EXPORTEDKEYS = new byte[]{69, 75};
    static final byte[] JDBC_IMPORTEDKEYS = new byte[]{73, 75};
    static final byte[] JDBC_INDEXINFO = new byte[]{73, 73};
    static final byte[] JDBC_PRIMARYKEYS = new byte[]{80, 75};
    static final byte[] JDBC_PROCEDURECOL = new byte[]{80, 67};
    static final byte[] JDBC_PROCEDURES = new byte[]{80, 82};
    static final byte[] JDBC_SCHEMAS = new byte[]{83, 67};
    static final byte[] JDBC_TABLEPRIV = new byte[]{84, 80};
    static final byte[] JDBC_TABLES = new byte[]{84, 65};
    static final byte[] JDBC_TABLETYPES = new byte[]{84, 84};
    static final byte[] JDBC_TYPEINFO = new byte[]{84, 73};
    static final byte[] JDBC_VERSIONCOL = new byte[]{86, 67};
    static final byte[] JDBC_UDTS = new byte[]{85, 84};
    static final byte[] JDBC_SUPER_TYPES = new byte[]{83, 89};
    static final byte[] JDBC_SUPER_TABLES = new byte[]{83, 76};
    static final byte[] JDBC_GET_ATTRIBUTES = new byte[]{65, 84};
    static final byte[] JDBC_GET_FUNCTION_COLUMNS = new byte[]{70, 67};
    static final byte[] JDBC_GET_FUNCTIONS = new byte[]{70, 78};
    static final byte[] JDBC_CLIENT_INFO_PROPERTIES = new byte[]{67, 70};
    static final byte[] SET_CLIENT_INFO_PROPERTIES = new byte[]{67, 71};
    public static final byte[] XA_START = new byte[]{88, 83};
    public static final byte[] XA_END = new byte[]{88, 69};
    public static final byte[] XA_FORGET = new byte[]{88, 70};
    public static final byte[] XA_PREPARE = new byte[]{88, 80};
    public static final byte[] XA_COMMIT = new byte[]{88, 67};
    public static final byte[] XA_ROLLBACK = new byte[]{88, 82};
    public static final byte[] XA_RECOVER = new byte[]{88, 86};
    static final byte[] EXECUTE_STATIC_CURSOR = new byte[]{69, 88};
    static final byte[] DIRECT_STATIC_CURSOR = new byte[]{68, 88};
    static final byte[] FETCH_STATIC_CURSOR = new byte[]{70, 88};
    static final byte[] UPDATE_CACHE = new byte[]{85, 67};
    static final byte[] RESET_CONNECTION = new byte[]{82, 78};
    static final byte[] GET_SERVER_ERROR = new byte[]{79, 69};
    static final byte[] EXECUTE_STATEMENT_BATCH = new byte[]{69, 66};
    static final byte[] CLOSE_STATEMENT = new byte[]{67, 85};
    static final byte[] QUICK_LOAD = new byte[]{81, 76};
    static final byte[] QUICK_CHILD_TABLE_LOAD = new byte[]{81, 90};
    static final byte[] QUICK_CHILD_TABLE_CREATE = new byte[]{81, 88};
    static final byte[] QUICK_CHILD_TABLE_REMOVE = new byte[]{81, 75};
    static final byte[] QUICK_STORE = new byte[]{81, 83};
    static final byte[] QUICK_CREATE = new byte[]{81, 67};
    static final byte[] QUICK_REMOVE = new byte[]{81, 82};
    static final byte[] QUICK_FIND_ROWID_BY_PK = new byte[]{81, 49};
    static final byte[] QUICK_FIND_ROWID_BY_CONSTRAINT = new byte[]{81, 50};
    static final byte[] QUICK_FIND_PK_BY_CONSTRAINT = new byte[]{81, 51};
    static final byte[] QUICK_REMOVE_BY_PK = new byte[]{81, 52};
    static final byte[] QUICK_CREATE_BY_PK = new byte[]{81, 53};
    static final byte[] QUICK_STORE_BY_PK = new byte[]{81, 54};
    static final byte[] QUICK_LOAD_BY_PK = new byte[]{81, 55};
    static final byte[] QUICK_CHILD_TABLE_REMOVE_BY_PK = new byte[]{81, 56};
    static final byte[] QUICK_CHILD_TABLE_CREATE_BY_PK = new byte[]{81, 57};
    static final byte[] QUICK_CHILD_TABLE_LOAD_BY_PK = new byte[]{81, 65};
    static final byte[] QUICK_GET_CHILDREN_PKS = new byte[]{81, 66};
    static final byte[] QUICK_GET_CHILDREN_PKS_BY_PK = new byte[]{81, 68};
    static final byte[] QUICK_FIND_PK_BY_ROWID = new byte[]{81, 69};
    static final byte[] QUICK_BULK_LOAD = new byte[]{81, 77};
    static final byte[] QUICK_BULK_CREATE = new byte[]{81, 78};
    static final byte[] QUICK_BULK_STORE = new byte[]{81, 79};
    static final byte[] QUICK_BULK_SAVE_BY_PK = new byte[]{81, 87};
    static final byte[] QUICK_QUERY = new byte[]{81, 81};
    static final byte[] QUICK_JPA_FLUSH = new byte[]{81, 70};
    static final byte[] GET_CACHE_INFO = new byte[]{67, 73};
    static final byte[] PING = new byte[]{80, 71};
    static final byte[] PING_TWO = new byte[]{80, 50};
    static final byte[] COMPARE_TIMESTAMP = new byte[]{67, 86};
    static final byte[] SEND_TWO_FACTOR_TOKEN = new byte[]{50, 70};
    static final byte[] IS_TWO_FACTOR_ENABLED = new byte[]{50, 69};
    static final byte[] CONTINUOUS_QUERY_PREPARE = new byte[]{67, 49};
    static final byte[] CONTINUOUS_QUERY_EXECUTE = new byte[]{67, 50};
    static final byte[] CONTINUOUS_QUERY_GET_DELTA = new byte[]{67, 51};
    static final int MAX_CACHE_SIZE = 500;
    static final int ITEMS_TO_REMOVE = 100;
    static final int MAX_STATEMENT_POOL_SIZE = 40;
    static final int ALLOW_ERROR_0 = 0;
    static final int ALLOW_ERROR_100 = 100;
    static final int ALLOW_ERROR_403 = 403;
    static final int ALLOW_ERROR_404 = 404;
    static final int ALLOW_ERROR_417 = 417;
    static final int ALLOW_ERRORS_100_AND_404 = 504;

    CacheConnection(String string, String string2, int n, String string3, String string4, String string5, boolean bl, Properties properties, String string6, String string7) throws SQLException {
        this.init();
        this.url = string;
        String string8 = properties.getProperty("connection security level");
        if (string8 != null) {
            this.securityLevel = Integer.parseInt(string8);
            if (this.securityLevel > 0 && this.securityLevel < 4) {
                this.principalName = properties.getProperty("service principal name");
                if (this.principalName == null) {
                    throw new SQLException("No Service Principal Name: Connection Security Level is: " + this.securityLevel);
                }
            } else if (this.securityLevel == 10) {
                this.sSLConfigName = properties.getProperty("SSL configuration name");
                this.keyRecoveryPassword = properties.getProperty("key recovery password");
            }
        }
        this.user = string6 != null ? string6 : properties.getProperty("user");
        this.password = string7 != null ? string7 : properties.getProperty("password");
        if (string4 != null) {
            try {
                this.logFile = new LogFileStream(string4);
            }
            catch (IOException iOException) {
                this.logFile = null;
            }
        }
        if (!this.closed) {
            return;
        }
        this.isolationLevel = 1;
        this.connect(string2, n, string3, string5, DriverManager.getLoginTimeout(), bl, properties);
    }

    CacheConnection(CacheDataSource cacheDataSource, String string, String string2, CachePooledConnection cachePooledConnection) throws SQLException {
        this.init();
        this.securityLevel = cacheDataSource.getConnectionSecurityLevel();
        this.principalName = cacheDataSource.getServicePrincipalName();
        this.url = cacheDataSource.getURL();
        this.user = string;
        this.password = string2;
        this.pooled = cachePooledConnection;
        PrintWriter printWriter = cacheDataSource.getLogWriter();
        if (printWriter != null) {
            try {
                this.logFile = new LogFileStream(printWriter);
            }
            catch (IOException iOException) {
                this.logFile = null;
            }
        }
        this.isolationLevel = cacheDataSource.getDefaultTransactionIsolation();
        this.connect(cacheDataSource.getServerName(), cacheDataSource.getPortNumber(), cacheDataSource.getDatabaseName(), cacheDataSource.getEventClass(), cacheDataSource.getLoginTimeout(), cacheDataSource.getNodelay(), null);
    }

    public CacheConnection(Object object, Object object2, Object object3, String string, int n, int n2, Object object4) throws Exception {
        this.init();
        if (this.protocolVersion > n2) {
            this.protocolVersion = n2;
        }
        this.closed = false;
        this.isolationLevel = 1;
        this.socket = (Socket)object3;
        InetAddress inetAddress = this.socket.getLocalAddress();
        String string2 = inetAddress.getHostAddress();
        this.url = inetAddress instanceof Inet6Address ? "jdbc:Cache://[" + string2 + "]:" + n + "/" + string : "jdbc:Cache://" + string2 + ":" + n + "/" + string;
        this.logFile = (LogFileStream)object4;
        this.user = "_SYSTEM";
        this.password = "SYS";
        this.inputStream = ((InStream)object).inputStream;
        this.outputStream = ((OutStream)object2).outputStream;
        this.inMessage = (InStream)object;
        this.outMessage = (OutStream)object2;
    }

    void addPrePreparseCache(String string, CacheStatement cacheStatement) {
        if (this.prePreparseCache.size() < 50 && cacheStatement.execParams == null) {
            this.prePreparseCache.put(string, new CachedSQL(cacheStatement));
        }
    }

    private void init() {
        this.protocolVersion = 48;
        this.securityLevel = 0;
        this.principalName = null;
        this.sSLConfigName = null;
        this.keyRecoveryPassword = null;
        this.statementPool = new Vector();
        this.preparedStatementPool = new Vector();
        this.callableStatementPool = new Vector();
        this.cachedPrepares = new HashMap();
        this.messageCount = new MessageCount();
        this.prePreparseCache = new HashMap();
        this.clientInfo = new Properties();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, long l) throws SQLException {
        CachePreparedStatement cachePreparedStatement = (CachePreparedStatement)this.prepareStatement(string, 2, l);
        cachePreparedStatement.statementType = 2;
        return cachePreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, long l) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CachePreparedStatement cachePreparedStatement = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, 1003, 1007);
        if (cachePreparedStatement == null) {
            return new CachePreparedStatement(this, 1003, string, n, l);
        }
        cachePreparedStatement.prepare(string, n, l);
        return cachePreparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, long l) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CacheCallableStatement cacheCallableStatement = (CacheCallableStatement)this.getStatement(this.callableStatementPool, 1003, 1007);
        if (cacheCallableStatement == null) {
            return new CacheCallableStatement(this, string, n, l);
        }
        cacheCallableStatement.prepare(string, n, l);
        return cacheCallableStatement;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.autoCommit = bl;
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (this.autoCommit) {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_ON);
            } else {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_OFF);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(COMMIT);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(ROLLBACK);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.pooled != null) {
            this.closePooledConnection();
            return;
        }
        if (this.registeredDatabases != null) {
            this.registeredDatabases.onClose();
            if (this.closed) {
                return;
            }
        }
        this.closed = true;
        this.cachedPrepares = null;
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(DISCONNECT);
            this.outMessage.send(this.messageCount.getCount());
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        if (this.logFile != null) {
            this.logFile.close();
            this.logFile = null;
        }
        this.outMessage = null;
        this.inMessage = null;
        this.clientInfo = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return new CacheDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.isReadOnly = bl;
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.isReadOnly;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.isolationLevel == n) {
            return;
        }
        if (0 == n || 4 == n || 8 == n) {
            throw new SQLException("Unsupported isolation level " + n, "S1000", 460);
        }
        if (this.supportedIsolationLevels == 1 && 2 == n) {
            throw new SQLException("Unsupported isolation level " + n, "S1000", 460);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (n == 1) {
                this.outMessage.wire.writeHeader(READ_UNCOMMITTED);
            } else {
                this.outMessage.wire.writeHeader(READ_COMMITTED);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
        this.isolationLevel = n;
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.isolationLevel;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.warnings = null;
    }

    private final byte[] encode(int n, byte[] byArray) {
        int n2 = 0;
        byte[] byArray2 = new byte[n];
        while (n > 0) {
            int n3 = ((byArray[n2] ^ 0xA7) & 0xFF) + --n & 0xFF;
            byArray2[n] = (byte)(n3 << 5 | n3 >> 3);
            ++n2;
        }
        return byArray2;
    }

    int getQueryTimeout() throws SQLException {
        try {
            return this.socket.getSoTimeout() / 1000;
        }
        catch (SocketException socketException) {
            throw new SQLException("Communication link failure: " + socketException.getMessage(), "08S01", 461);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQueryTimeout(int n) throws SQLException {
        try {
            Socket socket = this.socket;
            synchronized (socket) {
                this.socket.setSoTimeout(n * 1000);
            }
        }
        catch (SocketException socketException) {
            throw new SQLException("Communication link failure: " + socketException.getMessage(), "08S01", 461);
        }
    }

    private void configureSocket(Properties properties) throws SQLException {
        if (properties == null) {
            return;
        }
        try {
            String string = properties.getProperty("TCP_NODELAY");
            if (string != null) {
                this.socket.setTcpNoDelay(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty("SO_SNDBUF")) != null) {
                this.socket.setSendBufferSize(Integer.parseInt(string));
            }
            if ((string = properties.getProperty("SO_RCVBUF")) != null) {
                this.socket.setReceiveBufferSize(Integer.parseInt(string));
            }
        }
        catch (Exception exception) {
            throw new SQLException("Bad socket option: " + exception.getMessage(), "08S01", 461);
        }
    }

    private Socket constructNewLCBJNISocket(String string, Integer n, String string2, String string3, String string4, String string5) throws SQLException {
        try {
            Class<?> clazz = Class.forName("com.intersys.lcbjni.LCBJNISocket");
            Method method = clazz.getMethod("getLCBJNISocket", String.class, Integer.class, String.class, String.class, String.class, String.class);
            return (Socket)method.invoke(null, string, n, string2, string3, string4, string5);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("No LCBJNI Socket Factory class is available in your classpath");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SQLException(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connect(String string, int n, String string2, String string3, int n2, boolean bl, Properties properties) throws SQLException {
        String string4;
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        if (properties != null && (string4 = properties.getProperty("TransactionIsolationLevel")) != null && string4.equals("TRANSACTION_READ_COMMITTED")) {
            this.isolationLevel = 2;
        }
        try {
            Object object;
            if (this.securityLevel == 0) {
                if (string.equals("SPCHOST")) {
                    object = new Integer(n);
                    this.socket = this.constructNewLCBJNISocket(string, (Integer)object, string2, this.user, this.password, MachineInfo.getExeName());
                } else {
                    this.socket = new Socket(string, n);
                }
            } else if (this.securityLevel > 0 && this.securityLevel < 4) {
                this.socket = new GSSSocket(string, n, this.principalName, this.securityLevel, this.user, this.password);
            } else if (this.securityLevel == 10) {
                object = new SSLSocketFactory(this.sSLConfigName, this.keyRecoveryPassword);
                this.socket = ((SSLSocketFactory)object).createSocket(string, n);
            }
            this.socket.setSoTimeout(n2 * 1000);
            this.socket.setTcpNoDelay(bl);
            this.configureSocket(properties);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
            this.outMessage = new OutStream(this);
            this.inMessage = new InStream(this);
            object = this.messageCount;
            synchronized (object) {
                this.outMessage.wire.writeHeader(HANDSHAKE);
                this.outMessage.wire.set2ByteInt(this.protocolVersion);
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readHeader(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.protocolVersion = this.inMessage.wire.get2ByteInt();
                if (this.protocolVersion < 39) {
                    throw new SQLException("Protocol mismatch; only protocols >= 39 supported", "08S01", 461);
                }
                boolean bl2 = this.inMessage.wire.get2ByteInt() == 1;
                String string5 = this.inMessage.wire.readServerEncoding();
                this.connectionInfo = new ConnectionInfo(this.protocolVersion, string5, bl2);
                this.inMessage.wire.setConnectionInfo(this.connectionInfo);
                this.outMessage.wire.setConnectionInfo(this.connectionInfo);
                this.outMessage.wire.writeHeader(CONNECT);
                this.outMessage.wire.set(string2);
                if (this.user == null || this.user.length() == 0) {
                    this.outMessage.wire.setNull();
                } else {
                    this.outMessage.wire.set(this.encode(this.user.length(), this.user.getBytes()));
                }
                if (this.password == null || this.password.length() == 0) {
                    this.outMessage.wire.setNull();
                } else {
                    this.outMessage.wire.set(this.encode(this.password.length(), this.password.getBytes()));
                }
                String string6 = MachineInfo.getUserName();
                String string7 = MachineInfo.getMachineName();
                String string8 = MachineInfo.getExeName();
                String string9 = this.socket.getLocalAddress().getHostAddress();
                this.clientInfo.put("ApplicationName", string8);
                this.clientInfo.put("ClientHostname", string9);
                this.clientInfo.put("ClientUser", string6);
                this.clientInfo.put("MachineName", string7);
                this.outMessage.wire.set(string6);
                this.outMessage.wire.set(string7);
                this.outMessage.wire.set(string8);
                this.outMessage.wire.set(MachineInfo.getOSInfo());
                this.outMessage.wire.set(string9);
                this.outMessage.wire.set(string3);
                if (this.autoCommit) {
                    this.outMessage.wire.set(1);
                } else {
                    this.outMessage.wire.set(2);
                }
                if (this.isolationLevel == 1) {
                    this.outMessage.wire.set(0);
                } else {
                    this.outMessage.wire.set(1);
                }
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readHeader(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.serverVersion = this.inMessage.wire.getString();
                this.delimitedIds = this.inMessage.wire.getInt();
                this.inMessage.wire.getInt();
                this.supportedIsolationLevels = this.inMessage.wire.getInt();
                this.cacheJobNumber = this.inMessage.wire.getString();
                if (this.logFile != null) {
                    this.logFile.setJobID(this.cacheJobNumber);
                }
                if (this.protocolVersion > 41) {
                    this.connectionInfo.sqlEmptyString = this.inMessage.wire.getInt();
                }
            }
            this.closed = false;
            this.socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            try {
                this.socket.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SQLException("[Cache JDBC] Communication link failure: " + exception.getMessage(), "08S01", 461);
        }
    }

    public boolean isServerUnicode() {
        return this.connectionInfo.isUnicodeServer;
    }

    public String getServerLocale() {
        return this.connectionInfo.serverLocale;
    }

    public ConnectionInfo getConnectionInfo() {
        return (ConnectionInfo)this.connectionInfo.clone();
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachedPrepare(CacheStatement cacheStatement, boolean bl) throws SQLException {
        if (!cacheStatement.poolable || cacheStatement.sqlText.length() > 5000 || cacheStatement.execParams != null) {
            return;
        }
        for (Object k : this.cachedPrepares.keySet()) {
            if (!((CachedPrepare)this.cachedPrepares.get(k)).matches(cacheStatement)) continue;
            return;
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            if (this.cachedPrepares.size() >= 500) {
                this.updateCache();
            }
            this.cachedPrepares.put(new Integer(cacheStatement.serverCursorNumber), new CachedPrepare(cacheStatement, bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachedPrepareNoUpdate(CacheStatement cacheStatement, boolean bl) throws SQLException {
        if (!cacheStatement.poolable || cacheStatement.sqlText.length() > 5000) {
            return;
        }
        for (Object k : this.cachedPrepares.keySet()) {
            if (!((CachedPrepare)this.cachedPrepares.get(k)).matches(cacheStatement)) continue;
            return;
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            this.cachedPrepares.put(new Integer(cacheStatement.serverCursorNumber), new CachedPrepare(cacheStatement, bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCache() throws SQLException {
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            Iterator iterator = this.cachedPrepares.keySet().iterator();
            if (!iterator.hasNext()) {
                return;
            }
            int[] nArray = new int[100];
            int n = 0;
            while (iterator.hasNext()) {
                Object k = iterator.next();
                CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(k);
                if (cachedPrepare.ownedBy != null) continue;
                nArray[n] = cachedPrepare.serverCursorNumber;
                iterator.remove();
                if (++n != 100) continue;
            }
            if (n == 0) {
                return;
            }
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(UPDATE_CACHE);
                this.outMessage.wire.set(n);
                for (int i = 0; i < n; ++i) {
                    this.outMessage.wire.set(nArray[i]);
                }
                this.outMessage.send(this.messageCount.getCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(boolean bl) throws SQLException {
        int n = this.cachedPrepares.size();
        if (n == 0) {
            return;
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            Iterator iterator = this.cachedPrepares.keySet().iterator();
            if (bl) {
                MessageCount messageCount = this.messageCount;
                synchronized (messageCount) {
                    this.outMessage.wire.writeHeader(UPDATE_CACHE);
                    this.outMessage.wire.set(n);
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(k);
                        this.outMessage.wire.set(cachedPrepare.serverCursorNumber);
                        iterator.remove();
                    }
                    this.outMessage.send(this.messageCount.getCount());
                }
                return;
            }
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendXAMessage(byte[] byArray, String string) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(byArray);
            this.outMessage.wire.set(string);
            this.outMessage.send(this.messageCount.getCount());
            return this.inMessage.readHeader(0, 0, 0);
        }
    }

    void getServerError(int n) throws SQLException {
        String string = CacheConnection.getSQLState(n);
        if (this.closed) {
            switch (n) {
                case 469: {
                    throw new SQLException("Driver not capable", string, n);
                }
                case 464: {
                    throw new SQLException("Function sequence error", string, n);
                }
                case 462: {
                    throw new SQLException("Memory allocation failure", string, n);
                }
                case 461: {
                    throw new SQLException("Communication link failure", string, n);
                }
                case 460: {
                    throw new SQLException("General error", string, n);
                }
                case 453: {
                    throw new SQLException("Error in User Initialization Code", string, n);
                }
                case 452: {
                    throw new SQLException("Message sequencing error", string, n);
                }
                case 451: {
                    throw new SQLException("Unable to receive server message", string, n);
                }
                case 450: {
                    throw new SQLException("Unable to send client message", string, n);
                }
                case 410: {
                    throw new SQLException("Invalid Directory", string, n);
                }
                case 409: {
                    throw new SQLException("Invalid server function", string, n);
                }
                case 408: {
                    throw new SQLException("Unable to start server", string, n);
                }
                case 407: {
                    throw new SQLException("Unable to Write to Server Master", string, n);
                }
                case 406: {
                    throw new SQLException("Unable to Write to Server", string, n);
                }
                case 405: {
                    throw new SQLException("Unable to read from communication device", string, n);
                }
                case 402: {
                    throw new SQLException("Invalid Username/Password", string, n);
                }
                case 401: {
                    throw new SQLException("Fatal Connection error", string, n);
                }
                case 400: {
                    throw new SQLException("Fatal error occurred", string, n);
                }
                case 112: {
                    throw new SQLException("Access violation", string, n);
                }
                case 99: {
                    throw new SQLException("Privilege Violation", string, n);
                }
                case 98: {
                    throw new SQLException("License Violation", string, n);
                }
            }
            throw new SQLException("General error", string, n);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GET_SERVER_ERROR);
            this.outMessage.wire.set(n);
            this.outMessage.send(this.messageCount.getCount());
            int n2 = this.inMessage.readHeader(0, 0, 0);
            if (n2 != 0) {
                throw new SQLException("General error", string, n);
            }
            throw new SQLException(this.inMessage.wire.getString(), string, n);
        }
    }

    private static String getSQLState(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return "37000";
            }
            case 30: 
            case 33: 
            case 39: {
                return "S0002";
            }
            case 31: {
                return "S0022";
            }
            case 62: {
                return "21S01";
            }
            case 103: {
                return "34000";
            }
            case 104: 
            case 108: {
                return "23000";
            }
            case 1004: {
                return "01004";
            }
            case 1031: {
                return "42000";
            }
            case 7001: {
                return "07001";
            }
            case 7006: {
                return "07006";
            }
            case 22003: {
                return "22003";
            }
            case 22005: {
                return "22005";
            }
            case 22008: {
                return "22008";
            }
            case 24000: {
                return "24000";
            }
            case 402: {
                return "28000";
            }
            case 413: 
            case 452: 
            case 461: {
                return "08S01";
            }
            case 450: {
                return "S1T00";
            }
            case 462: {
                return "S1001";
            }
            case 463: {
                return "S1002";
            }
            case 464: {
                return "S1010";
            }
            case 465: {
                return "S1090";
            }
            case 466: {
                return "S1093";
            }
            case 467: {
                return "S1097";
            }
            case 468: {
                return "S1106";
            }
            case 469: {
                return "S1C00";
            }
            case 470: {
                return "01S02";
            }
            case 471: {
                return "3C000";
            }
        }
        return "S1000";
    }

    public String getCacheJobID() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.cacheJobNumber;
    }

    public void setCacheJobID(String string) throws SQLException {
        this.cacheJobNumber = string;
    }

    public byte[] sendCustomMessage(byte[] byArray, byte[] byArray2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.outMessage.wire.writeHeader(byArray);
                this.outMessage.wire.setRawBytes(byArray2);
                this.outMessage.send(this.messageCount.getCount());
                int n = this.inMessage.readHeader(0, 2, 0);
                if (n != 0) {
                    throw new SQLException("Error fetching raw byte array", "00000", n);
                }
                return this.inMessage.getRawBytes();
            }
            catch (IOException iOException) {
                throw new SQLException("Communication error: " + iOException.getMessage(), "08S01", 461);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException("sendCustomeMessage: " + exception.getMessage());
            }
        }
    }

    public RegisteredDatabases registerDatabase() {
        if (this.registeredDatabases == null) {
            this.registeredDatabases = new RegisteredDatabases();
        }
        return this.registeredDatabases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOwner(int n, Statement statement) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(new Integer(n));
            return cachedPrepare != null && statement == cachedPrepare.ownedBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean noOwner(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            return this.cachedPrepares.get(new Integer(n)) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsNotBeingExecuted(int n, Statement statement) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(new Integer(n));
            if (cachedPrepare != null && statement == cachedPrepare.ownedBy) {
                cachedPrepare.ownedBy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsBeingExecuted(int n, Statement statement) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(new Integer(n));
            if (cachedPrepare != null && null == cachedPrepare.ownedBy) {
                cachedPrepare.ownedBy = statement;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poolStatement(CacheStatement cacheStatement) {
        Vector vector = this.statementPool;
        if (cacheStatement instanceof CacheCallableStatement) {
            vector = this.callableStatementPool;
        } else if (cacheStatement instanceof CachePreparedStatement) {
            vector = this.preparedStatementPool;
        }
        Vector vector2 = vector;
        synchronized (vector2) {
            if (vector.size() >= 40) {
                cacheStatement.input = null;
                cacheStatement.output = null;
                return;
            }
            vector.addElement(cacheStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closePooledConnection() throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.pooled.release();
        }
    }

    public QuickStatement createQuickStatement() throws SQLException {
        return new QuickStatement(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement getStatement(Vector vector, int n, int n2) {
        Vector vector2 = vector;
        synchronized (vector2) {
            if (vector.isEmpty()) {
                return null;
            }
            CacheStatement cacheStatement = (CacheStatement)vector.elementAt(0);
            cacheStatement.resultSetType = n;
            cacheStatement.closed = false;
            cacheStatement.resultSetConcurrency = n2;
            cacheStatement.serverCursorNumber = 0;
            vector.remove(cacheStatement);
            return cacheStatement;
        }
    }

    int processError(int n, int n2) throws SQLException {
        if (n == 100 && (n2 == 100 || n2 == 504)) {
            return 100;
        }
        if (n == 403 && n2 == 403) {
            return 403;
        }
        if (n == 417 && n2 == 417) {
            return 417;
        }
        if (n == 404 && (n2 == 404 || n2 == 504)) {
            return 404;
        }
        if (n2 == -1) {
            return n;
        }
        this.getServerError(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            synchronized (sQLWarning2) {
                this.warnings.setNextWarning(sQLWarning);
            }
        }
    }

    public Object getOutMessage() {
        return this.outMessage;
    }

    public Object getInMessage() {
        return this.inMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTransaction() throws SQLException {
        if (this.protocolVersion < 41) {
            throw new SQLException("Not supported for protocol < 41", "IM001");
        }
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IN_TRANSACTION);
            this.outMessage.send(this.messageCount.getCount());
            int n = this.inMessage.readHeader(0, 0, -1);
            return n != 0;
        }
    }

    private PreparedStatement prepareStatement(String string, int n, int n2, String string2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CachePreparedStatement cachePreparedStatement = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, n, n2);
        if (cachePreparedStatement == null) {
            cachePreparedStatement = new CachePreparedStatement(this, n, n2, string, string2);
        } else {
            cachePreparedStatement.autoGeneratedKeyColumn = string2;
            cachePreparedStatement.prepare(string);
        }
        return cachePreparedStatement;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getCacheResultSet(String string) throws SQLException {
        CacheStatement cacheStatement = new CacheStatement(this, 1003, 1007, null);
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            cacheStatement.output.wire.writeHeader(0, GET_CACHE_RESULT_SET_OBJECT);
            cacheStatement.output.wire.set(string);
            cacheStatement.output.wire.set(0);
            cacheStatement.output.send(this.messageCount.getCount());
            int n = cacheStatement.input.readHeader(0, 0, 100);
            if (n == 100) {
                cacheStatement.fetchDone = true;
            }
            cacheStatement.columnInfo(cacheStatement.input.wire);
        }
        return new CacheResultSet(cacheStatement, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int n) throws SQLException {
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readHeader(0, 0, 0);
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - l) / 1000.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) throws SQLException {
        try {
            this.socket.setTcpNoDelay(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + "x";
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < n5; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                int n7;
                this.outMessage.wire.writeHeader(PING_TWO);
                this.outMessage.wire.set(n);
                this.outMessage.wire.set(n6);
                this.outMessage.wire.set(n4);
                if (n4 == 0) {
                    this.outMessage.wire.set(n3);
                    for (n7 = 0; n7 < n3; ++n7) {
                        this.outMessage.wire.set(string);
                    }
                } else {
                    this.outMessage.wire.set(n2);
                    this.outMessage.wire.set(string);
                }
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readHeader(0, 0, 0);
                if (n == 3) {
                    n7 = this.inMessage.wire.getInt();
                    if (n4 == 0) {
                        for (int j = 0; j < n7; ++j) {
                            String string2 = this.inMessage.wire.getString();
                        }
                    }
                }
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - l) / 1000.0f;
    }

    public static String[] getNamespaces(String string, int n, String string2, String string3, String string4) throws Exception {
        LogFileStream logFileStream = null;
        Socket socket = new Socket(string, n);
        if (string4 != null && string4.equals("")) {
            logFileStream = new LogFileStream(string4);
        }
        OutStream outStream = new OutStream(socket.getOutputStream(), logFileStream);
        InStream inStream = new InStream(socket.getInputStream(), logFileStream);
        return CacheConnection.getNamespaces(inStream, outStream, string2, string3);
    }

    public static String[] getNamespaces(InStream inStream, OutStream outStream, String string, String string2) throws Exception {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        inStream.wire.setConnectionInfo(connectionInfo);
        outStream.wire.setConnectionInfo(connectionInfo);
        outStream.wire.writeHeader(0, GET_CACHE_INFO);
        outStream.wire.set(string);
        outStream.wire.set(string2);
        outStream.send(0);
        inStream.quickReadHeader();
        int n = inStream.wire.getInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = inStream.wire.getString();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSetClientInfo(Properties properties) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(SET_CLIENT_INFO_PROPERTIES);
            this.outMessage.wire.set(properties.size());
            if (properties.containsKey("ApplicationName")) {
                this.outMessage.wire.set(13);
                this.outMessage.wire.set(properties.getProperty("ApplicationName"));
            }
            if (properties.containsKey("ClientHostname")) {
                this.outMessage.wire.set(12);
                this.outMessage.wire.set(properties.getProperty("ClientHostname"));
            }
            if (properties.containsKey("ClientUser")) {
                this.outMessage.wire.set(11);
                this.outMessage.wire.set(properties.getProperty("ClientUser"));
            }
            if (properties.containsKey("UserInfo")) {
                this.outMessage.wire.set(20);
                this.outMessage.wire.set(properties.getProperty("UserInfo"));
            }
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
        }
    }

    private void modifyClientInfo(String string, Properties properties, Properties properties2) {
        if (properties.containsKey(string)) {
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                string2 = "";
            }
            if (!this.clientInfo.getProperty(string).equals(string2)) {
                this.clientInfo.put(string, string2);
                properties2.put(string, string2);
            }
        }
    }

    synchronized int getServerCursorNumber() {
        if (this.protocolVersion >= 44 && this.recycledServerCursorNumber != -1) {
            int n = this.recycledServerCursorNumber;
            this.recycledServerCursorNumber = -1;
            return n;
        }
        ++this.nextServerCursorNumber;
        return this.nextServerCursorNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareTimestamp(String string, String string2) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(COMPARE_TIMESTAMP);
            this.outMessage.wire.set(string);
            this.outMessage.wire.set(string2);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
            return this.inMessage.wire.getBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTwoFactorEnabled() throws Exception {
        if (this.protocolVersion < 48) {
            return false;
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IS_TWO_FACTOR_ENABLED);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
            return this.inMessage.wire.getBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTwoFactorToken(String string) throws Exception {
        if (this.protocolVersion < 48) {
            throw new Exception("Unsupported for protocol versions < 48");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(SEND_TWO_FACTOR_TOKEN);
            this.outMessage.wire.set(string);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
        }
    }

    public int cqPrepare(String string, byte[] byArray) throws Exception {
        this.outMessage.wire.writeHeader(0, CONTINUOUS_QUERY_PREPARE);
        this.outMessage.wire.set(string);
        this.inMessage.readHeader(0, 0, 0);
        int n = this.inMessage.wire.getInt();
        byArray = this.inMessage.wire.getByte();
        return n;
    }

    public byte[] cqExecute(int n) throws Exception {
        this.outMessage.wire.writeHeader(n, CONTINUOUS_QUERY_EXECUTE);
        this.inMessage.readHeader(n, 0, 0);
        return this.inMessage.wire.getByte();
    }

    public byte[] cqDelta(int n) throws Exception {
        this.outMessage.wire.writeHeader(n, CONTINUOUS_QUERY_GET_DELTA);
        this.inMessage.readHeader(n, 0, 0);
        return this.inMessage.wire.getByte();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        CacheStatement cacheStatement;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n == 1005) {
            this.addWarning(new SQLWarning("createStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            n = 1004;
        }
        if ((cacheStatement = (CacheStatement)this.getStatement(this.statementPool, n, n2)) == null) {
            cacheStatement = new CacheStatement(this, n, n2, null);
        }
        return cacheStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        CachePreparedStatement cachePreparedStatement;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n == 1005) {
            this.addWarning(new SQLWarning("prepareStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            n = 1004;
        }
        if ((cachePreparedStatement = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, n, n2)) == null) {
            return new CachePreparedStatement(this, n, n2, string, null);
        }
        cachePreparedStatement.prepare(string);
        return cachePreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CacheCallableStatement cacheCallableStatement;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n != 1003) {
            this.addWarning(new SQLWarning("prepareCall called with unsupported result set type: TYPE_FORWARD_ONLY used instead", "IM001"));
            n = 1003;
        }
        if (n2 != 1007) {
            this.addWarning(new SQLWarning("prepareCall called with CONCUR_UPDATABLE which is not supported: CONCUR_READ_ONLY used instead", "IM001"));
            n2 = 1007;
        }
        if ((cacheCallableStatement = (CacheCallableStatement)this.getStatement(this.callableStatementPool, n, n2)) == null) {
            return new CacheCallableStatement(this, string);
        }
        cacheCallableStatement.prepare(string);
        return cacheCallableStatement;
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
        return this.createStatement(n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
        return this.prepareStatement(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
        return this.prepareCall(string, n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n == 1) {
            return this.prepareStatement(string, 1003, 1007, "-1");
        }
        return this.prepareStatement(string, 1003, 1007, null);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (nArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        return this.prepareStatement(string, 1003, 1007, Integer.toString(nArray[0]));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (stringArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        return this.prepareStatement(string, 1003, 1007, stringArray[0]);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.savepoints.containsValue(savepoint)) {
            throw new SQLException("Savepoint does not exist/already released");
        }
        this.savepoints.remove(savepoint);
        ((CacheSavepoint)savepoint).release();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Cannot set savepoint when autocommit is on");
        }
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        ++this.savepointId;
        String string = "SAV" + this.savepointId + "PT";
        if (this.savepoints.containsKey(string)) {
            throw new SQLException("Savepoint " + string + " already exists");
        }
        CacheSavepoint cacheSavepoint = new CacheSavepoint(this, string, this.savepointId);
        this.savepoints.put(string, cacheSavepoint);
        return cacheSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Cannot set savepoint when autocommit is on");
        }
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        if (this.savepoints.containsKey(string)) {
            throw new SQLException("Savepoint " + string + " already exists");
        }
        CacheSavepoint cacheSavepoint = new CacheSavepoint(this, string, -1);
        this.savepoints.put(string, cacheSavepoint);
        return cacheSavepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Cannot rollback to savepoint when autocommit is on");
        }
        if (!this.savepoints.containsValue(savepoint)) {
            throw new SQLException("Savepoint does not exist");
        }
        ((CacheSavepoint)savepoint).rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Timeout cannot be negative");
        }
        if (this.closed) {
            return false;
        }
        try {
            this.socket.setSoTimeout(n * 1000);
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readHeader(0, 0, 0);
            }
            this.socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return (String)this.clientInfo.get(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new SQLException("Receiver not a wrapper");
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException();
        }
        if (!this.clientInfo.containsKey(string)) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.clientInfo.getProperty(string).equals(string2)) {
            return;
        }
        Properties properties = new Properties();
        properties.put(string, string2);
        try {
            this.sendSetClientInfo(properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLClientInfoException();
        }
        this.clientInfo.put(string, string2);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException();
        }
        if (properties.isEmpty()) {
            return;
        }
        Properties properties2 = new Properties();
        this.modifyClientInfo("ApplicationName", properties, properties2);
        this.modifyClientInfo("ClientHostname", properties, properties2);
        this.modifyClientInfo("ClientUser", properties, properties2);
        this.modifyClientInfo("MachineName", properties, properties2);
        this.modifyClientInfo("UserInfo", properties, properties2);
        try {
            this.sendSetClientInfo(properties2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLClientInfoException();
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    static final class CachedPrepare {
        int serverCursorNumber;
        Statement ownedBy;
        String sqlText;
        Vector parameters;
        Vector columns;
        int statementType;
        int hasReturnValue;
        SysList additionalParameterInfo;
        boolean multipleResultSets;

        CachedPrepare(CacheStatement cacheStatement, boolean bl) {
            this.sqlText = cacheStatement.sqlText;
            this.serverCursorNumber = cacheStatement.serverCursorNumber;
            this.ownedBy = bl ? cacheStatement : null;
            if (cacheStatement.columns != null) {
                this.columns = (Vector)cacheStatement.columns.clone();
            }
            this.parameters = cacheStatement.saveParameterInfo();
            this.statementType = cacheStatement.statementType;
            this.hasReturnValue = cacheStatement.hasReturnValue;
            this.additionalParameterInfo = cacheStatement.additionalParameterInfo.cloneMe();
            this.multipleResultSets = cacheStatement.multipleResultSets;
        }

        public boolean matches(CacheStatement cacheStatement) {
            return cacheStatement.sqlText.equals(this.sqlText) && CacheStatement.compareParInfoString(this.additionalParameterInfo, cacheStatement.additionalParameterInfo);
        }
    }

    static final class CachedSQL {
        int hasReturnValue;
        int statementType;
        String sqlText;
        Vector parameters;
        int resultSetConcurrency;
        SysList additionalParameterInfo;

        CachedSQL(CacheStatement cacheStatement) {
            this.hasReturnValue = cacheStatement.hasReturnValue;
            this.statementType = cacheStatement.statementType;
            this.sqlText = cacheStatement.sqlText;
            this.resultSetConcurrency = cacheStatement.resultSetConcurrency;
            this.parameters = cacheStatement.saveParameterInfo();
            this.additionalParameterInfo = cacheStatement.additionalParameterInfo.cloneMe();
        }
    }

    static final class MessageCount {
        int count = 0;

        MessageCount() {
        }

        final synchronized int getCount() {
            return ++this.count;
        }
    }
}

