/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.AbstractElementInfoImpl;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.TypeModifierHelper;
import java.sql.Date;

public class ColumnOnlyField
extends AbstractElementInfoImpl
implements ColumnBasedField {
    SQLColumn mColumn;
    private int mColumnIdxForGet = -1;
    private int mColumnIdxForSet = -1;
    private SysDatabase mDB;
    private int mModifier = 0;

    public ColumnOnlyField(SysDatabase sysDatabase, SQLColumn sQLColumn, int n) {
        this.mColumn = sQLColumn;
        this.mDB = sysDatabase;
        this.init(n);
    }

    private void init(int n) {
        this.mColumnIdxForGet = this.mColumn.getNumber() - n + 1;
        this.mColumnIdxForSet = this.mColumnIdxForGet - 1;
        if (this.mColumn.isElementDatatype()) {
            this.addModifier(16);
        }
    }

    protected final void addModifier(int n) {
        this.mModifier |= n;
    }

    @Override
    public ColumnBasedField getChildField(CacheField cacheField) {
        return null;
    }

    @Override
    public int getColumnIndexForGet() {
        return this.mColumnIdxForGet;
    }

    @Override
    public int getColumnIndexForSet() {
        return this.mColumnIdxForSet;
    }

    @Override
    public String columnNameForEmbProp(String string) throws CacheException {
        return null;
    }

    @Override
    public boolean isEmbeddedSetUp() {
        return false;
    }

    @Override
    public boolean isEmbedded() {
        return this.mColumn.isForEmbeddedObject();
    }

    @Override
    public int getSerialStorageIndex() {
        return -1;
    }

    @Override
    public SysDatabase getDatabase() {
        return this.mDB;
    }

    @Override
    public int getTypeModifiers() {
        return this.mColumn.getTypeModifiers();
    }

    @Override
    public String getName() {
        return this.mColumn.getFieldName();
    }

    @Override
    public String getDefaultValueString() {
        return null;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public CacheClass getType() throws CacheException {
        if (this.mDB == null) {
            return null;
        }
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return this.mDB.getCacheClass(string);
    }

    @Override
    public String getTypeName() {
        return this.mColumn.getTypeName();
    }

    @Override
    public String getElementTypeName() {
        return null;
    }

    @Override
    public String getJavaTypeName() {
        CacheClass cacheClass = null;
        try {
            cacheClass = this.getType();
            if (cacheClass != null) {
                return cacheClass.getJavaClassName();
            }
        }
        catch (CacheException cacheException) {
            return null;
        }
        return null;
    }

    @Override
    public int getModifiers() {
        return this.mModifier;
    }

    @Override
    public String getJavaName() {
        return this.getName();
    }

    @Override
    public int getClientTypeId() {
        return this.mColumn.getDataTypeColumn();
    }

    @Override
    public boolean isLiteral(boolean bl) {
        int n = this.getClientTypeId();
        return TypeModifierHelper.isPrimitive(n, bl);
    }

    @Override
    public String getAccessorName() {
        return null;
    }

    @Override
    public int getJDBCType() {
        return this.mColumn.getJDBCType();
    }

    @Override
    public String getRealClass() {
        throw new UnsupportedOperationException("Method getRealClass() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public Object get(Object object) throws CacheException {
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not get field value on object of type " + object.getClass().getName());
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((ObjectHandle)object).getProxy();
        boolean bl = this.isLiteral();
        Dataholder dataholder = quickPersistentObject.getProperty(this);
        if (bl) {
            return dataholder.getObject(this.getJavaTypeName());
        }
        CacheObject cacheObject = dataholder.getCacheObject();
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.newJavaInstance(true);
    }

    @Override
    public Object get(int n) throws CacheException {
        throw new UnsupportedOperationException("Method get(int) is not supported in Light mode.");
    }

    @Override
    public void set(int n, Object object) throws CacheException {
        throw new UnsupportedOperationException("Method set(int) is not supported in Light mode.");
    }

    @Override
    public void set(Object object, Object object2) throws CacheException {
        Dataholder dataholder = null;
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not set field value on object of type " + object.getClass().getName());
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((ObjectHandle)object).getProxy();
        if (!this.isLiteral() && object2 instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object2;
            dataholder = new Dataholder(1026, objectHandle.getProxy());
        } else if (Date.class.getName().endsWith(this.getJavaTypeName())) {
            dataholder = Dataholder.create(object2);
            dataholder = new Dataholder(64, dataholder.getDate());
        } else {
            dataholder = Dataholder.create(object2);
        }
        quickPersistentObject.setProperty(this, dataholder, true, true);
    }

    @Override
    public int getII() {
        throw new UnsupportedOperationException("Method getII() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public int getJJ() {
        throw new UnsupportedOperationException("Method getJJ() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public int getKK() {
        throw new UnsupportedOperationException("Method getKK() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public boolean isChildTable() {
        return false;
    }

    @Override
    public String getChildTableName() {
        return null;
    }

    @Override
    public SQLColumn getSQLColumn() {
        return this.mColumn;
    }

    @Override
    public String getInverseFieldName() {
        return null;
    }

    @Override
    public boolean isSerial() throws CacheException {
        return this.isElementSerial();
    }

    @Override
    public String[] getDisplayList() {
        return null;
    }

    @Override
    public String[] getValueList() {
        return null;
    }

    @Override
    public boolean isCalculated() {
        return this.isSQLComputed();
    }

    @Override
    public boolean isSQLComputed() {
        return !this.mColumn.isUpdateable();
    }

    @Override
    public boolean hasGet() {
        return true;
    }

    @Override
    public boolean hasSet() {
        return this.mColumn.isUpdateable();
    }

    @Override
    public boolean hasGetAsMethod() {
        return false;
    }

    @Override
    public boolean hasSetAsMethod() {
        return false;
    }

    @Override
    public boolean definedGet() {
        return false;
    }

    @Override
    public boolean definedSet() {
        return false;
    }

    @Override
    public String getGetAccessorName() {
        return null;
    }

    @Override
    public String getDeclaredType() {
        throw new UnsupportedOperationException("Method getDeclaredType() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public String getGetter() {
        throw new UnsupportedOperationException("Method getGetter() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public boolean isTransient() {
        throw new UnsupportedOperationException("Method isTransient() is not implemented in class class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public boolean isRequiredInProjection() {
        return true;
    }

    @Override
    public boolean isVersionField() throws CacheException {
        return false;
    }

    @Override
    public TableMetadata getChildTableMetadata() {
        return null;
    }

    @Override
    public int getFetchPolicy() throws CacheException {
        return 0;
    }

    @Override
    public String getInverseColumnName() throws CacheException {
        throw new UnsupportedOperationException("Method getInverseColumnName() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    @Override
    public CacheClass getDeclaringCacheClass() throws CacheException {
        return this.mColumn.getContainingClass();
    }

    @Override
    public boolean isRequired() throws CacheException {
        return false;
    }

    @Override
    public boolean isIncludedInBestKey() throws CacheException {
        return false;
    }
}

