/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jbind.ZObjValReader;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.classes.SerialObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;

public class ReadOnlyCacheObject
implements CacheObject {
    private String mClassName;
    private ReadOnlyDatabase mDB;
    private ZObjValReader mZobjVal;
    private int mOref;
    private int mState;

    public ReadOnlyCacheObject(ReadOnlyDatabase readOnlyDatabase, String string, int n, ZObjValReader zObjValReader) {
        this.mDB = readOnlyDatabase;
        this.mClassName = string;
        this.mOref = n;
        this.mZobjVal = zObjValReader;
        this.mState |= 0xFF01;
    }

    @Override
    public final Object getZRef() {
        return new Integer(this.mOref);
    }

    @Override
    public final int getOref() {
        return this.mOref;
    }

    @Override
    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return this.getProperty(string, n3 == 1);
    }

    @Override
    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        this.setProperty(string, dataholder);
    }

    @Override
    public Dataholder getProperty(String string, boolean bl) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CacheField cacheField = cacheClass.getField(string);
        if (cacheField == null) {
            return null;
        }
        int n = cacheField.getII();
        Dataholder dataholder = this.mZobjVal.getProperty(n);
        if (dataholder == null) {
            dataholder = Dataholder.create(null);
        }
        if (bl && dataholder.getType() != 1026) {
            dataholder = this.getCacheObject(dataholder);
            this.setCachedObject(n, dataholder);
        }
        return dataholder;
    }

    @Override
    public SysDatabase getDatabase() {
        return this.mDB;
    }

    private Dataholder getCacheObject(Dataholder dataholder) throws CacheException {
        ReadOnlyDatabase readOnlyDatabase = (ReadOnlyDatabase)this.getDatabase();
        return readOnlyDatabase.getCacheObject(dataholder);
    }

    private void setCachedObject(int n, Dataholder dataholder) throws CacheException {
        this.mZobjVal.setCachedObject(n, dataholder);
    }

    @Override
    public Oid getOid() throws CacheException {
        Oid oid = null;
        if (this.mZobjVal != null) {
            oid = this.mZobjVal.getOid();
        }
        return oid;
    }

    @Override
    public void setProperty(String string, Dataholder dataholder) throws CacheException {
        throw new CacheException("Set is not supported in Read-Only mode");
    }

    @Override
    public int save(boolean bl) throws CacheException {
        throw new CacheException("Save is not supported in Read-Only mode");
    }

    @Override
    public int saveRequiredFields() throws CacheException {
        throw new UnsupportedOperationException("Method saveRequiredFields() is not implemented in class com.intersys.cache.jbind.ReadOnlyCacheObject");
    }

    @Override
    public Object getSerialState(Object object) throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.mDB.getLightDatabase();
        CacheClass cacheClass = lightDatabase.getCacheClass(this.getCacheClass().getName());
        SerialObject serialObject = null;
        Object object2 = cacheClass.newInstance("");
        try {
            serialObject = (SerialObject)object2;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        if (serialObject == null) {
            return null;
        }
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            boolean bl = cacheField.isLiteral();
            Dataholder dataholder = this.getProperty(cacheField.getName(), !bl);
            Object object3 = bl ? dataholder.getObject(cacheField.getJavaTypeName()) : dataholder.getCacheObject();
            cacheField.set(serialObject, object3);
        }
        return serialObject.getProxy().getSerialState(object);
    }

    @Override
    public void delete() throws CacheException {
        throw new CacheException("Delete is not supported in Read-Only mode");
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public CacheObject getMe() {
        return this;
    }

    @Override
    public void setCacheClass(CacheClass cacheClass) throws CacheException {
    }

    @Override
    public String getTypeName() {
        return this.mClassName;
    }

    @Override
    public Object newJavaInstance() throws CacheException {
        return this.newJavaInstance(false);
    }

    @Override
    public Object newJavaInstance(boolean bl) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        return cacheClass.newInstance(this, bl);
    }

    @Override
    public CacheClass getCacheClass() throws CacheException {
        return this.mDB.getCacheClass(this.mClassName);
    }

    @Override
    public Id getId() throws CacheException {
        return this.getOid().getId();
    }

    @Override
    public void forceClose() throws CacheException {
    }

    @Override
    public void increaseReferenceCount() throws CacheException {
    }

    @Override
    public void decreaseReferenceCount() throws CacheException {
    }

    @Override
    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        return null;
    }

    @Override
    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        return null;
    }

    @Override
    public void setUserData(Object object) {
    }

    @Override
    public Object getUserData() {
        return null;
    }

    @Override
    public void increaseCount() throws CacheException {
    }

    @Override
    public void decreaseCount() throws CacheException {
    }

    @Override
    public void assertNotClosed(boolean bl) throws CacheException {
        throw new UnsupportedOperationException("Method assertNotClosed() is not implemented in class com.intersys.cache.jbind.ReadOnlyCacheObject");
    }

    @Override
    public String toOrefString() throws CacheException {
        return String.valueOf(this.getOref()) + '@' + this.getCacheClass().getName();
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void clearReadState() {
        this.mState = 65280;
    }

    @Override
    public void setStateReadDirty() {
        this.mState |= 0xFF01;
    }

    @Override
    public Object getPojo() {
        return null;
    }

    @Override
    public void setPojo(Object object) {
    }

    public String toString() {
        return this.mOref + "@" + this.mClassName;
    }
}

