/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ListMap
extends AbstractMap {
    private List list;

    public ListMap(List list) {
        this.list = list;
    }

    @Override
    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Object remove(Object object) {
        if (object == null || !(object instanceof Integer)) {
            throw new ClassCastException("Key must be an Integer.");
        }
        int n = (Integer)object;
        return this.list.remove(n);
    }

    @Override
    public Object put(Object object, Object object2) {
        if (object == null || !(object instanceof Integer)) {
            throw new ClassCastException("Key must be an Integer.");
        }
        int n = (Integer)object;
        if (n >= this.list.size()) {
            this.resizeList(n + 1);
        }
        return this.list.set(n, object2);
    }

    private synchronized void resizeList(int n) {
        if (n <= this.list.size()) {
            return;
        }
        if (this.list instanceof Vector) {
            ((Vector)this.list).setSize(n);
        } else if (this.list instanceof ArrayList) {
            int n2 = this.list.size();
            ArrayList arrayList = (ArrayList)this.list;
            arrayList.ensureCapacity(n);
            for (int i = n2; i < n; ++i) {
                arrayList.add(null);
            }
        } else {
            int n3;
            for (int i = n3 = this.list.size(); i < n; ++i) {
                this.list.add(null);
            }
        }
    }

    private class MapEntry
    implements Map.Entry {
        private int idx;

        public MapEntry(int n) {
            this.idx = n;
        }

        public Object getKey() {
            return new Integer(this.idx);
        }

        public Object getValue() {
            return ListMap.this.list.get(this.idx);
        }

        public Object setValue(Object object) {
            return ListMap.this.list.set(this.idx, object);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof MapEntry)) {
                return false;
            }
            MapEntry mapEntry = (MapEntry)object;
            if (!mapEntry.isMyList(ListMap.this.list)) {
                return false;
            }
            return this.idx == mapEntry.idx;
        }

        @Override
        public int hashCode() {
            return this.idx;
        }

        private boolean isMyList(List list) {
            return ((Object)ListMap.this.list).equals(list);
        }
    }

    private class EntryIterator
    implements Iterator {
        int idx = 0;

        @Override
        public boolean hasNext() {
            return this.idx < ListMap.this.list.size();
        }

        public Object next() {
            return new MapEntry(this.idx++);
        }

        @Override
        public void remove() {
            ListMap.this.list.remove(this.idx);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ListMap.this.list.size();
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }
    }
}

