/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.shaded.apache.http.HttpHost;
import com.simba.athena.shaded.apache.http.StatusLine;
import com.simba.athena.shaded.apache.http.auth.AuthScope;
import com.simba.athena.shaded.apache.http.auth.UsernamePasswordCredentials;
import com.simba.athena.shaded.apache.http.client.CredentialsProvider;
import com.simba.athena.shaded.apache.http.client.config.RequestConfig;
import com.simba.athena.shaded.apache.http.client.methods.CloseableHttpResponse;
import com.simba.athena.shaded.apache.http.client.methods.HttpGet;
import com.simba.athena.shaded.apache.http.client.methods.HttpPost;
import com.simba.athena.shaded.apache.http.entity.StringEntity;
import com.simba.athena.shaded.apache.http.impl.client.BasicCredentialsProvider;
import com.simba.athena.shaded.apache.http.impl.client.CloseableHttpClient;
import com.simba.athena.shaded.apache.http.impl.client.HttpClients;
import com.simba.athena.shaded.apache.http.util.EntityUtils;
import com.simba.athena.shaded.fasterxml.jackson.databind.JsonNode;
import com.simba.athena.shaded.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Desktop;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class OktaCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_APP_URL = "app_id";
    private static final String KEY_APP_NAME = "app_name";
    private static final String OKTA_MFA_TYPE = "okta_mfa_type";
    private static final String OKTA_MFA_WAIT_TIME = "okta_mfa_wait_time";
    private static final String OKTA_PHONE_NUMBER = "okta_phone_number";
    private static final String OKTA_VERIFY_PUSH_FACTOR_TYPE = "push";
    private static final String OKTA_VERIFY_TOTP_FACTOR_TYPE = "token:software:totp";
    private static final String OKTA_SMS_FACTOR_TYPE = "sms";
    private static final String OKTA_VERIFY_PROVIDER = "OKTA";
    private static final String GOOGLE_AUTHENTICATOR_FACTOR_TYPE = "token:software:totp";
    private static final String GOOGLE_AUTHENTICATOR_PROVIDER = "GOOGLE";
    private static final int DEFAULT_OKTA_MFA_WAIT_TIME = 60;
    private static final String OKTA_AUTHENTICATION_URL = "/api/v1/authn";
    private static final String OKTA_FACTORS_URL = "/api/v1/authn/factors";
    public static final String USE_OKTA_MFA = "UseOktaMFA";
    protected String m_app_id;
    protected String m_app_name;
    protected String m_okta_mfa_type;
    protected String m_okta_phone_number;
    protected int m_okta_mfa_wait_time = 60;
    private String m_oktaMfaFactorType;
    private String m_oktaMfaProvider;
    private boolean m_useOktaMfa = false;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_APP_URL.equalsIgnoreCase(string)) {
            this.m_app_id = string2;
        }
        if (KEY_APP_NAME.equalsIgnoreCase(string)) {
            this.m_app_name = string2;
        }
        if (OKTA_MFA_TYPE.equalsIgnoreCase(string)) {
            this.m_okta_mfa_type = string2;
        }
        if (OKTA_MFA_WAIT_TIME.equalsIgnoreCase(string)) {
            this.m_okta_mfa_wait_time = Integer.parseInt(string2);
        }
        if (OKTA_PHONE_NUMBER.equalsIgnoreCase(string)) {
            this.m_okta_phone_number = string2;
        }
        if (USE_OKTA_MFA.equalsIgnoreCase(string)) {
            this.m_useOktaMfa = Boolean.parseBoolean(string2);
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        if (StringUtils.isNullOrEmpty(this.m_app_id)) {
            throw new IOException("Missing required property: app_id");
        }
        CloseableHttpClient closeableHttpClient = null;
        try {
            Object object;
            closeableHttpClient = this.getHttpClient();
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                object = new BasicCredentialsProvider();
                object.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object).build();
            }
            object = this.oktaAuthentication(closeableHttpClient);
            String string = this.handleSamlAssertion(closeableHttpClient, (String)object);
            return string;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly(closeableHttpClient, null);
        }
    }

    @Override
    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        return null;
    }

    private String handleSamlAssertion(CloseableHttpClient closeableHttpClient, String string) throws IOException {
        int n;
        Object object;
        this.m_app_name = StringUtils.isNullOrEmpty(this.m_app_name) ? "amazon_aws" : URLEncoder.encode(this.m_app_name, "UTF-8");
        String string2 = "https://" + this.m_idpHost + "/home/" + this.m_app_name + "/" + this.m_app_id;
        HttpGet httpGet = new HttpGet(string2 + "?onetimetoken=" + string);
        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
            object = new HttpHost(this.m_proxyHost, this.m_proxyPort);
            RequestConfig requestConfig = RequestConfig.custom().setProxy((HttpHost)object).build();
            httpGet.setConfig(requestConfig);
        }
        if ((n = (object = closeableHttpClient.execute(httpGet)).getStatusLine().getStatusCode()) != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + object.getStatusLine().getStatusCode() + " : Reason : " + object.getStatusLine().getReasonPhrase());
        }
        String string3 = EntityUtils.toString(object.getEntity());
        for (String string4 : this.getInputTagsfromHTML(string3)) {
            String string5 = this.getValueByKey(string4, "name");
            String string6 = this.getValueByKey(string4, "value");
            if (!"SAMLResponse".equalsIgnoreCase(string5)) continue;
            return string6.replace("&#x2b;", "+").replace("&#x3d;", "=");
        }
        throw new IOException("Failed to retrieve SAMLAssertion.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String oktaAuthentication(CloseableHttpClient closeableHttpClient) throws IOException {
        block15: {
            JsonNode jsonNode;
            CloseableHttpResponse closeableHttpResponse;
            block14: {
                block13: {
                    String string;
                    closeableHttpResponse = null;
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        HttpPost httpPost = new HttpPost("https://" + this.m_idpHost + OKTA_AUTHENTICATION_URL);
                        httpPost.addHeader("Accept", "application/json");
                        httpPost.addHeader("Content-Type", "application/json");
                        httpPost.addHeader("Cache-Control", "no-cache");
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("username", this.m_userName);
                        hashMap.put("password", this.m_password);
                        StringWriter stringWriter = new StringWriter();
                        objectMapper.writeValue(stringWriter, hashMap);
                        StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                        stringEntity.setContentType("application/json");
                        httpPost.setEntity(stringEntity);
                        closeableHttpResponse = closeableHttpClient.execute(httpPost);
                        StatusLine statusLine = closeableHttpResponse.getStatusLine();
                        int n = statusLine.getStatusCode();
                        if (n != 200) {
                            throw new IOException(statusLine.getReasonPhrase());
                        }
                        jsonNode = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                        if (!"SUCCESS".equals(jsonNode.get("status").asText())) break block13;
                        string = jsonNode.get("sessionToken").asText();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(closeableHttpResponse, null);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(closeableHttpResponse, null);
                    return string;
                }
                if (!this.m_useOktaMfa) throw new IOException("No session token in the response.");
                if (20 > this.m_okta_mfa_wait_time) {
                    throw new IOException("Wait time cannot be less than 20 seconds");
                }
                if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
                    this.m_oktaMfaFactorType = OKTA_VERIFY_PUSH_FACTOR_TYPE;
                    this.m_oktaMfaProvider = OKTA_VERIFY_PROVIDER;
                } else if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString())) {
                    this.m_oktaMfaFactorType = "token:software:totp";
                    this.m_oktaMfaProvider = OKTA_VERIFY_PROVIDER;
                } else if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString())) {
                    this.m_oktaMfaFactorType = "token:software:totp";
                    this.m_oktaMfaProvider = GOOGLE_AUTHENTICATOR_PROVIDER;
                } else {
                    if (!this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) throw new IOException("Invalid factor type specified.");
                    this.m_oktaMfaFactorType = OKTA_SMS_FACTOR_TYPE;
                    this.m_oktaMfaProvider = OKTA_VERIFY_PROVIDER;
                }
                if (!"MFA_REQUIRED".equals(jsonNode.get("status").asText())) break block14;
                String string = this.authenticateExistingUser(closeableHttpClient, jsonNode);
                IOUtils.closeQuietly(closeableHttpResponse, null);
                return string;
            }
            if (!"MFA_ENROLL".equals(jsonNode.get("status").asText())) throw new IOException("No session token in the response.");
            String string = this.enrollNewUser(closeableHttpClient, jsonNode);
            if (!string.equals("SUCCESS")) break block15;
            String string2 = this.oktaAuthentication(closeableHttpClient);
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string2;
        }
        throw new IOException("Okta MFA Enrollment Failed.");
    }

    private String authenticateExistingUser(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        JsonNode jsonNode2 = jsonNode.path("_embedded").path("factors");
        for (JsonNode jsonNode3 : jsonNode2) {
            String string;
            String string2 = jsonNode3.path("factorType").asText();
            String string3 = jsonNode3.path("provider").asText();
            if (!string2.equalsIgnoreCase(this.m_oktaMfaFactorType) || !string3.equalsIgnoreCase(this.m_oktaMfaProvider)) continue;
            if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
                String string4 = jsonNode3.path("_links").path("verify").path("href").asText();
                int n = 0;
                int n2 = this.m_okta_mfa_wait_time / 10;
                while (n2 > n) {
                    try {
                        String string5 = this.getOktaVerifyState(closeableHttpClient, jsonNode.get("stateToken").asText(), string4);
                        if ("WAITING".equals(string5)) {
                            ++n;
                            Thread.sleep(10000L);
                            continue;
                        }
                        if ("REJECTED".equals(string5)) {
                            throw new IOException("Okta Verify Push Notification Rejected.");
                        }
                        return string5;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                throw new IOException("Failed Maximum number of retries");
            }
            if (!this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString()) && !this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString()) && !this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) continue;
            String string6 = jsonNode3.path("_links").path("verify").path("href").asText();
            if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
                this.sendSMSChallenge(closeableHttpClient, jsonNode.get("stateToken").asText(), string6);
            }
            if (null != (string = JOptionPane.showInputDialog("Please enter passcode to authenticate: "))) {
                return this.verifyTotpFactor(closeableHttpClient, jsonNode.get("stateToken").asText(), string6, string);
            }
            throw new IOException("User cancelled the authentication process");
        }
        throw new IOException("Enrollment Failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSMSChallenge(CloseableHttpClient closeableHttpClient, String string, String string2) throws IOException {
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            HttpPost httpPost = new HttpPost(string2);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Cache-Control", "no-cache");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("stateToken", string);
            StringWriter stringWriter = new StringWriter();
            objectMapper.writeValue(stringWriter, hashMap);
            StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            int n = statusLine.getStatusCode();
            JsonNode jsonNode = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
            if (n == 403 || n == 401) {
                throw new IOException(jsonNode.get("errorSummary").asText());
            }
            if (n != 200) {
                throw new IOException(statusLine.getReasonPhrase());
            }
            if (!"MFA_CHALLENGE".equals(jsonNode.get("status").asText())) {
                throw new IOException("SMS Challenge failed.");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(closeableHttpResponse, null);
            throw throwable;
        }
        IOUtils.closeQuietly(closeableHttpResponse, null);
    }

    private String enrollNewUser(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        block7: {
            String string;
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                Object object;
                ObjectMapper objectMapper = new ObjectMapper();
                HttpPost httpPost = new HttpPost("https://" + this.m_idpHost + OKTA_FACTORS_URL);
                httpPost.addHeader("Accept", "application/json");
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.addHeader("Cache-Control", "no-cache");
                String string2 = jsonNode.get("stateToken").asText();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("stateToken", string2);
                hashMap.put("factorType", this.m_oktaMfaFactorType);
                hashMap.put("provider", this.m_oktaMfaProvider);
                if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
                    if (StringUtils.isNullOrEmpty(this.m_okta_phone_number)) {
                        throw new IOException("Phone number not specified.");
                    }
                    object = new HashMap();
                    object.put("phoneNumber", this.m_okta_phone_number);
                    hashMap.put("profile", object);
                }
                object = new StringWriter();
                objectMapper.writeValue((Writer)object, hashMap);
                StringEntity stringEntity = new StringEntity(((StringWriter)object).toString(), "UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity(stringEntity);
                closeableHttpResponse = closeableHttpClient.execute(httpPost);
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                JsonNode jsonNode2 = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                if (n == 403 || n == 400) {
                    throw new IOException(jsonNode2.get("errorSummary").asText());
                }
                if (n != 200) {
                    throw new IOException(statusLine.getReasonPhrase());
                }
                if (!"MFA_ENROLL_ACTIVATE".equals(jsonNode2.get("status").asText())) break block7;
                string = this.enrollDeviceForOktaMfa(closeableHttpClient, jsonNode2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                throw throwable;
            }
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string;
        }
        throw new IOException("MFA Enroll Exception.");
    }

    private String enrollDeviceForOktaMfa(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        Object object;
        JsonNode jsonNode2 = jsonNode.path("_embedded").path("factor");
        String string = jsonNode2.path("_embedded").path("activation").path("_links").path("qrcode").path("href").asText();
        if (!this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            } else {
                object = Runtime.getRuntime();
                try {
                    ((Runtime)object).exec("xdg-open " + string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
            int n = 0;
            int n2 = this.m_okta_mfa_wait_time / 10;
            while (n2 > n) {
                try {
                    String string2 = this.pollForFactorEnrollment(closeableHttpClient, jsonNode);
                    if (string2.equals("SUCCESS")) {
                        return string2;
                    }
                    Thread.sleep(10000L);
                    ++n;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            throw new IOException("QR Code Scanning Timeout");
        }
        if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
            object = this.pollForFactorEnrollment(closeableHttpClient, jsonNode);
            if (((String)object).equals("SUCCESS")) {
                return object;
            }
            throw new IOException("Device Activation Failed.");
        }
        throw new IOException("Invalid Factor Type Specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pollForFactorEnrollment(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        String string;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            Object object;
            ObjectMapper objectMapper = new ObjectMapper();
            String string2 = jsonNode.path("_links").path("next").path("href").asText();
            HttpPost httpPost = new HttpPost(string2);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Cache-Control", "no-cache");
            String string3 = jsonNode.get("stateToken").asText();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("stateToken", string3);
            if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
                hashMap.put("factorType", OKTA_VERIFY_PUSH_FACTOR_TYPE);
                hashMap.put("provider", OKTA_VERIFY_PROVIDER);
            } else if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
                object = JOptionPane.showInputDialog("Please enter passcode to activate your device: ");
                if (null != object) {
                    hashMap.put("passCode", object);
                } else {
                    throw new IOException("User cancelled the activation process");
                }
            }
            object = new StringWriter();
            objectMapper.writeValue((Writer)object, hashMap);
            StringEntity stringEntity = new StringEntity(((StringWriter)object).toString(), "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            int n = statusLine.getStatusCode();
            JsonNode jsonNode2 = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
            if (n == 403 || n == 401) {
                throw new IOException(jsonNode2.get("errorSummary").asText());
            }
            if (n != 200 && n != 202) {
                throw new IOException(statusLine.getReasonPhrase());
            }
            string = jsonNode2.get("status").asText();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(closeableHttpResponse, null);
            throw throwable;
        }
        IOUtils.closeQuietly(closeableHttpResponse, null);
        return string;
    }

    private String getOktaVerifyState(CloseableHttpClient closeableHttpClient, String string, String string2) throws IOException {
        block6: {
            JsonNode jsonNode;
            CloseableHttpResponse closeableHttpResponse;
            block5: {
                String string3;
                closeableHttpResponse = null;
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    HttpPost httpPost = new HttpPost(string2);
                    httpPost.addHeader("Accept", "application/json");
                    httpPost.addHeader("Content-Type", "application/json");
                    httpPost.addHeader("Cache-Control", "no-cache");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("stateToken", string);
                    StringWriter stringWriter = new StringWriter();
                    objectMapper.writeValue(stringWriter, hashMap);
                    StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity(stringEntity);
                    closeableHttpResponse = closeableHttpClient.execute(httpPost);
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    int n = statusLine.getStatusCode();
                    if (n != 200) {
                        throw new IOException(statusLine.getReasonPhrase());
                    }
                    jsonNode = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                    if (!"SUCCESS".equals(jsonNode.get("status").asText())) break block5;
                    string3 = jsonNode.get("sessionToken").asText();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(closeableHttpResponse, null);
                    throw throwable;
                }
                IOUtils.closeQuietly(closeableHttpResponse, null);
                return string3;
            }
            if (!"MFA_CHALLENGE".equals(jsonNode.get("status").asText())) break block6;
            String string4 = jsonNode.get("factorResult").asText();
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string4;
        }
        throw new IOException("Okta Push Verification failed.");
    }

    private String verifyTotpFactor(CloseableHttpClient closeableHttpClient, String string, String string2, String string3) throws IOException {
        block5: {
            String string4;
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                HttpPost httpPost = new HttpPost(string2);
                httpPost.addHeader("Accept", "application/json");
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.addHeader("Cache-Control", "no-cache");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("stateToken", string);
                hashMap.put("passCode", string3);
                StringWriter stringWriter = new StringWriter();
                objectMapper.writeValue(stringWriter, hashMap);
                StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity(stringEntity);
                closeableHttpResponse = closeableHttpClient.execute(httpPost);
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                JsonNode jsonNode = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                if (n == 403 || n == 401) {
                    throw new IOException(jsonNode.get("errorSummary").asText());
                }
                if (n != 200) {
                    throw new IOException(statusLine.getReasonPhrase());
                }
                if (!"SUCCESS".equals(jsonNode.get("status").asText())) break block5;
                string4 = jsonNode.get("sessionToken").asText();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                throw throwable;
            }
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string4;
        }
        throw new IOException("Okta TOTP Factor failed.");
    }

    static enum SupportedFactors {
        OKTAVERIFYWITHPUSH,
        OKTAVERIFYWITHTOTP,
        SMSAUTHENTICATION,
        GOOGLEAUTHENTICATOR;

    }
}

