/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.amazonaws.services.athena.model.DataCatalogSummary;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJColumnMetadata;
import com.simba.athena.athena.dataengine.metadata.AJSchemaMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJMetadataHelperUtilities;
import com.simba.athena.dsi.dataengine.filters.IFilter;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class AJColumnsMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private AJClient m_client;
    private List<AJColumnMetadata> m_columnMetadataList = new ArrayList<AJColumnMetadata>();
    private ListIterator<AJColumnMetadata> m_columnMetadataIterator;
    private AJColumnMetadata m_currentColumnMetadata;

    public AJColumnsMetadataSource(ILogger iLogger, AJClient aJClient, ArrayList<IFilter> arrayList, String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient, arrayList);
        this.m_logger = iLogger;
        this.m_client = aJClient;
        StringWrapperFilter stringWrapperFilter = null;
        StringWrapperFilter stringWrapperFilter2 = null;
        StringWrapperFilter stringWrapperFilter3 = null;
        for (IFilter iFilter : arrayList) {
            switch (iFilter.getColumnTag()) {
                case SCHEMA_NAME: {
                    stringWrapperFilter = new StringWrapperFilter(iFilter);
                    break;
                }
                case TABLE_NAME: {
                    stringWrapperFilter2 = new StringWrapperFilter(iFilter);
                    break;
                }
                case COLUMN_NAME: {
                    stringWrapperFilter3 = new StringWrapperFilter(iFilter);
                    break;
                }
            }
        }
        this.initMetadata(string, string2, string3, stringWrapperFilter, stringWrapperFilter2, stringWrapperFilter3);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_catalogName, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_schemaName, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_tableName, dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_columnName, dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setInteger(this.m_currentColumnMetadata.m_sqlDataType);
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_typeName, dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(AJMetadataHelperUtilities.getColumnSize(this.m_currentColumnMetadata.m_sqlDataType, this.m_currentColumnMetadata.m_decimalPrecision, this.m_currentColumnMetadata.m_characterColumnLength, this.m_currentColumnMetadata.m_binaryColumnLength));
                return false;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(AJMetadataHelperUtilities.getBufferLength(this.m_currentColumnMetadata.m_sqlDataType, this.m_currentColumnMetadata.m_decimalPrecision, this.m_currentColumnMetadata.m_characterColumnLength, this.m_currentColumnMetadata.m_binaryColumnLength));
                return false;
            }
            case DECIMAL_DIGITS: {
                if (TypeUtilities.isExactNumericType(this.m_currentColumnMetadata.m_sqlDataType)) {
                    dataWrapper.setInteger(this.m_currentColumnMetadata.m_decimalScale);
                } else if (TypeUtilities.isTimeType(this.m_currentColumnMetadata.m_sqlDataType)) {
                    dataWrapper.setInteger(3L);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                int n = TypeUtilities.getNumPrecRadix((short)this.m_currentColumnMetadata.m_sqlDataType);
                if (0 == n) {
                    dataWrapper.setNull(4);
                } else {
                    dataWrapper.setInteger(n);
                }
                return false;
            }
            case NULLABLE: {
                dataWrapper.setInteger(1L);
                return false;
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_remarks, dataWrapper, l, l2);
            }
            case COLUMN_DEF: {
                dataWrapper.setNull(12);
                return false;
            }
            case SQL_DATA_TYPE: {
                dataWrapper.setInteger(TypeUtilities.getVerboseTypeFromConciseType(this.m_currentColumnMetadata.m_sqlDataType));
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = TypeUtilities.getIntervalCodeFromConciseType(this.m_currentColumnMetadata.m_sqlDataType);
                if (0 == s) {
                    dataWrapper.setNull(4);
                } else {
                    dataWrapper.setInteger(s);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                if (TypeUtilities.isCharacterType(this.m_currentColumnMetadata.m_sqlDataType)) {
                    dataWrapper.setInteger(this.m_currentColumnMetadata.m_characterColumnLength * 4);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_currentColumnMetadata.m_ordinalPosition);
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData("YES", dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setNull(5);
                return false;
            }
            case IS_AUTOINCREMENT: {
                dataWrapper.setVarChar("");
                return false;
            }
            case IS_GENERATEDCOLUMN: {
                dataWrapper.setVarChar("");
                return false;
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columnMetadataIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentColumnMetadata = this.m_columnMetadataIterator.next();
            return true;
        }
        return false;
    }

    private void initMetadata(String string, String string2, String string3, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, StringWrapperFilter stringWrapperFilter3) throws ErrorException {
        Object object;
        Iterator<Object> iterator;
        Object object22;
        Iterator iterator2;
        LogUtilities.logFunctionEntrance(this.m_logger, string, stringWrapperFilter, stringWrapperFilter2, stringWrapperFilter3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null == string2 || string2.isEmpty()) {
            iterator2 = new ArrayList<AJSchemaMetadata>();
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                object22 = new ArrayList();
                object22 = this.m_client.getCatalogsWtihProxyApi();
                iterator = object22.iterator();
                while (iterator.hasNext()) {
                    object = (DataCatalogSummary)iterator.next();
                    AJMetadataHelperUtilities.getSchemasWithCatalogCheck(((DataCatalogSummary)object).getCatalogName(), string, this.m_client, iterator2);
                }
            } else {
                AJMetadataHelperUtilities.getSchemasWithCatalogCheck("AwsDataCatalog", string, this.m_client, iterator2);
            }
            object22 = iterator2.iterator();
            while (object22.hasNext()) {
                iterator = (AJSchemaMetadata)object22.next();
                if (!stringWrapperFilter.filter(((AJSchemaMetadata)((Object)iterator)).m_schemaName)) continue;
                arrayList.add(iterator);
            }
        } else if (null == string || string.isEmpty()) {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                iterator2 = new ArrayList();
                object22 = new ArrayList();
                object22 = this.m_client.getCatalogsWtihProxyApi();
                iterator = object22.iterator();
                while (iterator.hasNext()) {
                    object = (DataCatalogSummary)iterator.next();
                    AJMetadataHelperUtilities.getSchemasWithCatalogCheck(((DataCatalogSummary)object).getCatalogName(), string, this.m_client, iterator2);
                }
                iterator = iterator2.iterator();
                while (iterator.hasNext()) {
                    object = (AJSchemaMetadata)iterator.next();
                    if (!stringWrapperFilter.filter(((AJSchemaMetadata)object).m_schemaName)) continue;
                    arrayList.add(object);
                }
            } else {
                iterator2 = new AJSchemaMetadata("AwsDataCatalog", string2);
                arrayList.add(iterator2);
            }
        } else {
            iterator2 = new AJSchemaMetadata(string, string2);
            arrayList.add(iterator2);
        }
        if (null == string3 || string3.isEmpty() || arrayList.isEmpty()) {
            for (Object object22 : arrayList) {
                this.m_client.getColumnsMetadata(((AJSchemaMetadata)object22).m_catalogName, ((AJSchemaMetadata)object22).m_schemaName, stringWrapperFilter2, stringWrapperFilter3, this.m_columnMetadataList);
            }
        } else {
            this.m_client.getColumnsMetadataForSpecificTable(((AJSchemaMetadata)arrayList.get((int)0)).m_catalogName, ((AJSchemaMetadata)arrayList.get((int)0)).m_schemaName, string3, stringWrapperFilter2, stringWrapperFilter3, this.m_columnMetadataList);
        }
        this.m_columnMetadataIterator = this.m_columnMetadataList.listIterator(0);
    }
}

