/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.CsvClassifier;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CsvClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> DELIMITER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delimiter").build();
    private static final MarshallingInfo<String> QUOTESYMBOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteSymbol").build();
    private static final MarshallingInfo<String> CONTAINSHEADER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainsHeader").build();
    private static final MarshallingInfo<List> HEADER_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Header").build();
    private static final MarshallingInfo<Boolean> DISABLEVALUETRIMMING_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisableValueTrimming").build();
    private static final MarshallingInfo<Boolean> ALLOWSINGLECOLUMN_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSingleColumn").build();
    private static final CsvClassifierMarshaller instance = new CsvClassifierMarshaller();

    public static CsvClassifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(CsvClassifier csvClassifier, ProtocolMarshaller protocolMarshaller) {
        if (csvClassifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(csvClassifier.getName(), NAME_BINDING);
            protocolMarshaller.marshall(csvClassifier.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(csvClassifier.getLastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall(csvClassifier.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(csvClassifier.getDelimiter(), DELIMITER_BINDING);
            protocolMarshaller.marshall(csvClassifier.getQuoteSymbol(), QUOTESYMBOL_BINDING);
            protocolMarshaller.marshall(csvClassifier.getContainsHeader(), CONTAINSHEADER_BINDING);
            protocolMarshaller.marshall(csvClassifier.getHeader(), HEADER_BINDING);
            protocolMarshaller.marshall(csvClassifier.getDisableValueTrimming(), DISABLEVALUETRIMMING_BINDING);
            protocolMarshaller.marshall(csvClassifier.getAllowSingleColumn(), ALLOWSINGLECOLUMN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

