/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.CloudWatchEncryption;

@SdkInternalApi
public class CloudWatchEncryptionMarshaller {
    private static final MarshallingInfo<String> CLOUDWATCHENCRYPTIONMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchEncryptionMode").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").build();
    private static final CloudWatchEncryptionMarshaller instance = new CloudWatchEncryptionMarshaller();

    public static CloudWatchEncryptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchEncryption cloudWatchEncryption, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchEncryption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cloudWatchEncryption.getCloudWatchEncryptionMode(), CLOUDWATCHENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall(cloudWatchEncryption.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

