/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.AmazonWebServiceRequest;
import com.simba.athena.amazonaws.services.glue.model.GlueTable;
import com.simba.athena.amazonaws.services.glue.model.TransformParameters;
import com.simba.athena.amazonaws.services.glue.model.WorkerType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateMLTransformRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<GlueTable> inputRecordTables;
    private TransformParameters parameters;
    private String role;
    private String glueVersion;
    private Double maxCapacity;
    private String workerType;
    private Integer numberOfWorkers;
    private Integer timeout;
    private Integer maxRetries;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateMLTransformRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateMLTransformRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<GlueTable> getInputRecordTables() {
        return this.inputRecordTables;
    }

    public void setInputRecordTables(Collection<GlueTable> inputRecordTables) {
        if (inputRecordTables == null) {
            this.inputRecordTables = null;
            return;
        }
        this.inputRecordTables = new ArrayList<GlueTable>(inputRecordTables);
    }

    public CreateMLTransformRequest withInputRecordTables(GlueTable ... inputRecordTables) {
        if (this.inputRecordTables == null) {
            this.setInputRecordTables(new ArrayList<GlueTable>(inputRecordTables.length));
        }
        for (GlueTable ele : inputRecordTables) {
            this.inputRecordTables.add(ele);
        }
        return this;
    }

    public CreateMLTransformRequest withInputRecordTables(Collection<GlueTable> inputRecordTables) {
        this.setInputRecordTables(inputRecordTables);
        return this;
    }

    public void setParameters(TransformParameters parameters) {
        this.parameters = parameters;
    }

    public TransformParameters getParameters() {
        return this.parameters;
    }

    public CreateMLTransformRequest withParameters(TransformParameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public CreateMLTransformRequest withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setGlueVersion(String glueVersion) {
        this.glueVersion = glueVersion;
    }

    public String getGlueVersion() {
        return this.glueVersion;
    }

    public CreateMLTransformRequest withGlueVersion(String glueVersion) {
        this.setGlueVersion(glueVersion);
        return this;
    }

    public void setMaxCapacity(Double maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public Double getMaxCapacity() {
        return this.maxCapacity;
    }

    public CreateMLTransformRequest withMaxCapacity(Double maxCapacity) {
        this.setMaxCapacity(maxCapacity);
        return this;
    }

    public void setWorkerType(String workerType) {
        this.workerType = workerType;
    }

    public String getWorkerType() {
        return this.workerType;
    }

    public CreateMLTransformRequest withWorkerType(String workerType) {
        this.setWorkerType(workerType);
        return this;
    }

    public CreateMLTransformRequest withWorkerType(WorkerType workerType) {
        this.workerType = workerType.toString();
        return this;
    }

    public void setNumberOfWorkers(Integer numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
    }

    public Integer getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    public CreateMLTransformRequest withNumberOfWorkers(Integer numberOfWorkers) {
        this.setNumberOfWorkers(numberOfWorkers);
        return this;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public CreateMLTransformRequest withTimeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public CreateMLTransformRequest withMaxRetries(Integer maxRetries) {
        this.setMaxRetries(maxRetries);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateMLTransformRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateMLTransformRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateMLTransformRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getInputRecordTables() != null) {
            sb.append("InputRecordTables: ").append(this.getInputRecordTables()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getGlueVersion() != null) {
            sb.append("GlueVersion: ").append(this.getGlueVersion()).append(",");
        }
        if (this.getMaxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.getMaxCapacity()).append(",");
        }
        if (this.getWorkerType() != null) {
            sb.append("WorkerType: ").append(this.getWorkerType()).append(",");
        }
        if (this.getNumberOfWorkers() != null) {
            sb.append("NumberOfWorkers: ").append(this.getNumberOfWorkers()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getMaxRetries() != null) {
            sb.append("MaxRetries: ").append(this.getMaxRetries()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMLTransformRequest)) {
            return false;
        }
        CreateMLTransformRequest other = (CreateMLTransformRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getInputRecordTables() == null ^ this.getInputRecordTables() == null) {
            return false;
        }
        if (other.getInputRecordTables() != null && !other.getInputRecordTables().equals(this.getInputRecordTables())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getGlueVersion() == null ^ this.getGlueVersion() == null) {
            return false;
        }
        if (other.getGlueVersion() != null && !other.getGlueVersion().equals(this.getGlueVersion())) {
            return false;
        }
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null) {
            return false;
        }
        if (other.getMaxCapacity() != null && !other.getMaxCapacity().equals(this.getMaxCapacity())) {
            return false;
        }
        if (other.getWorkerType() == null ^ this.getWorkerType() == null) {
            return false;
        }
        if (other.getWorkerType() != null && !other.getWorkerType().equals(this.getWorkerType())) {
            return false;
        }
        if (other.getNumberOfWorkers() == null ^ this.getNumberOfWorkers() == null) {
            return false;
        }
        if (other.getNumberOfWorkers() != null && !other.getNumberOfWorkers().equals(this.getNumberOfWorkers())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getMaxRetries() == null ^ this.getMaxRetries() == null) {
            return false;
        }
        if (other.getMaxRetries() != null && !other.getMaxRetries().equals(this.getMaxRetries())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInputRecordTables() == null ? 0 : this.getInputRecordTables().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getGlueVersion() == null ? 0 : this.getGlueVersion().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacity() == null ? 0 : this.getMaxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getWorkerType() == null ? 0 : this.getWorkerType().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfWorkers() == null ? 0 : this.getNumberOfWorkers().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRetries() == null ? 0 : this.getMaxRetries().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateMLTransformRequest clone() {
        return (CreateMLTransformRequest)super.clone();
    }
}

