/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrack;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrackListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterBacktracksResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterBacktracksResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbClusterBacktracksResponse.getter(DescribeDbClusterBacktracksResponse::marker)).setter(DescribeDbClusterBacktracksResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBClusterBacktrack>> DB_CLUSTER_BACKTRACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterBacktracks").getter(DescribeDbClusterBacktracksResponse.getter(DescribeDbClusterBacktracksResponse::dbClusterBacktracks)).setter(DescribeDbClusterBacktracksResponse.setter(Builder::dbClusterBacktracks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterBacktracks").build(), ListTrait.builder().memberLocationName("DBClusterBacktrack").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterBacktrack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterBacktrack").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_CLUSTER_BACKTRACKS_FIELD));
    private final String marker;
    private final List<DBClusterBacktrack> dbClusterBacktracks;

    private DescribeDbClusterBacktracksResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterBacktracks = builder.dbClusterBacktracks;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbClusterBacktracks() {
        return this.dbClusterBacktracks != null && !(this.dbClusterBacktracks instanceof SdkAutoConstructList);
    }

    public final List<DBClusterBacktrack> dbClusterBacktracks() {
        return this.dbClusterBacktracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterBacktracks() ? this.dbClusterBacktracks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterBacktracksResponse)) {
            return false;
        }
        DescribeDbClusterBacktracksResponse other = (DescribeDbClusterBacktracksResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbClusterBacktracks() == other.hasDbClusterBacktracks() && Objects.equals(this.dbClusterBacktracks(), other.dbClusterBacktracks());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbClusterBacktracksResponse").add("Marker", (Object)this.marker()).add("DBClusterBacktracks", this.hasDbClusterBacktracks() ? this.dbClusterBacktracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterBacktracks": {
                return Optional.ofNullable(clazz.cast(this.dbClusterBacktracks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterBacktracksResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterBacktracksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterBacktrack> dbClusterBacktracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterBacktracksResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterBacktracks(model.dbClusterBacktracks);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<DBClusterBacktrack.Builder> getDbClusterBacktracks() {
            List<DBClusterBacktrack.Builder> result = DBClusterBacktrackListCopier.copyToBuilder(this.dbClusterBacktracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbClusterBacktracks(Collection<DBClusterBacktrack> dbClusterBacktracks) {
            this.dbClusterBacktracks = DBClusterBacktrackListCopier.copy(dbClusterBacktracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterBacktracks(DBClusterBacktrack ... dbClusterBacktracks) {
            this.dbClusterBacktracks(Arrays.asList(dbClusterBacktracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterBacktracks(Consumer<DBClusterBacktrack.Builder> ... dbClusterBacktracks) {
            this.dbClusterBacktracks(Stream.of(dbClusterBacktracks).map(c -> (DBClusterBacktrack)((DBClusterBacktrack.Builder)DBClusterBacktrack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterBacktracks(Collection<DBClusterBacktrack.BuilderImpl> dbClusterBacktracks) {
            this.dbClusterBacktracks = DBClusterBacktrackListCopier.copyFromBuilder(dbClusterBacktracks);
        }

        @Override
        public DescribeDbClusterBacktracksResponse build() {
            return new DescribeDbClusterBacktracksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClusterBacktracksResponse> {
        public Builder marker(String var1);

        public Builder dbClusterBacktracks(Collection<DBClusterBacktrack> var1);

        public Builder dbClusterBacktracks(DBClusterBacktrack ... var1);

        public Builder dbClusterBacktracks(Consumer<DBClusterBacktrack.Builder> ... var1);
    }
}

