/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathAncestorAxis;
import oracle.xml.xpath.XPathAncestorOrSelfAxis;
import oracle.xml.xpath.XPathAttributeAxis;
import oracle.xml.xpath.XPathChildAxis;
import oracle.xml.xpath.XPathDescOrSelfAxis;
import oracle.xml.xpath.XPathDescendantAxis;
import oracle.xml.xpath.XPathFollowingAxis;
import oracle.xml.xpath.XPathFollowingSiblingAxis;
import oracle.xml.xpath.XPathNamespaceAxis;
import oracle.xml.xpath.XPathParentAxis;
import oracle.xml.xpath.XPathPrecedingAxis;
import oracle.xml.xpath.XPathPrecedingSiblingAxis;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSelfAxis;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;

public class XPathAxis
implements XSLConstants {
    static XPathAxis[] axes;
    static final int NUM_AXES = 13;
    boolean forward = true;
    int axisType = 0;
    static final int ANCESTOR = 0;
    static final int ANCESTOR_SELF = 1;
    static final int ATTRIBUTE = 2;
    static final int CHILD = 3;
    static final int DESCENDANT = 4;
    static final int DESC_SELF = 5;
    static final int FOLLOWING = 6;
    static final int FOLLOWING_SIBLING = 7;
    static final int PARENT = 8;
    static final int PRECEDING = 9;
    static final int PRECEDING_SIBLING = 10;
    static final int SELF = 11;
    static final int NAMESPACE = 12;

    boolean isSame(XPathAxis xPathAxis) {
        if (this.forward != xPathAxis.forward) {
            return false;
        }
        return this.axisType == xPathAxis.axisType;
    }

    static XPathAxis getInstance(int n) {
        if (n >= 0 && n < 13) {
            return axes[n];
        }
        return null;
    }

    public static XMLNode getProceedingNode(XMLNode xMLNode) throws XSLException {
        XMLNode xMLNode2;
        if (xMLNode.getPreviousSibling() != null) {
            xMLNode2 = (XMLNode)xMLNode.getPreviousSibling();
            while (xMLNode2.hasChildNodes()) {
                xMLNode2 = (XMLNode)xMLNode2.getLastChild();
            }
        } else {
            xMLNode2 = (XMLNode)xMLNode.getParentNode();
        }
        return xMLNode2;
    }

    static OXMLSequence getAncestor(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence3 = xPathRuntimeContext.pushExprValue();
        while (oXMLSequence.next()) {
            XMLNode xMLNode = XPathSequence.nextNode(oXMLSequence);
            oXMLSequence3.reset();
            for (xMLNode = xMLNode instanceof XMLAttr ? (XMLNode)((Object)((XMLAttr)xMLNode).getOwnerElement()) : (XMLNode)xMLNode.getParentNode(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
                XPathSequence.addNode(oXMLSequence3, xMLNode);
            }
            XPathSequence.mergeOrderedList(oXMLSequence2, oXMLSequence3, false);
        }
        xPathRuntimeContext.popExprValue();
        return oXMLSequence2;
    }

    static OXMLSequence getAncestor(XMLNode xMLNode, OXMLSequence oXMLSequence) throws XSLException, XQException {
        for (xMLNode = xMLNode instanceof XMLAttr ? (XMLNode)((Object)((XMLAttr)xMLNode).getOwnerElement()) : (XMLNode)xMLNode.getParentNode(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            XPathSequence.addNode(oXMLSequence, xMLNode);
        }
        return oXMLSequence;
    }

    static void getDescNodeList(XPathStep xPathStep, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        XPathAxis xPathAxis = xPathStep.axisClass;
        boolean bl = xPathAxis.isForward();
        OXMLSequence oXMLSequence2 = xPathRuntimeContext.pushExprValue();
        OXMLSequence oXMLSequence3 = xPathRuntimeContext.pushExprValue();
        OXMLSequence oXMLSequence4 = xPathRuntimeContext.pushExprValue();
        while (oXMLSequence.next()) {
            XMLNode xMLNode;
            XMLNode xMLNode2 = xMLNode = XPathSequence.nextNode(oXMLSequence);
            XMLNode xMLNode3 = xMLNode;
            if (!(xMLNode3 instanceof XMLElement) || !xMLNode3.hasChildNodes()) {
                oXMLSequence.reset();
                XPathSequence.concatSequence(oXMLSequence, oXMLSequence3);
                xPathRuntimeContext.popExprValue(3);
                return;
            }
            oXMLSequence2.reset();
            oXMLSequence4.reset();
            XPathSequence.addNode(oXMLSequence4, xMLNode);
            xPathAxis.getNodeList(xPathStep, xPathRuntimeContext);
            XPathSequence.mergeOrderedList(oXMLSequence2, oXMLSequence4, bl);
            while (xMLNode2 != null) {
                xMLNode2 = (XMLNode)xMLNode.getFirstChild();
                if (xMLNode2 == null) {
                    xMLNode2 = (XMLNode)xMLNode.getNextSibling();
                }
                if (xMLNode2 == null) {
                    xMLNode = (XMLNode)xMLNode.getParentNode();
                    while (!xMLNode.isSameNode(xMLNode3) && (xMLNode2 = (XMLNode)xMLNode.getNextSibling()) == null) {
                        xMLNode = (XMLNode)xMLNode.getParentNode();
                    }
                }
                if (xMLNode2 == null) continue;
                oXMLSequence4.reset();
                XPathSequence.addNode(oXMLSequence4, xMLNode2);
                xPathAxis.getNodeList(xPathStep, xPathRuntimeContext);
                XPathSequence.mergeOrderedList(oXMLSequence2, oXMLSequence4, bl);
                xMLNode = xMLNode2;
            }
            XPathSequence.mergeOrderedList(oXMLSequence3, oXMLSequence2, bl);
        }
        oXMLSequence.reset();
        XPathSequence.concatSequence(oXMLSequence, oXMLSequence3);
        xPathRuntimeContext.popExprValue(3);
    }

    final int getAxisType() {
        return this.axisType;
    }

    final boolean isForward() {
        return this.forward;
    }

    void getNodeList(XPathStep xPathStep, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
    }

    static {
        if (axes == null) {
            axes = new XPathAxis[13];
            XPathAxis.axes[0] = new XPathAncestorAxis();
            XPathAxis.axes[1] = new XPathAncestorOrSelfAxis();
            XPathAxis.axes[2] = new XPathAttributeAxis();
            XPathAxis.axes[3] = new XPathChildAxis();
            XPathAxis.axes[4] = new XPathDescendantAxis();
            XPathAxis.axes[5] = new XPathDescOrSelfAxis();
            XPathAxis.axes[6] = new XPathFollowingAxis();
            XPathAxis.axes[7] = new XPathFollowingSiblingAxis();
            XPathAxis.axes[8] = new XPathParentAxis();
            XPathAxis.axes[9] = new XPathPrecedingAxis();
            XPathAxis.axes[10] = new XPathPrecedingSiblingAxis();
            XPathAxis.axes[11] = new XPathSelfAxis();
            XPathAxis.axes[12] = new XPathNamespaceAxis();
            block3: for (int i = 0; i < 13; ++i) {
                XPathAxis.axes[i].axisType = i;
                switch (i) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 10: {
                        XPathAxis.axes[i].forward = false;
                        continue block3;
                    }
                    default: {
                        XPathAxis.axes[i].forward = true;
                    }
                }
            }
        }
    }
}

