/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.xml.common.format.IntegerFormatter;

public abstract class DateTimeFormatter<E extends Exception>
extends IntegerFormatter<E> {
    private static String[] WeekDayShort = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] WeekDayFull = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static String[] YearMonthShort = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String[] YearMonthFull = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String MilitaryTimeZones = "YXWVUTSRQPONZABCDEFGHIKLM";
    private static int MilitaryTimeZonesZulu = MilitaryTimeZones.indexOf(90);

    @Override
    protected abstract E createInvalidPictureStringException(String var1);

    protected abstract E createComponentNotAvailableException(String var1);

    @Override
    protected abstract E notSupported(String var1);

    @Override
    boolean ignoreWhitespace() {
        return true;
    }

    public String format(Calendar calendar, String string, String string2, String string3, String string4, int n, boolean bl) throws E {
        StringBuilder stringBuilder = new StringBuilder();
        PictureParseString pictureParseString = new PictureParseString(string);
        if (string2 != null && !string2.toLowerCase().equals("en")) {
            stringBuilder = stringBuilder.append("[Language: en]");
        }
        boolean bl2 = false;
        if (string3 != null) {
            if (string3.equals("ISO")) {
                calendar = (GregorianCalendar)calendar.clone();
                calendar.setFirstDayOfWeek(2);
                calendar.setMinimalDaysInFirstWeek(4);
                bl2 = true;
            } else if (!(string3.equals("AD") || string3.equals("BC") || string3.toLowerCase().equals("gregorian"))) {
                stringBuilder = stringBuilder.append("[Calendar: AD]");
            }
        }
        boolean bl3 = true;
        while (bl3) {
            bl3 = pictureParseString.nextLiteralString(stringBuilder);
        }
        while (pictureParseString.nextVarMarker()) {
            int n2 = pictureParseString.getComponentSpecifier();
            int n3 = pictureParseString.getMinWidth();
            int n4 = pictureParseString.getMaxWidth();
            if (n4 != -1 && n3 > n4) {
                throw this.createInvalidPictureStringException(string);
            }
            switch (n2) {
                case 89: {
                    int n5;
                    int n6;
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("Y");
                    }
                    int n7 = calendar.get(1);
                    if (pictureParseString.isDecimalDigitPattern()) {
                        if (n4 != -1) {
                            n7 = this.truncateYear(n7, n4);
                        } else {
                            n6 = 0;
                            n5 = pictureParseString.p1StartIdx;
                            while (n5 < pictureParseString.p1EndIdx) {
                                int n8 = string.codePointAt(n5);
                                n5 += Character.charCount(n8);
                                if (!Character.isDigit(n8) && n8 != 35) continue;
                                ++n6;
                            }
                            if (n6 > 1) {
                                n7 = this.truncateYear(n7, n6);
                            }
                        }
                    } else if (!pictureParseString.hasFirstPresentationModifier() && n4 != -1) {
                        n7 = this.truncateYear(n7, n4);
                    }
                    this.formatInteger(n7, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 77: {
                    String string5;
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("M");
                    }
                    int n7 = calendar.get(2) + 1;
                    String string6 = string5 = n4 != -1 && n4 < 8 ? YearMonthShort[n7] : this.YearMonthFull[n7];
                    if (pictureParseString.firstModifierIs("N")) {
                        stringBuilder.append(this.upper(string5));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("n")) {
                        stringBuilder.append(this.lower(string5));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("Nn")) {
                        stringBuilder.append(string5);
                        break;
                    }
                    this.formatInteger(n7, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 68: {
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("D");
                    }
                    int n7 = calendar.get(5);
                    this.formatInteger(n7, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 100: {
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("d");
                    }
                    int n6 = calendar.get(6);
                    this.formatInteger(n6, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 70: {
                    String string7;
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("F");
                    }
                    int n5 = calendar.get(7);
                    if (bl2) {
                        n5 = n5 == 1 ? 7 : --n5;
                    }
                    String string8 = string7 = n4 != -1 && n4 < 8 ? WeekDayShort[n5] : WeekDayFull[n5];
                    if (pictureParseString.firstModifierIs("N")) {
                        stringBuilder.append(this.upper(string7));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("n") || !pictureParseString.hasFirstPresentationModifier()) {
                        stringBuilder.append(this.lower(string7));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("Nn")) {
                        stringBuilder.append(string7);
                        break;
                    }
                    this.formatInteger(n5, string, pictureParseString, "n", stringBuilder);
                    break;
                }
                case 87: {
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("W");
                    }
                    int n5 = calendar.get(3);
                    this.formatInteger(n5, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 119: {
                    int n9;
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("w");
                    }
                    int n10 = calendar.get(4);
                    if (n10 == 0) {
                        n9 = 0;
                        while (n10 == 0) {
                            ++n9;
                            calendar.add(5, -1);
                            n10 = calendar.get(4);
                        }
                        calendar.add(5, n9);
                    }
                    this.formatInteger(n10, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 72: {
                    if (n == 2) {
                        throw this.createComponentNotAvailableException("H");
                    }
                    int n9 = calendar.get(11);
                    this.formatInteger(n9, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 104: {
                    if (n == 2) {
                        throw this.createComponentNotAvailableException("h");
                    }
                    int n11 = calendar.get(10);
                    if (n11 == 0) {
                        n11 = 12;
                    }
                    this.formatInteger(n11, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 80: {
                    if (n == 2) {
                        throw this.createComponentNotAvailableException("P");
                    }
                    int n12 = calendar.get(9);
                    if (pictureParseString.firstModifierIs("N")) {
                        stringBuilder.append(n12 == 0 ? "AM" : "PM");
                        break;
                    }
                    if (pictureParseString.firstModifierIs("Nn")) {
                        stringBuilder.append(n12 == 0 ? "Am" : "Pm");
                        break;
                    }
                    stringBuilder.append(n12 == 0 ? "am" : "pm");
                    break;
                }
                case 109: {
                    if (n == 2) {
                        throw this.createComponentNotAvailableException("m");
                    }
                    int n12 = calendar.get(12);
                    this.formatInteger(n12, string, pictureParseString, "01", stringBuilder);
                    break;
                }
                case 115: {
                    if (n == 2) {
                        throw this.createComponentNotAvailableException("s");
                    }
                    int n13 = calendar.get(13);
                    this.formatInteger(n13, string, pictureParseString, "01", stringBuilder);
                    break;
                }
                case 102: {
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    if (n == 2) {
                        throw this.createComponentNotAvailableException("f");
                    }
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = pictureParseString.p1StartIdx != -1 ? 1 : 0;
                    for (n17 = pictureParseString.p1StartIdx; n17 < pictureParseString.p1EndIdx; n17 += Character.charCount(n18)) {
                        n18 = string.codePointAt(n17);
                        if (DateTimeFormatter.isWhitespace(n18)) continue;
                        if (Character.isDigit(n18)) {
                            if (n20 > 0) {
                                throw this.createInvalidPictureStringException(string);
                            }
                            ++n19;
                            continue;
                        }
                        if (n18 == 35) {
                            if (n19 == 0) {
                                throw this.createInvalidPictureStringException(string);
                            }
                            ++n20;
                            continue;
                        }
                        throw this.createInvalidPictureStringException(string);
                    }
                    if (n4 == -1 && n21 != 0) {
                        n4 = n19 + n20;
                    }
                    if (n3 == -1 && n21 != 0) {
                        n3 = n19;
                    }
                    n17 = calendar.get(14);
                    n18 = 3;
                    if (n4 == 2) {
                        BigDecimal bigDecimal = BigDecimal.valueOf(n17).movePointLeft(1);
                        n17 = bigDecimal.setScale(0, RoundingMode.HALF_EVEN).intValue();
                        n18 = 2;
                    } else if (n4 == 1) {
                        BigDecimal bigDecimal = BigDecimal.valueOf(n17).movePointLeft(2);
                        n17 = bigDecimal.setScale(0, RoundingMode.HALF_EVEN).intValue();
                        n18 = 1;
                    }
                    int n22 = 0;
                    int n23 = this.getZero(string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx);
                    String string9 = String.valueOf(n17);
                    for (n16 = 0; n16 < n18 - string9.length(); ++n16) {
                        stringBuilder.appendCodePoint(n23);
                        ++n22;
                    }
                    for (n16 = string9.length(); n16 > 0 && string9.charAt(n16 - 1) == '0'; --n16) {
                    }
                    for (n15 = 0; n15 < n16; ++n15) {
                        n14 = string9.codePointAt(n15);
                        stringBuilder.appendCodePoint(n23 + Character.getNumericValue(n14));
                        ++n22;
                    }
                    for (n15 = n3 - n22; n15 > 0; --n15) {
                        stringBuilder.appendCodePoint(n23);
                    }
                    break;
                }
                case 122: {
                    stringBuilder.append("GMT");
                }
                case 90: {
                    int n24;
                    int n14;
                    int n21;
                    int n19 = calendar.get(15);
                    if (pictureParseString.firstModifierIs("N")) {
                        TimeZone timeZone = calendar.getTimeZone();
                        n21 = timeZone.inDaylightTime(calendar.getTime());
                        stringBuilder.append(timeZone.getDisplayName(n21 != 0, 0));
                        break;
                    }
                    if (!bl) {
                        if (!pictureParseString.firstModifierIs("Z")) break;
                        stringBuilder.append("J");
                        break;
                    }
                    if (n19 == 0 && pictureParseString.isTraditional() && pictureParseString.firstModifierIs("Z")) {
                        stringBuilder.append("Z");
                        break;
                    }
                    int n20 = n19 / 3600000;
                    n21 = (n19 - n20 * 60 * 60 * 1000) / 60000;
                    int n17 = Math.abs(n21);
                    int n18 = Math.abs(n20);
                    int n22 = n18 * 100 + n17;
                    if (pictureParseString.firstModifierIs("Z")) {
                        if (n21 == 0 && n18 <= 12) {
                            stringBuilder.append(MilitaryTimeZones.charAt(n20 + MilitaryTimeZonesZulu));
                            break;
                        }
                        this.writeSign(stringBuilder, n19);
                        this.defaultTimeZone(stringBuilder, n22);
                        break;
                    }
                    if (n19 == 0 && pictureParseString.isTraditional()) {
                        stringBuilder.append("Z");
                        break;
                    }
                    this.writeSign(stringBuilder, n19);
                    if (!pictureParseString.hasFirstPresentationModifier()) {
                        this.defaultTimeZone(stringBuilder, n22);
                        break;
                    }
                    int n23 = 0;
                    int n25 = 0;
                    int n16 = -1;
                    int n15 = -1;
                    for (n14 = pictureParseString.p1StartIdx; n14 < pictureParseString.p1EndIdx; n14 += Character.charCount(n24)) {
                        n24 = string.codePointAt(n14);
                        if (Character.isDigit(n24)) {
                            if (n15 == -1) {
                                n15 = n24 - Character.getNumericValue(n24);
                            } else if (n15 != n24 - Character.getNumericValue(n24)) {
                                throw this.createInvalidPictureStringException(string);
                            }
                            if (n16 == -1) {
                                ++n23;
                                continue;
                            }
                            ++n25;
                            continue;
                        }
                        if (DateTimeFormatter.isGroupingSeparator(n24) && n16 == -1) {
                            n16 = n14;
                            continue;
                        }
                        if (DateTimeFormatter.isWhitespace(n24)) continue;
                        n23 = -1;
                        break;
                    }
                    if (n23 == -1) {
                        throw this.createInvalidPictureStringException(string);
                    }
                    if (n16 == -1) {
                        if (n23 <= 2) {
                            this.formatPattern(n18, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx - 1, stringBuilder);
                            if (n17 == 0) break;
                            stringBuilder.append(":");
                            this.formatPattern(n17, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx - 1, stringBuilder);
                            break;
                        }
                        this.formatPattern(n22, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx - 1, stringBuilder);
                        break;
                    }
                    if (n25 == -1) {
                        this.defaultTimeZone(stringBuilder, n22);
                        break;
                    }
                    this.formatPattern(n18, string, pictureParseString.p1StartIdx, n16 - 1, stringBuilder);
                    stringBuilder.appendCodePoint(string.codePointAt(n16));
                    this.formatPattern(n17, string, n16 + 1, pictureParseString.p1EndIdx - 1, stringBuilder);
                    break;
                }
                case 67: {
                    throw this.notSupported(string);
                }
                case 69: {
                    if (n < 2) {
                        throw this.createComponentNotAvailableException("E");
                    }
                    int n23 = calendar.get(0);
                    if (n23 == 1) {
                        stringBuilder.append("AD");
                        break;
                    }
                    stringBuilder.append("BC");
                    break;
                }
                default: {
                    throw this.createInvalidPictureStringException(string);
                }
            }
            bl3 = true;
            while (bl3) {
                bl3 = pictureParseString.nextLiteralString(stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    private void defaultTimeZone(StringBuilder stringBuilder, int n) throws E {
        this.formatPattern(n, "01:01", 0, 4, stringBuilder);
    }

    private void writeSign(StringBuilder stringBuilder, int n) {
        if (n < 0) {
            stringBuilder.append("-");
        } else {
            stringBuilder.append("+");
        }
    }

    private String upper(String string) {
        return string.toUpperCase(Locale.US);
    }

    private String lower(String string) {
        return string.toLowerCase(Locale.US);
    }

    private void formatInteger(int n, String string, PictureParseString pictureParseString, String string2, StringBuilder stringBuilder) throws E {
        if (pictureParseString.hasFirstPresentationModifier()) {
            this.formatInteger(n, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx, pictureParseString.isOrdinal(), pictureParseString.getMinWidth(), pictureParseString.getMaxWidth(), stringBuilder);
        } else {
            this.formatInteger(n, string2, 0, string2.length(), false, pictureParseString.getMinWidth(), pictureParseString.getMaxWidth(), stringBuilder);
        }
    }

    private void formatInteger(int n, String string, int n2, int n3, boolean bl, int n4, int n5, StringBuilder stringBuilder) throws E {
        int n6 = this.charsBetween(n2, n3, string);
        int n7 = stringBuilder.length();
        int n8 = string.codePointAt(n2);
        switch (n8) {
            case 65: {
                if (n6 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatNumberA(n, true, stringBuilder);
                this.pad(n7, n4, stringBuilder);
                return;
            }
            case 97: {
                if (n6 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatNumberA(n, false, stringBuilder);
                this.pad(n7, n4, stringBuilder);
                return;
            }
            case 73: {
                if (n6 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatRoman(n, true, stringBuilder);
                this.pad(n7, n4, stringBuilder);
                return;
            }
            case 105: {
                if (n6 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatRoman(n, false, stringBuilder);
                this.pad(n7, n4, stringBuilder);
                return;
            }
            case 87: {
                if (n6 == 2 && string.charAt(n2 + 1) == 'w') {
                    this.formatNumberName(n, bl, null, stringBuilder);
                } else if (n6 == 1) {
                    this.formatNumberName(n, bl, true, stringBuilder);
                } else {
                    throw this.createInvalidPictureStringException(string);
                }
                this.pad(n7, n4, stringBuilder);
                return;
            }
            case 119: {
                if (n6 != 1) {
                    throw this.createInvalidPictureStringException(string);
                }
                this.formatNumberName(n, bl, false, stringBuilder);
                this.pad(n7, n4, stringBuilder);
                return;
            }
        }
        if (!DateTimeFormatter.isDigitPattern(string, n2, n3)) {
            throw this.createInvalidPictureStringException(string);
        }
        if (n4 == -1) {
            this.formatPattern(n, string, n2, n3 - 1, stringBuilder);
            if (bl) {
                DateTimeFormatter.formatNumberOrdinal(n, stringBuilder);
            }
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder(n3 - n2);
        int n9 = this.getZero(string, n2, n3);
        for (int i = n3 - 1; i >= n2; --i) {
            int n10 = string.charAt(i);
            if (i > 0 && Character.isSurrogatePair((char)n10, string.charAt(i - 1))) {
                n10 = string.codePointAt(--i);
            }
            if (Character.isDigit(n10)) {
                --n4;
                stringBuilder2.appendCodePoint(n10);
                continue;
            }
            if (n10 == 35 && n4 > 0) {
                --n4;
                stringBuilder2.appendCodePoint(n9);
                continue;
            }
            stringBuilder2.appendCodePoint(n10);
        }
        while (n4 > 0) {
            stringBuilder2.appendCodePoint(n9);
            --n4;
        }
        stringBuilder2.reverse();
        this.formatPattern(n, stringBuilder2.toString(), 0, stringBuilder2.length() - 1, stringBuilder);
        if (bl) {
            DateTimeFormatter.formatNumberOrdinal(n, stringBuilder);
        }
    }

    private int getZero(String string, int n, int n2) {
        int n3;
        int n4 = 48;
        for (int i = n; i < n2; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            if (!Character.isDigit(n3)) continue;
            n4 = n3 - Character.getNumericValue(n3);
            break;
        }
        return n4;
    }

    private void pad(int n, int n2, StringBuilder stringBuilder) {
        if (n2 == -1) {
            return;
        }
        int n3 = stringBuilder.length() - n;
        n2 -= n3;
        while (n2 > 0) {
            stringBuilder.append(" ");
            --n2;
        }
    }

    private int charsBetween(int n, int n2, String string) {
        int n3 = 0;
        while (n < n2) {
            int n4 = string.codePointAt(n);
            if (!Character.isWhitespace(n4)) {
                ++n3;
            }
            n += Character.charCount(n4);
        }
        return n3;
    }

    private static boolean isDigitPattern(String string, int n, int n2) {
        int n3;
        for (int i = n; i < n2; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            if (!Character.isDigit(n3)) continue;
            return true;
        }
        return false;
    }

    private int truncateYear(int n, int n2) {
        if (n2 == Integer.MAX_VALUE) {
            return n;
        }
        int n3 = 1;
        while (n2 > 0) {
            n3 *= 10;
            --n2;
        }
        return n % n3;
    }

    class PictureParseString {
        String pic;
        int index;
        int componentSpecifierIdx;
        int p1StartIdx;
        int p1EndIdx;
        int p2Idx;
        int endOfModifiers;
        int minWidthIdx;
        int maxWidthIdx;

        PictureParseString(String string) {
            this.pic = string;
            this.index = 0;
            this.reset();
        }

        private void reset() {
            this.componentSpecifierIdx = -1;
            this.endOfModifiers = -1;
            this.p1StartIdx = -1;
            this.p1EndIdx = -1;
            this.p2Idx = -1;
            this.minWidthIdx = -1;
            this.maxWidthIdx = -1;
        }

        boolean nextLiteralString(StringBuilder stringBuilder) {
            int n;
            if (this.index == this.pic.length()) {
                return false;
            }
            for (n = this.index; n < this.pic.length() && this.pic.codePointAt(n) != 91 && this.pic.codePointAt(n) != 93; n += Character.charCount(this.pic.codePointAt(n))) {
            }
            stringBuilder.append(this.pic, this.index, n);
            this.index = n;
            if (this.index == this.pic.length()) {
                return true;
            }
            int n2 = this.pic.codePointAt(n);
            if (n < this.pic.length() - 1 && this.pic.codePointAt(n + 1) == n2) {
                stringBuilder.appendCodePoint(n2);
                this.index += 2;
                return true;
            }
            return false;
        }

        int getComponentSpecifier() {
            return this.pic.codePointAt(this.componentSpecifierIdx);
        }

        boolean hasFirstPresentationModifier() {
            return this.p1StartIdx != -1;
        }

        public boolean isDecimalDigitPattern() {
            if (this.p1StartIdx == -1) {
                return false;
            }
            return DateTimeFormatter.isDigitPattern(this.pic, this.p1StartIdx, this.p1EndIdx);
        }

        boolean isOrdinal() {
            return this.p2Idx != -1 && this.pic.charAt(this.p2Idx) == 'o';
        }

        boolean isTraditional() {
            return this.p2Idx != -1 && this.pic.charAt(this.p2Idx) == 't';
        }

        public int getMaxWidth() throws Exception {
            if (this.maxWidthIdx == -1) {
                return -1;
            }
            String string = this.pic.substring(this.maxWidthIdx, this.index - 1);
            if (string.equals("*")) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw DateTimeFormatter.this.createInvalidPictureStringException(string);
            }
        }

        public int getMinWidth() throws Exception {
            if (this.minWidthIdx == -1) {
                return -1;
            }
            int n = this.maxWidthIdx == -1 ? this.index - 1 : this.maxWidthIdx - 1;
            String string = this.pic.substring(this.minWidthIdx, n);
            if (string.equals("*")) {
                return -1;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                Object e = DateTimeFormatter.this.createInvalidPictureStringException(this.pic);
                ((Throwable)e).initCause(exception);
                throw e;
            }
        }

        public boolean firstModifierIs(String string) {
            if (this.p1StartIdx == -1) {
                return false;
            }
            if (this.p1EndIdx - this.p1StartIdx != string.length()) {
                return false;
            }
            for (int i = this.p1StartIdx; i < this.p1EndIdx; ++i) {
                if (this.pic.charAt(i) == string.charAt(i - this.p1StartIdx)) continue;
                return false;
            }
            return true;
        }

        boolean nextVarMarker() throws Exception {
            int n;
            this.reset();
            this.skipSpace();
            if (this.index >= this.pic.length()) {
                return false;
            }
            ++this.index;
            this.skipSpace();
            this.componentSpecifierIdx = this.index++;
            this.skipSpace();
            boolean bl = false;
            while (this.index < this.pic.length()) {
                n = this.pic.codePointAt(this.index);
                if (n == 93) {
                    if (this.endOfModifiers == -1) {
                        this.endOfModifiers = this.index;
                    }
                    ++this.index;
                    bl = true;
                    break;
                }
                if (n == 44) {
                    this.endOfModifiers = this.index;
                    this.minWidthIdx = this.index + 1;
                    this.maxWidthIdx = -1;
                } else if (n == 45 && this.minWidthIdx != -1) {
                    this.maxWidthIdx = this.index + 1;
                }
                this.index += Character.charCount(n);
            }
            if (!bl) {
                throw DateTimeFormatter.this.createInvalidPictureStringException(this.pic);
            }
            while (IntegerFormatter.isWhitespace(this.pic.charAt(this.endOfModifiers - 1))) {
                --this.endOfModifiers;
            }
            n = DateTimeFormatter.this.charsBetween(this.componentSpecifierIdx + 1, this.endOfModifiers, this.pic);
            if (n == 1) {
                this.p1StartIdx = this.componentSpecifierIdx + 1;
                this.p1EndIdx = this.endOfModifiers;
            } else if (n > 1) {
                switch (this.pic.charAt(this.endOfModifiers - 1)) {
                    case 'a': 
                    case 'c': 
                    case 'o': 
                    case 't': {
                        this.p2Idx = this.endOfModifiers - 1;
                        this.p1StartIdx = this.componentSpecifierIdx + 1;
                        this.p1EndIdx = this.p2Idx;
                        break;
                    }
                    default: {
                        this.p1StartIdx = this.componentSpecifierIdx + 1;
                        this.p1EndIdx = this.endOfModifiers;
                    }
                }
            }
            return true;
        }

        private void skipSpace() {
            while (this.index < this.pic.length() && IntegerFormatter.isWhitespace(this.pic.charAt(this.index))) {
                ++this.index;
            }
        }
    }
}

