/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

public enum NzType {
    NZ_BOOL(12),
    NZ_BINARY(14),
    NZ_BYTEINT(13),
    NZ_INTEGER(3),
    NZ_SMALLINT(19),
    NZ_BIGINT(20),
    NZ_FLOAT(4),
    NZ_DOUBLE(2),
    NZ_NUMERIC(7),
    NZ_CHAR(15),
    NZ_VARCHAR(16),
    NZ_NCHAR(25),
    NZ_NVARCHAR(26),
    NZ_VARFIXEDCHAR(21),
    NZ_GEOMETRY(22),
    NZ_VARBINARY(23),
    NZ_DATE(6),
    NZ_TIME(8),
    NZ_TIMESTAMP(9),
    NZ_INTERVAL(10),
    NZ_TIMEZONE(11),
    NZ_UNKNOWN(18);

    private int type;

    private NzType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static long uint32ByteArrAsInt64(byte[] arr) {
        return NzType.uint32ByteArrAsInt64(arr, 0);
    }

    public static long uint32ByteArrAsInt64(byte[] arr, int offset) {
        long i = 0L;
        for (int k = 3; k >= 0; --k) {
            i = i << 8 | (long)(0xFF & arr[k + offset]);
        }
        return i;
    }

    public static short byteArrToInt16(byte[] arr) {
        int i = 0;
        for (int k = 1; k >= 0; --k) {
            i = i << 8 | 0xFF & arr[k];
        }
        return (short)i;
    }

    public static int byteArrToInt32(byte[] arr) {
        return NzType.byteArrToInt32(arr, 0);
    }

    public static int byteArrToInt32(byte[] arr, int offset) {
        int i = 0;
        for (int k = 3; k >= 0; --k) {
            i = i << 8 | 0xFF & arr[k + offset];
        }
        return i;
    }

    public static long byteArrToInt64(byte[] arr) {
        return NzType.byteArrToInt64(arr, 0);
    }

    public static long byteArrToInt64(byte[] arr, int offset) {
        long i = 0L;
        for (int k = 7; k >= 0; --k) {
            i = i << 8 | (long)(0xFF & arr[k + offset]);
        }
        return i;
    }

    public static String byteArrToHexString(byte[] arr) {
        StringBuffer hexBuffer = new StringBuffer(arr.length * 2 + 3);
        hexBuffer.append('X');
        hexBuffer.append('\'');
        for (int i = 0; i < arr.length; ++i) {
            int a = arr[i] & 0xFF;
            if (a < 16) {
                hexBuffer.append('0');
            }
            hexBuffer.append(Integer.toHexString(a));
        }
        hexBuffer.append('\'');
        return hexBuffer.toString().toUpperCase();
    }

    public static byte[] hexStringToByteArr(String str) {
        int strlen = str.length();
        byte[] byteArr = new byte[(strlen - 3) / 2];
        for (int i = 2; i < strlen - 1; i += 2) {
            byteArr[i / 2 - 1] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return byteArr;
    }

    public static NzType getNzType(int type) {
        NzType[] types;
        for (NzType _type : types = NzType.values()) {
            if (_type.type != type) continue;
            return _type;
        }
        return NZ_UNKNOWN;
    }
}

