/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import org.netezza.internal.NzType;

public class NzNumeric {
    public static final int MAX_NUMERIC_DIGIT_COUNT = 4;
    public static final int NUMERIC_DIGIT_SIZE = 4;
    public static final int NUMERIC_MAX_PRECISION = 38;
    public static final long HI32_MASK = -4294967296L;

    public static int getNumParts(int prec) {
        int num_parts = prec <= 9 ? 1 : (prec <= 18 ? 2 : 4);
        return num_parts;
    }

    public static String decodeNumeric(byte[] data, int prec, int scale, int count) {
        int i;
        int num_parts = NzNumeric.getNumParts(prec);
        long[] tempBuf = new long[4];
        for (int indx = 0; indx < num_parts; ++indx) {
            tempBuf[indx] = NzType.uint32ByteArrAsInt64(data, indx * 4);
        }
        int leadDigit = (tempBuf[0] & Integer.MIN_VALUE) != 0L ? -1 : 0;
        long[] digit = new long[4];
        for (i = 0; i < 4 - count; ++i) {
            digit[i] = leadDigit;
        }
        int j = 0;
        while (i < 4) {
            digit[i++] = tempBuf[j++];
        }
        System.arraycopy(digit, 0, tempBuf, 0, 4);
        boolean negative = NzNumeric.isNegative(tempBuf);
        if (negative && NzNumeric.negate_128(tempBuf)) {
            return null;
        }
        int[] unbiasedDigits = new int[38];
        StringBuffer sb = new StringBuffer(38);
        for (i = 0; i < 38; ++i) {
            unbiasedDigits[38 - i - 1] = NzNumeric.div10_128(tempBuf, tempBuf);
        }
        boolean bLeadingZeroes = true;
        for (i = 0; i < 38; ++i) {
            if (i < 38 - scale - 1 && bLeadingZeroes && unbiasedDigits[i] == 0) continue;
            bLeadingZeroes = false;
            sb.append((char)(unbiasedDigits[i] + 48));
        }
        int len = sb.length();
        StringBuffer result = new StringBuffer(len + 2);
        if (negative) {
            result.append('-');
        }
        if (scale != 0) {
            int iplaces = len - scale;
            result.append(sb.substring(0, iplaces));
            result.append('.');
            result.append(sb.substring(iplaces, iplaces + scale));
        } else {
            result.append(sb);
        }
        return result.toString();
    }

    static int div10_128(long[] numerator, long[] quotient) {
        int remainder = 0;
        for (int i = 0; i < 4; ++i) {
            long work = numerator[i] + ((long)remainder << 32);
            if (work != 0L) {
                quotient[i] = work / 10L;
                remainder = (int)(work % 10L);
                continue;
            }
            quotient[i] = 0L;
            remainder = 0;
        }
        return remainder;
    }

    static boolean isNegative(long[] data) {
        return ((int)data[0] & Integer.MIN_VALUE) != 0;
    }

    static boolean negate_128(long[] data) {
        for (int i = 0; i < 4; ++i) {
            data[i] = (long)(~((int)data[i])) & 0xFFFFFFFFL;
        }
        return NzNumeric.inc_128(data);
    }

    static boolean inc_128(long[] data) {
        int i = 4;
        boolean negative = NzNumeric.isNegative(data);
        boolean carry = true;
        while (i != 0 && carry) {
            long work;
            carry = ((work = data[--i] + 1L) & 0xFFFFFFFF00000000L) != 0L;
            data[i] = work & 0xFFFFFFFFL;
        }
        if (!negative) {
            return NzNumeric.isNegative(data);
        }
        return false;
    }
}

