/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.dsi.core.utilities.ClientInfoData;
import com.vertica.dsi.core.utilities.PropertyUtilities;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc4.S4MetaDataProxy;
import com.vertica.jdbc.jdbc4.utilities.ClientInfoPropertiesMetadataSource;
import com.vertica.jdbc.jdbc4.utilities.ClientInfoPropertiesResultSet;
import com.vertica.jdbc.jdbc4.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S4DatabaseMetaData
extends SDatabaseMetaData {
    protected static final Map<Long, String> STRING_FUNCTION_NAME_MAP = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -8873467930715133555L;
        {
            this.put(0L, null);
            this.put(8192L, "ASCII");
            this.put(524288L, "BIT_LENGTH");
            this.put(16384L, "CHAR");
            this.put(0x100000L, "CHAR_LENGTH");
            this.put(0x200000L, "CHARACTER_LENGTH");
            this.put(1L, "CONCAT");
            this.put(32768L, "DIFFERENCE");
            this.put(2L, "INSERT");
            this.put(64L, "LCASE");
            this.put(4L, "LEFT");
            this.put(16L, "LENGTH");
            this.put(32L, "LOCATE");
            this.put(65536L, "LOCATE2");
            this.put(8L, "LTRIM");
            this.put(0x400000L, "OCTET_LENGTH");
            this.put(0x800000L, "POSITION");
            this.put(128L, "REPEAT");
            this.put(256L, "REPLACE");
            this.put(512L, "RIGHT");
            this.put(1024L, "RTRIM");
            this.put(131072L, "SOUNDEX");
            this.put(262144L, "SPACE");
            this.put(2048L, "SUBSTRING");
            this.put(4096L, "UCASE");
        }
    };
    private static final Map<Long, String> TIME_FUNCTION_NAME_MAP = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = 3646797488007220487L;
        {
            this.put(0L, null);
            this.put(2L, "CURDATE");
            this.put(131072L, "CURRENT_DATE");
            this.put(262144L, "CURRENT_TIME");
            this.put(524288L, "CURRENT_TIMESTAMP");
            this.put(512L, "CURTIME");
            this.put(32768L, "DAYNAME");
            this.put(4L, "DAYOFMONTH");
            this.put(8L, "DAYOFWEEK");
            this.put(16L, "DAYOFYEAR");
            this.put(0x100000L, "EXTRACT");
            this.put(1024L, "HOUR");
            this.put(2048L, "MINUTE");
            this.put(32L, "MONTH");
            this.put(65536L, "MONTHNAME");
            this.put(1L, "NOW");
            this.put(64L, "QUARTER");
            this.put(4096L, "SECOND");
            this.put(8192L, "TIMESTAMPADD");
            this.put(16384L, "TIMESTAMPDIFF");
            this.put(128L, "WEEK");
            this.put(256L, "YEAR");
        }
    };
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION = 0;

    public S4DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(37);
            return 1L == (long)n || 0L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.JDBC_4);
            S4MetaDataProxy s4MetaDataProxy = new S4MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s4MetaDataProxy);
            return s4MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        try {
            S4MetaDataProxy s4MetaDataProxy = new S4MetaDataProxy(this, null, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s4MetaDataProxy);
            return s4MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createUnorderedMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.NONE);
            S4MetaDataProxy s4MetaDataProxy = new S4MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s4MetaDataProxy);
            return s4MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Map<String, ClientInfoData> map = this.m_parentConnection.getConnection().getClientInfoProperties();
        return new ClientInfoPropertiesResultSet((SStatement)this.m_parentConnection.createStatement(), new ClientInfoPropertiesMetadataSource(map), this.m_logger);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.FUNCTION_COLUMNS_JDBC4, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            return this.createMetaDataResult(MetadataSourceID.FUNCTIONS_JDBC4, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 4;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(104);
            return this.createListFromMap(STRING_FUNCTION_NAME_MAP, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(135);
            return this.createListFromMap(TIME_FUNCTION_NAME_MAP, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasStoredFunctionsCallsSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }
}

